/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.cache.texture;

import com.mojang.blaze3d.pipeline.RenderCall;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.ReloadableTexture;
import net.minecraft.client.renderer.texture.TextureContents;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import software.bernie.geckolib.GeckoLibServices;

public abstract class GeoAbstractTexture
extends ReloadableTexture {
    public GeoAbstractTexture(ResourceLocation resourceId) {
        super(resourceId);
    }

    protected static void generateTexture(ResourceLocation texturePath, Consumer<TextureManager> textureManagerConsumer) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            throw new IllegalThreadStateException("Texture loading called outside of the render thread! This should DEFINITELY not be happening.");
        }
        TextureManager textureManager = Minecraft.getInstance().getTextureManager();
        if (!(textureManager.getTexture(texturePath) instanceof GeoAbstractTexture)) {
            textureManagerConsumer.accept(textureManager);
        }
    }

    public TextureContents loadContents(ResourceManager resourceManager) throws IOException {
        return this.loadTexture(resourceManager, Minecraft.getInstance());
    }

    protected void printDebugImageToDisk(ResourceLocation id, NativeImage newImage) {
        try {
            File file = new File(GeckoLibServices.PLATFORM.getGameDir().toFile(), "GeoTexture Debug Printouts");
            if (!file.exists()) {
                file.mkdirs();
            } else if (!file.isDirectory()) {
                file.delete();
                file.mkdirs();
            }
            file = new File(file, id.getPath().replace('/', '.'));
            if (!file.exists()) {
                file.createNewFile();
            }
            newImage.writeToFile(file);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected abstract TextureContents loadTexture(ResourceManager var1, Minecraft var2) throws IOException;

    public static void uploadTexture(AbstractTexture texture, TextureContents textureContents) {
        GeoAbstractTexture.uploadTexture(texture, textureContents.image(), textureContents.clamp(), textureContents.blur(), 0, 0, textureContents.image().getWidth(), textureContents.image().getHeight(), true);
    }

    public static void uploadTexture(AbstractTexture texture, NativeImage image, boolean clamp, boolean blur, int skipXPixels, int skipYPixels, int width, int height, boolean autoClose) {
        texture.defaultBlur = blur;
        RenderCall uploadTask = () -> {
            TextureUtil.prepareImage((int)texture.getId(), (int)0, (int)width, (int)height);
            texture.setFilter(blur, false);
            texture.setClamp(clamp);
            image.upload(0, 0, 0, skipXPixels, skipYPixels, width, height, autoClose);
        };
        GeoAbstractTexture.runOnRenderThread(uploadTask);
    }

    public static void runOnRenderThread(RenderCall renderCall) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall((RenderCall)renderCall);
        } else {
            renderCall.execute();
        }
    }

    public static ResourceLocation appendToPath(ResourceLocation location, String suffix) {
        String path = location.getPath();
        int i = path.lastIndexOf(46);
        return ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)(path.substring(0, i) + suffix + path.substring(i)));
    }
}

