/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.cache.texture;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.CoreShaders;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ReloadableTexture;
import net.minecraft.client.renderer.texture.TextureContents;
import net.minecraft.client.resources.metadata.texture.TextureMetadataSection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceMetadata;
import net.minecraft.util.TriState;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.cache.texture.GeoAbstractTexture;
import software.bernie.geckolib.resource.GeoGlowingTextureMeta;

public class AutoGlowingTexture
extends GeoAbstractTexture {
    private static final RenderStateShard.ShaderStateShard SHADER_STATE = new RenderStateShard.ShaderStateShard(CoreShaders.RENDERTYPE_ENTITY_TRANSLUCENT_EMISSIVE);
    private static final RenderStateShard.TransparencyStateShard TRANSPARENCY_STATE = new RenderStateShard.TransparencyStateShard("translucent_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    private static final RenderStateShard.WriteMaskStateShard WRITE_MASK = new RenderStateShard.WriteMaskStateShard(true, true);
    private static final BiFunction<ResourceLocation, Boolean, RenderType> GLOWING_RENDER_TYPE = Util.memoize((texture, isGlowing) -> {
        RenderStateShard.TextureStateShard textureState = new RenderStateShard.TextureStateShard(texture, TriState.FALSE, false);
        return RenderType.create((String)"geo_glowing_layer", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(SHADER_STATE).setTextureState((RenderStateShard.EmptyTextureStateShard)textureState).setTransparencyState(TRANSPARENCY_STATE).setOverlayState(new RenderStateShard.OverlayStateShard(true)).setWriteMaskState(WRITE_MASK).createCompositeState(isGlowing.booleanValue()));
    });
    private static final String APPENDIX = "_glowmask";
    public static boolean PRINT_DEBUG_IMAGES = false;
    protected final ResourceLocation textureBase;

    public AutoGlowingTexture(ResourceLocation originalLocation, ResourceLocation location) {
        super(location);
        this.textureBase = originalLocation;
    }

    public static ResourceLocation getEmissiveResource(ResourceLocation baseResource) {
        ResourceLocation path = AutoGlowingTexture.appendToPath(baseResource, APPENDIX);
        AutoGlowingTexture.generateTexture(path, textureManager -> textureManager.registerAndLoad(path, (ReloadableTexture)new AutoGlowingTexture(baseResource, path)));
        return path;
    }

    @Override
    protected TextureContents loadTexture(ResourceManager resourceManager, Minecraft mc) throws IOException {
        NativeImage nativeImage;
        Resource baseTextureResource = resourceManager.getResourceOrThrow(this.textureBase);
        Optional glowmaskResource = resourceManager.getResource(this.resourceId());
        AbstractTexture baseTexture = mc.getTextureManager().getTexture(this.textureBase);
        if (baseTexture instanceof DynamicTexture) {
            DynamicTexture dynamicTexture = (DynamicTexture)baseTexture;
            nativeImage = dynamicTexture.getPixels();
        } else {
            nativeImage = null;
        }
        NativeImage baseImage = nativeImage;
        ResourceMetadata baseTextureMeta = baseTextureResource.metadata();
        TextureMetadataSection baseTextureMetaSection = baseTextureMeta.getSection(TextureMetadataSection.TYPE).orElse(null);
        if (baseImage == null) {
            try (InputStream stream = baseTextureResource.open();){
                baseImage = NativeImage.read((InputStream)stream);
            }
        }
        NativeImage referenceImage = baseImage;
        Pair contents = glowmaskResource.map(resource -> {
            NativeImage image;
            try (InputStream stream = resource.open();){
                image = NativeImage.read((InputStream)stream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return Pair.of((Object)image, (Object)GeoGlowingTextureMeta.fromExistingImage(image));
        }).orElseGet(() -> Pair.of((Object)new NativeImage(referenceImage.getWidth(), referenceImage.getHeight(), true), (Object)baseTextureMeta.getSection(GeoGlowingTextureMeta.TYPE).orElseGet(() -> {
            GeckoLibConstants.LOGGER.error("Attempting to use a glowmask but no glowmask or .png.mcmeta was found for texture: {}", (Object)this.textureBase);
            return new GeoGlowingTextureMeta(List.of());
        })));
        ((GeoGlowingTextureMeta)contents.right()).createImageMask(referenceImage, (NativeImage)contents.left());
        if (PRINT_DEBUG_IMAGES && GeckoLibServices.PLATFORM.isDevelopmentEnvironment()) {
            this.printDebugImageToDisk(this.textureBase, referenceImage);
            this.printDebugImageToDisk(this.resourceId(), (NativeImage)contents.left());
        }
        AbstractTexture abstractTexture = baseTexture;
        Objects.requireNonNull(abstractTexture);
        AbstractTexture abstractTexture2 = abstractTexture;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ReloadableTexture.class, DynamicTexture.class}, (Object)abstractTexture2, n)) {
            case 0: {
                ReloadableTexture reloadable = (ReloadableTexture)abstractTexture2;
                reloadable.apply(new TextureContents(referenceImage, baseTextureMetaSection));
                break;
            }
            case 1: {
                DynamicTexture dynamicTexture = (DynamicTexture)abstractTexture2;
                dynamicTexture.upload();
                break;
            }
            default: {
                AutoGlowingTexture.uploadTexture(baseTexture, new TextureContents(referenceImage, baseTextureMetaSection));
            }
        }
        return new TextureContents((NativeImage)contents.left(), baseTextureMetaSection);
    }

    public static RenderType getRenderType(ResourceLocation texture) {
        return GLOWING_RENDER_TYPE.apply(AutoGlowingTexture.getEmissiveResource(texture), false);
    }

    public static RenderType getOutlineRenderType(ResourceLocation texture) {
        return GLOWING_RENDER_TYPE.apply(AutoGlowingTexture.getEmissiveResource(texture), true);
    }
}

