/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.cache.texture;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureContents;
import net.minecraft.client.renderer.texture.Tickable;
import net.minecraft.client.resources.metadata.animation.AnimationFrame;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.client.resources.metadata.texture.TextureMetadataSection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceMetadata;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.cache.texture.GeoAbstractTexture;
import software.bernie.geckolib.util.RenderUtil;

public class AnimatableTexture
extends SimpleTexture
implements Tickable {
    private AnimationContents animationContents = null;
    private boolean isAnimated = false;

    public AnimatableTexture(ResourceLocation location) {
        super(location);
    }

    public boolean isAnimated() {
        return this.isAnimated;
    }

    public TextureContents loadContents(ResourceManager resourceManager) throws IOException {
        TextureContents textureContents;
        Resource resource = resourceManager.getResourceOrThrow(this.resourceId());
        ResourceMetadata resourceMeta = resource.metadata();
        Optional animationMeta = resourceMeta.getSection(AnimationMetadataSection.TYPE);
        TextureMetadataSection textureMeta = resourceMeta.getSection(TextureMetadataSection.TYPE).orElse(null);
        if (animationMeta.isEmpty()) {
            NativeImage image = new NativeImage(1, 1, false);
            textureContents = new TextureContents(image, textureMeta);
            image.close();
        } else {
            NativeImage image;
            try (InputStream inputstream = resource.open();){
                image = NativeImage.read((InputStream)inputstream);
            }
            textureContents = new TextureContents(image, textureMeta);
            this.animationContents = new AnimationContents(image, (AnimationMetadataSection)animationMeta.get());
            if (this.animationContents.isValid()) {
                this.isAnimated = true;
                this.defaultBlur = textureContents.blur();
                this.tick();
            }
        }
        return textureContents;
    }

    public void apply(TextureContents textureContents) {
        this.tick();
    }

    public void doLoad(NativeImage image, boolean blur, boolean clamp) {
        TextureUtil.prepareImage((int)this.getId(), (int)0, (int)image.getWidth(), (int)image.getHeight());
        this.setFilter(blur, false);
        this.setClamp(clamp);
        image.upload(0, 0, 0, 0, 0, image.getWidth(), image.getHeight(), false);
    }

    public void tick() {
        this.setAnimationFrame((int)RenderUtil.getCurrentTick());
    }

    public void setAnimationFrame(int tick) {
        if (this.animationContents != null && this.animationContents.animatedTexture != null) {
            this.animationContents.animatedTexture.setCurrentFrame(tick);
        }
    }

    private class AnimationContents {
        private final FrameSize frameSize;
        @Nullable
        private final Texture animatedTexture;

        private AnimationContents(NativeImage image, AnimationMetadataSection animMeta) {
            this.frameSize = animMeta.calculateFrameSize(image.getWidth(), image.getHeight());
            this.animatedTexture = this.createTexture(image, animMeta);
        }

        private boolean isValid() {
            return this.animatedTexture != null;
        }

        @Nullable
        private Texture createTexture(NativeImage image, AnimationMetadataSection animMeta) {
            if (!Mth.isMultipleOf((int)image.getWidth(), (int)this.frameSize.width()) || !Mth.isMultipleOf((int)image.getHeight(), (int)this.frameSize.height())) {
                GeckoLibConstants.LOGGER.error("Image {} size {},{} is not multiple of frame size {},{}", (Object)AnimatableTexture.this.resourceId(), (Object)image.getWidth(), (Object)image.getHeight(), (Object)this.frameSize.width(), (Object)this.frameSize.height());
                return null;
            }
            int columns = image.getWidth() / this.frameSize.width();
            int rows = image.getHeight() / this.frameSize.height();
            int maxFrameCount = columns * rows;
            int defaultFrameTime = animMeta.defaultFrameTime();
            ObjectArrayList frames = new ObjectArrayList(animMeta.frames().map(List::size).orElse(maxFrameCount).intValue());
            animMeta.frames().ifPresentOrElse(arg_0 -> this.lambda$createTexture$0((List)frames, defaultFrameTime, maxFrameCount, arg_0), () -> AnimationContents.lambda$createTexture$1(maxFrameCount, (List)frames, defaultFrameTime));
            return frames.size() <= 1 ? null : new Texture(image, frames.toArray(new Frame[0]), columns, animMeta.interpolatedFrames(), this.animatedTexture != null && this.animatedTexture.clamp, this.animatedTexture != null && this.animatedTexture.blur);
        }

        private static /* synthetic */ void lambda$createTexture$1(int maxFrameCount, List frames, int defaultFrameTime) {
            for (int i = 0; i < maxFrameCount; ++i) {
                frames.add(new Frame(i, defaultFrameTime));
            }
        }

        private /* synthetic */ void lambda$createTexture$0(List frames, int defaultFrameTime, int maxFrameCount, List animFrames) {
            for (AnimationFrame frame : animFrames) {
                frames.add(new Frame(frame.index(), frame.timeOr(defaultFrameTime)));
            }
            int index = 0;
            IntOpenHashSet unusedFrames = new IntOpenHashSet();
            for (Frame frame : frames) {
                if (frame.time <= 0) {
                    GeckoLibConstants.LOGGER.warn("Invalid frame duration on sprite {} frame {}: {}", (Object)AnimatableTexture.this.resourceId(), (Object)index, (Object)frame.time);
                    unusedFrames.add(frame.index);
                } else if (frame.index < 0 || frame.index >= maxFrameCount) {
                    GeckoLibConstants.LOGGER.warn("Invalid frame index on sprite {} frame {}: {}", (Object)AnimatableTexture.this.resourceId(), (Object)index, (Object)frame.index);
                    unusedFrames.add(frame.index);
                }
                ++index;
            }
            if (!unusedFrames.isEmpty()) {
                GeckoLibConstants.LOGGER.warn("Unused frames in sprite {}: {}", (Object)AnimatableTexture.this.resourceId(), (Object)Arrays.toString(unusedFrames.toArray()));
            }
        }

        private class Texture
        implements AutoCloseable {
            private final NativeImage baseImage;
            private final Frame[] frames;
            private final int framePanelSize;
            private final boolean interpolating;
            private final NativeImage interpolatedFrame;
            private final int totalFrameTime;
            private final boolean clamp;
            private final boolean blur;
            private int currentFrame;
            private int currentSubframe;

            private Texture(NativeImage baseImage, Frame[] frames, int framePanelSize, boolean interpolating, boolean clamp, boolean blur) {
                this.baseImage = baseImage;
                this.frames = frames;
                this.framePanelSize = framePanelSize;
                this.interpolating = interpolating;
                this.interpolatedFrame = interpolating ? new NativeImage(AnimationContents.this.frameSize.width(), AnimationContents.this.frameSize.height(), false) : null;
                this.clamp = clamp;
                this.blur = blur;
                int time = 0;
                for (Frame frame : this.frames) {
                    time += frame.time;
                }
                this.totalFrameTime = time;
            }

            private int getFrameX(int frameIndex) {
                return frameIndex % this.framePanelSize;
            }

            private int getFrameY(int frameIndex) {
                return frameIndex / this.framePanelSize;
            }

            public void setCurrentFrame(int ticks) {
                if ((ticks %= this.totalFrameTime) == this.currentSubframe) {
                    return;
                }
                int lastSubframe = this.currentSubframe;
                int lastFrame = this.currentFrame;
                int time = 0;
                for (Frame frame : this.frames) {
                    if (ticks >= (time += frame.time)) continue;
                    this.currentFrame = frame.index;
                    this.currentSubframe = ticks % frame.time;
                    break;
                }
                if (this.currentFrame != lastFrame && this.currentSubframe == 0) {
                    int frameWidth = AnimationContents.this.frameSize.width();
                    int frameHeight = AnimationContents.this.frameSize.height();
                    GeoAbstractTexture.uploadTexture((AbstractTexture)AnimatableTexture.this, this.baseImage, this.clamp, this.blur, this.getFrameX(this.currentFrame) * frameWidth, this.getFrameY(this.currentFrame) * frameHeight, frameWidth, frameHeight, false);
                } else if (this.currentSubframe != lastSubframe && this.interpolating) {
                    GeoAbstractTexture.runOnRenderThread(this::generateInterpolatedFrame);
                }
            }

            private void generateInterpolatedFrame() {
                Frame frame = this.frames[this.currentFrame];
                double frameProgress = 1.0 - (double)this.currentSubframe / (double)frame.time;
                int nextFrameIndex = this.frames[(this.currentFrame + 1) % this.frames.length].index;
                if (frame.index != nextFrameIndex) {
                    for (int y = 0; y < this.interpolatedFrame.getHeight(); ++y) {
                        for (int x = 0; x < this.interpolatedFrame.getWidth(); ++x) {
                            int prevFramePixel = this.getPixel(frame.index, x, y);
                            int nextFramePixel = this.getPixel(nextFrameIndex, x, y);
                            int blendedRed = this.interpolate(frameProgress, prevFramePixel >> 16 & 0xFF, nextFramePixel >> 16 & 0xFF);
                            int blendedGreen = this.interpolate(frameProgress, prevFramePixel >> 8 & 0xFF, nextFramePixel >> 8 & 0xFF);
                            int blendedBlue = this.interpolate(frameProgress, prevFramePixel & 0xFF, nextFramePixel & 0xFF);
                            this.interpolatedFrame.setPixel(x, y, prevFramePixel & 0xFF000000 | blendedRed << 16 | blendedGreen << 8 | blendedBlue);
                        }
                    }
                    GeoAbstractTexture.uploadTexture((AbstractTexture)AnimatableTexture.this, this.interpolatedFrame, this.clamp, this.blur, 0, 0, AnimationContents.this.frameSize.width(), AnimationContents.this.frameSize.height(), false);
                }
            }

            private int getPixel(int frameIndex, int x, int y) {
                return this.baseImage.getPixel(x + this.getFrameX(frameIndex) * AnimationContents.this.frameSize.width(), y + this.getFrameY(frameIndex) * AnimationContents.this.frameSize.height());
            }

            private int interpolate(double frameProgress, double prevColor, double nextColor) {
                return (int)(frameProgress * prevColor + (1.0 - frameProgress) * nextColor);
            }

            @Override
            public void close() {
                this.baseImage.close();
                if (this.interpolatedFrame != null) {
                    this.interpolatedFrame.close();
                }
            }
        }

        private record Frame(int index, int time) {
        }
    }
}

