/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.platform;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.service.GeckoLibClient;

public final class GeckoLibClientForge
implements GeckoLibClient {
    @Override
    @NotNull
    public <T extends LivingEntity> HumanoidModel<?> getArmorModelForItem(T animatable, ItemStack stack, EquipmentSlot slot, HumanoidModel<LivingEntity> defaultModel) {
        HumanoidModel<?> humanoidModel;
        Item item = stack.getItem();
        HumanoidModel model = IClientItemExtensions.of((Item)item).getHumanoidArmorModel(animatable, stack, slot, defaultModel);
        if (model == defaultModel && (humanoidModel = GeoRenderProvider.of(item).getGeoArmorRenderer(animatable, stack, slot, defaultModel)) instanceof GeoArmorRenderer) {
            GeoArmorRenderer geoArmorRenderer = (GeoArmorRenderer)humanoidModel;
            return geoArmorRenderer;
        }
        return model;
    }

    @Override
    @Nullable
    public GeoModel<?> getGeoModelForItem(ItemStack item) {
        BlockEntityWithoutLevelRenderer blockEntityWithoutLevelRenderer = IClientItemExtensions.of((ItemStack)item).getCustomRenderer();
        if (blockEntityWithoutLevelRenderer instanceof GeoRenderer) {
            GeoRenderer geoRenderer = (GeoRenderer)blockEntityWithoutLevelRenderer;
            return geoRenderer.getGeoModel();
        }
        blockEntityWithoutLevelRenderer = GeoRenderProvider.of(item).getGeoItemRenderer();
        if (blockEntityWithoutLevelRenderer instanceof GeoRenderer) {
            GeoRenderer geoRenderer = (GeoRenderer)blockEntityWithoutLevelRenderer;
            return geoRenderer.getGeoModel();
        }
        return null;
    }

    @Override
    @Nullable
    public GeoModel<?> getGeoModelForArmor(ItemStack armour) {
        HumanoidModel<?> humanoidModel = IClientItemExtensions.of((ItemStack)armour).getHumanoidArmorModel(null, armour, null, null);
        if (humanoidModel instanceof GeoArmorRenderer) {
            GeoArmorRenderer armorRenderer = (GeoArmorRenderer)humanoidModel;
            return armorRenderer.getGeoModel();
        }
        humanoidModel = GeoRenderProvider.of(armour).getGeoArmorRenderer(null, armour, null, null);
        if (humanoidModel instanceof GeoArmorRenderer) {
            GeoArmorRenderer armorRenderer = (GeoArmorRenderer)humanoidModel;
            return armorRenderer.getGeoModel();
        }
        return null;
    }
}

