/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.util;

import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.io.InputStream;
import net.minecraft.class_10042;
import net.minecraft.class_1011;
import net.minecraft.class_10186;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_10442;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2190;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3532;
import net.minecraft.class_3673;
import net.minecraft.class_4050;
import net.minecraft.class_4587;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.minecraft.class_897;
import net.minecraft.class_922;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import net.minecraft.class_970;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.GeoReplacedEntityRenderer;

public final class RenderUtil {
    public static void translateMatrixToBone(class_4587 poseStack, GeoBone bone) {
        poseStack.method_46416(-bone.getPosX() / 16.0f, bone.getPosY() / 16.0f, bone.getPosZ() / 16.0f);
    }

    public static void rotateMatrixAroundBone(class_4587 poseStack, GeoBone bone) {
        if (bone.getRotZ() != 0.0f) {
            poseStack.method_22907(class_7833.field_40718.rotation(bone.getRotZ()));
        }
        if (bone.getRotY() != 0.0f) {
            poseStack.method_22907(class_7833.field_40716.rotation(bone.getRotY()));
        }
        if (bone.getRotX() != 0.0f) {
            poseStack.method_22907(class_7833.field_40714.rotation(bone.getRotX()));
        }
    }

    public static void rotateMatrixAroundCube(class_4587 poseStack, GeoCube cube) {
        class_243 rotation = cube.rotation();
        poseStack.method_22907(new Quaternionf().rotationXYZ(0.0f, 0.0f, (float)rotation.method_10215()));
        poseStack.method_22907(new Quaternionf().rotationXYZ(0.0f, (float)rotation.method_10214(), 0.0f));
        poseStack.method_22907(new Quaternionf().rotationXYZ((float)rotation.method_10216(), 0.0f, 0.0f));
    }

    public static void scaleMatrixForBone(class_4587 poseStack, GeoBone bone) {
        poseStack.method_22905(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
    }

    public static void translateToPivotPoint(class_4587 poseStack, GeoCube cube) {
        class_243 pivot = cube.pivot();
        poseStack.method_22904(pivot.method_10216() / 16.0, pivot.method_10214() / 16.0, pivot.method_10215() / 16.0);
    }

    public static void translateToPivotPoint(class_4587 poseStack, GeoBone bone) {
        poseStack.method_46416(bone.getPivotX() / 16.0f, bone.getPivotY() / 16.0f, bone.getPivotZ() / 16.0f);
    }

    public static void translateAwayFromPivotPoint(class_4587 poseStack, GeoCube cube) {
        class_243 pivot = cube.pivot();
        poseStack.method_22904(-pivot.method_10216() / 16.0, -pivot.method_10214() / 16.0, -pivot.method_10215() / 16.0);
    }

    public static void translateAwayFromPivotPoint(class_4587 poseStack, GeoBone bone) {
        poseStack.method_46416(-bone.getPivotX() / 16.0f, -bone.getPivotY() / 16.0f, -bone.getPivotZ() / 16.0f);
    }

    public static void translateAndRotateMatrixForBone(class_4587 poseStack, GeoBone bone) {
        RenderUtil.translateToPivotPoint(poseStack, bone);
        RenderUtil.rotateMatrixAroundBone(poseStack, bone);
    }

    public static void prepMatrixForBone(class_4587 poseStack, GeoBone bone) {
        RenderUtil.translateMatrixToBone(poseStack, bone);
        RenderUtil.translateToPivotPoint(poseStack, bone);
        RenderUtil.rotateMatrixAroundBone(poseStack, bone);
        RenderUtil.scaleMatrixForBone(poseStack, bone);
        RenderUtil.translateAwayFromPivotPoint(poseStack, bone);
    }

    public static Matrix4f invertAndMultiplyMatrices(Matrix4f baseMatrix, Matrix4f inputMatrix) {
        inputMatrix = new Matrix4f((Matrix4fc)inputMatrix);
        inputMatrix.invert();
        inputMatrix.mul((Matrix4fc)baseMatrix);
        return inputMatrix;
    }

    public static void faceRotation(class_4587 poseStack, class_1297 animatable, float partialTick) {
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(class_3532.method_16439((float)partialTick, (float)animatable.field_5982, (float)animatable.method_36454()) - 90.0f));
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(class_3532.method_16439((float)partialTick, (float)animatable.field_6004, (float)animatable.method_36455())));
    }

    public static Matrix4f translateMatrix(Matrix4f matrix, Vector3f vector) {
        return matrix.add((Matrix4fc)new Matrix4f().m30(vector.x).m31(vector.y).m32(vector.z));
    }

    @Nullable
    public static IntIntPair getTextureDimensions(class_2960 texture) {
        if (texture == null) {
            return null;
        }
        class_1044 originalTexture = null;
        class_310 mc = class_310.method_1551();
        try {
            originalTexture = (class_1044)mc.method_5385(() -> mc.method_1531().method_4619(texture)).get();
        }
        catch (Exception e) {
            GeckoLibConstants.LOGGER.warn("Failed to load image for id {}", (Object)texture);
            e.printStackTrace();
        }
        if (originalTexture == null) {
            return null;
        }
        class_1011 image = null;
        try {
            class_1011 class_10112;
            if (originalTexture instanceof class_1043) {
                class_1043 dynamicTexture = (class_1043)originalTexture;
                class_10112 = dynamicTexture.method_4525();
            } else {
                class_10112 = class_1011.method_4309((InputStream)((class_3298)mc.method_1478().method_14486(texture).get()).method_14482());
            }
            image = class_10112;
        }
        catch (Exception e) {
            GeckoLibConstants.LOGGER.error("Failed to read image for id {}", (Object)texture);
            e.printStackTrace();
        }
        return image == null ? null : IntIntImmutablePair.of((int)image.method_4307(), (int)image.method_4323());
    }

    public static double getCurrentSystemTick() {
        return (double)System.nanoTime() / 1000000.0 / 50.0;
    }

    public static double getCurrentTick() {
        return class_3673.method_15974() * 20.0;
    }

    public static float booleanToFloat(boolean input) {
        return input ? 1.0f : 0.0f;
    }

    public static class_243 arrayToVec(double[] array) {
        return new class_243(array[0], array[1], array[2]);
    }

    public static void matchModelPartRot(class_630 from, GeoBone to) {
        to.updateRotation(-from.field_3654, -from.field_3675, from.field_3674);
    }

    public static void fixInvertedFlatCube(GeoCube cube, Vector3f normal) {
        if (normal.x() < 0.0f && (cube.size().method_10214() == 0.0 || cube.size().method_10215() == 0.0)) {
            normal.mul(-1.0f, 1.0f, 1.0f);
        }
        if (normal.y() < 0.0f && (cube.size().method_10216() == 0.0 || cube.size().method_10215() == 0.0)) {
            normal.mul(1.0f, -1.0f, 1.0f);
        }
        if (normal.z() < 0.0f && (cube.size().method_10216() == 0.0 || cube.size().method_10214() == 0.0)) {
            normal.mul(1.0f, 1.0f, -1.0f);
        }
    }

    public static float getDirectionAngle(class_2350 direction) {
        return switch (direction) {
            case class_2350.field_11035 -> 90.0f;
            case class_2350.field_11043 -> 270.0f;
            case class_2350.field_11034 -> 180.0f;
            default -> 0.0f;
        };
    }

    public static double lerpYaw(double delta, double start, double end) {
        double diff = (start = class_3532.method_15338((double)start)) - (end = class_3532.method_15338((double)end));
        end = diff > 180.0 || diff < -180.0 ? start + Math.copySign(360.0 - Math.abs(diff), diff) : end;
        return class_3532.method_16436((double)delta, (double)start, (double)end);
    }

    @Nullable
    public static GeoModel<?> getGeoModelForEntityType(class_1299<?> entityType) {
        GeoModel geoModel;
        Object v = class_310.method_1551().method_1561().field_4696.get(entityType);
        if (v instanceof GeoRenderer) {
            GeoRenderer geoRenderer = (GeoRenderer)v;
            geoModel = geoRenderer.getGeoModel();
        } else {
            geoModel = null;
        }
        return geoModel;
    }

    @Nullable
    public static GeoAnimatable getReplacedAnimatable(class_1299<?> entityType) {
        GeoAnimatable geoAnimatable;
        Object v = class_310.method_1551().method_1561().field_4696.get(entityType);
        if (v instanceof GeoReplacedEntityRenderer) {
            GeoReplacedEntityRenderer replacedEntityRenderer = (GeoReplacedEntityRenderer)v;
            geoAnimatable = (GeoAnimatable)replacedEntityRenderer.getAnimatable();
        } else {
            geoAnimatable = null;
        }
        return geoAnimatable;
    }

    @Nullable
    public static GeoModel<?> getGeoModelForEntity(class_1297 entity) {
        GeoModel geoModel;
        class_897 class_8972 = class_310.method_1551().method_1561().method_3953(entity);
        if (class_8972 instanceof GeoRenderer) {
            GeoRenderer geoRenderer = (GeoRenderer)class_8972;
            geoModel = geoRenderer.getGeoModel();
        } else {
            geoModel = null;
        }
        return geoModel;
    }

    @Nullable
    public static GeoModel<?> getGeoModelForItem(class_1799 item) {
        return GeckoLibServices.Client.ITEM_RENDERING.getGeoModelForItem(item);
    }

    @Nullable
    public static GeoModel<?> getGeoModelForBlock(class_2586 blockEntity) {
        GeoModel geoModel;
        class_827 renderer = class_310.method_1551().method_31975().method_3550(blockEntity);
        if (renderer instanceof GeoRenderer) {
            GeoRenderer geoRenderer = (GeoRenderer)renderer;
            geoModel = geoRenderer.getGeoModel();
        } else {
            geoModel = null;
        }
        return geoModel;
    }

    @Nullable
    public static GeoModel<?> getGeoModelForArmor(class_1799 stack, class_1304 slot, class_10186.class_10190 type) {
        return GeckoLibServices.Client.ITEM_RENDERING.getGeoModelForArmor(stack, slot, type);
    }

    public static void prepLivingEntityRenderState(class_1309 entity, class_10042 entityRenderState, float partialTick, class_10442 itemModelResolver) {
        class_1747 headItem;
        class_310 minecraft = class_310.method_1551();
        float yHeadRot = class_3532.method_17821((float)partialTick, (float)entity.field_6259, (float)entity.field_6241);
        class_1799 headStack = entity.method_6118(class_1304.field_6169);
        entityRenderState.field_53446 = class_922.method_62482((class_1309)entity, (float)yHeadRot, (float)partialTick);
        entityRenderState.field_53447 = class_3532.method_15393((float)(yHeadRot - entityRenderState.field_53446));
        entityRenderState.field_53448 = entity.method_61414(partialTick);
        entityRenderState.field_53464 = entity.method_5797();
        entityRenderState.field_53455 = class_922.method_38563((class_1309)entity);
        if (entityRenderState.field_53455) {
            entityRenderState.field_53448 *= -1.0f;
            entityRenderState.field_53447 *= -1.0f;
        }
        if (!entity.method_5765() && entity.method_5805()) {
            entityRenderState.field_53450 = entity.field_42108.method_48572(partialTick);
            entityRenderState.field_53451 = entity.field_42108.method_48570(partialTick);
        } else {
            entityRenderState.field_53450 = 0.0f;
            entityRenderState.field_53451 = 0.0f;
        }
        class_1297 class_12972 = entity.method_5854();
        if (class_12972 instanceof class_1309) {
            class_1309 livingVehicle = (class_1309)class_12972;
            entityRenderState.field_53452 = livingVehicle.field_42108.method_48572(partialTick);
        } else {
            entityRenderState.field_53452 = entityRenderState.field_53450;
        }
        entityRenderState.field_53453 = entity.method_55693();
        entityRenderState.field_53454 = entity.method_17825();
        entityRenderState.field_53465 = entity.method_18376();
        entityRenderState.field_53463 = entity.method_18401();
        if (entityRenderState.field_53463 != null) {
            entityRenderState.field_53331 = entity.method_18381(class_4050.field_18076);
        }
        entityRenderState.field_53456 = entity.method_32314();
        entityRenderState.field_53457 = entity.method_6109();
        entityRenderState.field_53458 = entity.method_5799();
        entityRenderState.field_53459 = entity.method_6123();
        entityRenderState.field_53460 = entity.field_6235 > 0 || entity.field_6213 > 0;
        class_1792 class_17922 = headStack.method_7909();
        if (class_17922 instanceof class_1747 && (class_17922 = (headItem = (class_1747)class_17922).method_7711()) instanceof class_2190) {
            class_2190 skullBlock = (class_2190)class_17922;
            entityRenderState.field_55315 = skullBlock.method_9327();
            entityRenderState.field_55316 = (class_9296)headStack.method_57824(class_9334.field_49617);
            entityRenderState.field_53467.method_65605();
        } else {
            entityRenderState.field_55315 = null;
            entityRenderState.field_55316 = null;
            if (!class_970.method_64081((class_1799)headStack, (class_1304)class_1304.field_6169)) {
                itemModelResolver.method_65597(entityRenderState.field_53467, headStack, class_811.field_4316, false, entity);
            } else {
                entityRenderState.field_53467.method_65605();
            }
        }
        entityRenderState.field_53449 = entity.field_6213 > 0 ? (float)entity.field_6213 + partialTick : 0.0f;
        entityRenderState.field_53461 = entityRenderState.field_53333 && entity.method_5756((class_1657)minecraft.field_1724);
        entityRenderState.field_53462 = minecraft.method_27022((class_1297)entity);
    }
}

