/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5599;
import net.minecraft.class_811;
import net.minecraft.class_824;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeckolibSpecialRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayersContainer;
import software.bernie.geckolib.util.RenderUtil;

public class GeoItemRenderer<T extends class_1792>
implements GeoRenderer<T> {
    protected final GeoRenderLayersContainer<T> renderLayers = new GeoRenderLayersContainer(this);
    protected final GeoModel<T> model;
    protected class_1799 currentItemStack;
    protected class_811 renderPerspective;
    protected T animatable;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;
    protected boolean useEntityGuiLighting = false;
    protected Matrix4f itemRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public GeoItemRenderer(GeoModel<T> model) {
        this(class_310.method_1551().method_31975(), class_310.method_1551().method_31974(), model);
    }

    public GeoItemRenderer(class_824 dispatcher, class_5599 modelSet, GeoModel<T> model) {
        this.model = model;
    }

    @Override
    public GeoModel<T> getGeoModel() {
        return this.model;
    }

    @Override
    public T getAnimatable() {
        return this.animatable;
    }

    public class_1799 getCurrentItemStack() {
        return this.currentItemStack;
    }

    public GeoItemRenderer<T> useAlternateGuiLighting() {
        this.useEntityGuiLighting = true;
        return this;
    }

    @Override
    public long getInstanceId(T animatable) {
        return GeoItem.getId(this.currentItemStack);
    }

    @Override
    public List<GeoRenderLayer<T>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    public GeoItemRenderer<T> addRenderLayer(GeoRenderLayer<T> renderLayer) {
        this.renderLayers.addLayer(renderLayer);
        return this;
    }

    public GeoItemRenderer<T> withScale(float scale) {
        return this.withScale(scale, scale);
    }

    public GeoItemRenderer<T> withScale(float scaleWidth, float scaleHeight) {
        this.scaleWidth = scaleWidth;
        this.scaleHeight = scaleHeight;
        return this;
    }

    @Override
    public void preRender(class_4587 poseStack, T animatable, BakedGeoModel model, @Nullable class_4597 bufferSource, @Nullable class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int renderColor) {
        this.itemRenderTranslations = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        this.scaleModelForRender(this.scaleWidth, this.scaleHeight, poseStack, animatable, model, isReRender, partialTick, packedLight, packedOverlay);
        if (!isReRender) {
            poseStack.method_46416(0.5f, 0.51f, 0.5f);
        }
    }

    public void render(GeckolibSpecialRenderer.RenderData renderData, class_811 transformType, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay, boolean hasGlint) {
        this.animatable = renderData.item();
        this.currentItemStack = renderData.itemstack();
        this.renderPerspective = transformType;
        float partialTick = class_310.method_1551().method_61966().method_60637(true);
        if (transformType == class_811.field_4317) {
            this.renderInGui(transformType, poseStack, bufferSource, packedLight, packedOverlay, partialTick);
        } else {
            class_1921 renderType = this.getRenderType(this.animatable, this.getTextureLocation(this.animatable), bufferSource, partialTick);
            class_4588 buffer = renderType == null ? null : class_918.method_23181((class_4597)bufferSource, (class_1921)renderType, (boolean)false, (this.currentItemStack != null && this.currentItemStack.method_7958() ? 1 : 0) != 0);
            this.defaultRender(poseStack, this.animatable, bufferSource, renderType, buffer, partialTick, packedLight);
        }
        this.animatable = null;
    }

    protected void renderInGui(class_811 transformType, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay, float partialTick) {
        class_4597.class_4598 bufferSource2;
        this.setupLightingForGuiRender();
        class_4597.class_4598 defaultBufferSource = bufferSource instanceof class_4597.class_4598 ? (bufferSource2 = (class_4597.class_4598)bufferSource) : class_310.method_1551().field_1769.field_20951.method_23000();
        class_1921 renderType = this.getRenderType(this.animatable, this.getTextureLocation(this.animatable), (class_4597)defaultBufferSource, partialTick);
        class_4588 buffer = class_918.method_23181((class_4597)bufferSource, (class_1921)renderType, (boolean)true, (this.currentItemStack != null && this.currentItemStack.method_7958() ? 1 : 0) != 0);
        poseStack.method_22903();
        this.defaultRender(poseStack, this.animatable, (class_4597)defaultBufferSource, renderType, buffer, partialTick, packedLight);
        defaultBufferSource.method_22993();
        RenderSystem.enableDepthTest();
        class_308.method_24211();
        poseStack.method_22909();
    }

    @Override
    public void actuallyRender(class_4587 poseStack, T animatable, BakedGeoModel model, @Nullable class_1921 renderType, class_4597 bufferSource, @Nullable class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int renderColor) {
        if (!isReRender) {
            long instanceId = this.getInstanceId(animatable);
            ((GeoAnimatable)animatable).getAnimatableInstanceCache().getManagerForId(instanceId).setData(DataTickets.ITEM_RENDER_PERSPECTIVE, this.renderPerspective);
            this.getGeoModel().handleAnimations(animatable, instanceId, this.createAnimationState(animatable, instanceId, 0.0f, 0.0f, partialTick, false), partialTick);
        }
        this.modelRenderTranslations = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        if (buffer != null) {
            GeoRenderer.super.actuallyRender(poseStack, animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, renderColor);
        }
    }

    @Override
    public AnimationState<T> createAnimationState(T animatable, long instanceId, float limbSwing, float limbSwingAmount, float partialTick, boolean isMoving) {
        AnimationState<T> animationState = GeoRenderer.super.createAnimationState(animatable, instanceId, limbSwing, limbSwingAmount, partialTick, isMoving);
        animationState.setData(DataTickets.TICK, ((GeoAnimatable)animatable).getTick(this.currentItemStack));
        animationState.setData(DataTickets.ITEM_RENDER_PERSPECTIVE, this.renderPerspective);
        animationState.setData(DataTickets.ITEMSTACK, this.currentItemStack);
        return animationState;
    }

    @Override
    public void doPostRenderCleanup() {
        this.animatable = null;
        this.currentItemStack = null;
        this.renderPerspective = null;
    }

    @Override
    public void renderRecursively(class_4587 poseStack, T animatable, GeoBone bone, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int renderColor) {
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
            bone.setModelSpaceMatrix(RenderUtil.invertAndMultiplyMatrices(poseState, this.modelRenderTranslations));
            bone.setLocalSpaceMatrix(RenderUtil.invertAndMultiplyMatrices(poseState, this.itemRenderTranslations));
        }
        GeoRenderer.super.renderRecursively(poseStack, animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, renderColor);
    }

    public void setupLightingForGuiRender() {
        if (this.useEntityGuiLighting) {
            class_308.method_34742();
        } else {
            class_308.method_24210();
        }
    }

    @Override
    public void fireCompileRenderLayersEvent() {
        GeckoLibServices.Client.EVENTS.fireCompileItemRenderLayers(this);
    }

    @Override
    public boolean firePreRenderEvent(class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource, float partialTick, int packedLight) {
        return GeckoLibServices.Client.EVENTS.fireItemPreRender(this, poseStack, model, bufferSource, partialTick, packedLight);
    }

    @Override
    public void firePostRenderEvent(class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource, float partialTick, int packedLight) {
        GeckoLibServices.Client.EVENTS.fireItemPostRender(this, poseStack, model, bufferSource, partialTick, packedLight);
    }
}

