/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer;

import java.util.List;
import net.minecraft.class_10017;
import net.minecraft.class_10042;
import net.minecraft.class_10442;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_268;
import net.minecraft.class_270;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import net.minecraft.class_922;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;
import software.bernie.geckolib.object.Color;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayersContainer;
import software.bernie.geckolib.util.ClientUtil;
import software.bernie.geckolib.util.RenderUtil;

public class GeoEntityRenderer<T extends class_1297>
extends class_897<T, class_10017>
implements GeoRenderer<T> {
    protected final GeoRenderLayersContainer<T> renderLayers = new GeoRenderLayersContainer(this);
    protected final GeoModel<T> model;
    protected final class_10442 itemModelResolver;
    protected T animatable;
    protected float partialTick;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;
    protected Matrix4f entityRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public GeoEntityRenderer(class_5617.class_5618 context, GeoModel<T> model) {
        super(context);
        this.model = model;
        this.itemModelResolver = context.method_65566();
    }

    @Override
    public GeoModel<T> getGeoModel() {
        return this.model;
    }

    @Override
    public T getAnimatable() {
        return this.animatable;
    }

    public class_10017 getEntityRenderState() {
        return this.field_53189;
    }

    @Override
    public long getInstanceId(T animatable) {
        return animatable.method_5628();
    }

    @Override
    public List<GeoRenderLayer<T>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    public GeoEntityRenderer<T> addRenderLayer(GeoRenderLayer<T> renderLayer) {
        this.renderLayers.addLayer(renderLayer);
        return this;
    }

    public GeoEntityRenderer<T> withScale(float scale) {
        return this.withScale(scale, scale);
    }

    public GeoEntityRenderer<T> withScale(float scaleWidth, float scaleHeight) {
        this.scaleWidth = scaleWidth;
        this.scaleHeight = scaleHeight;
        return this;
    }

    @Override
    public Color getRenderColor(T animatable, float partialTick, int packedLight) {
        Color color = GeoRenderer.super.getRenderColor(animatable, partialTick, packedLight);
        if (animatable.method_5767() && !animatable.method_5756(ClientUtil.getClientPlayer())) {
            color = Color.ofARGB(class_3532.method_15386((float)((float)(color.getAlpha() * 38) / 255.0f)), color.getRed(), color.getGreen(), color.getBlue());
        }
        return color;
    }

    @Override
    @Nullable
    public class_1921 getRenderType(T animatable, class_2960 texture, @Nullable class_4597 bufferSource, float partialTick) {
        boolean invisible = animatable.method_5767();
        if (invisible && !animatable.method_5756(ClientUtil.getClientPlayer())) {
            return class_1921.method_29379((class_2960)texture);
        }
        if (!invisible) {
            return GeoRenderer.super.getRenderType(animatable, texture, bufferSource, partialTick);
        }
        return class_310.method_1551().method_27022(animatable) ? class_1921.method_23287((class_2960)texture) : null;
    }

    @Override
    public void preRender(class_4587 poseStack, T animatable, BakedGeoModel model, @Nullable class_4597 bufferSource, @Nullable class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int renderColor) {
        this.entityRenderTranslations = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        this.scaleModelForRender(this.scaleWidth, this.scaleHeight, poseStack, (GeoAnimatable)animatable, model, isReRender, partialTick, packedLight, packedOverlay);
    }

    public void method_3936(class_10017 entityRenderState, class_4587 poseStack, class_4597 bufferSource, int packedLight) {
        this.defaultRender(poseStack, (GeoAnimatable)this.animatable, bufferSource, null, null, this.partialTick, packedLight);
    }

    @Override
    public void actuallyRender(class_4587 poseStack, T animatable, BakedGeoModel model, @Nullable class_1921 renderType, class_4597 bufferSource, @Nullable class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int renderColor) {
        class_2350 bedDirection;
        class_1297 class_12972;
        class_1309 entity;
        poseStack.method_22903();
        class_1309 livingEntity = animatable instanceof class_1309 ? (entity = (class_1309)animatable) : null;
        boolean shouldSit = animatable.method_5765() && animatable.method_5854() != null;
        float lerpBodyRot = livingEntity == null ? 0.0f : class_3532.method_17821((float)partialTick, (float)livingEntity.field_6220, (float)livingEntity.field_6283);
        float lerpHeadRot = livingEntity == null ? 0.0f : class_3532.method_17821((float)partialTick, (float)livingEntity.field_6259, (float)livingEntity.field_6241);
        float netHeadYaw = lerpHeadRot - lerpBodyRot;
        if (shouldSit && (class_12972 = animatable.method_5854()) instanceof class_1309) {
            class_1309 livingentity = (class_1309)class_12972;
            lerpBodyRot = class_3532.method_17821((float)partialTick, (float)livingentity.field_6220, (float)livingentity.field_6283);
            netHeadYaw = lerpHeadRot - lerpBodyRot;
            float clampedHeadYaw = class_3532.method_15363((float)class_3532.method_15393((float)netHeadYaw), (float)-85.0f, (float)85.0f);
            lerpBodyRot = lerpHeadRot - clampedHeadYaw;
            if (clampedHeadYaw * clampedHeadYaw > 2500.0f) {
                lerpBodyRot += clampedHeadYaw * 0.2f;
            }
            netHeadYaw = lerpHeadRot - lerpBodyRot;
        }
        if (animatable.method_18376() == class_4050.field_18078 && livingEntity != null && (bedDirection = livingEntity.method_18401()) != null) {
            float eyePosOffset = livingEntity.method_18381(class_4050.field_18076) - 0.1f;
            poseStack.method_46416((float)(-bedDirection.method_10148()) * eyePosOffset, 0.0f, (float)(-bedDirection.method_10165()) * eyePosOffset);
        }
        float nativeScale = livingEntity != null ? livingEntity.method_55693() : 1.0f;
        float ageInTicks = (float)((class_1297)animatable).field_6012 + partialTick;
        float limbSwingAmount = 0.0f;
        float limbSwing = 0.0f;
        poseStack.method_22905(nativeScale, nativeScale, nativeScale);
        this.applyRotations(animatable, poseStack, ageInTicks, lerpBodyRot, partialTick, nativeScale);
        if (!shouldSit && animatable.method_5805() && livingEntity != null) {
            limbSwingAmount = livingEntity.field_42108.method_48570(partialTick);
            limbSwing = livingEntity.field_42108.method_48572(partialTick);
            if (livingEntity.method_6109()) {
                limbSwing *= 3.0f;
            }
            if (limbSwingAmount > 1.0f) {
                limbSwingAmount = 1.0f;
            }
        }
        if (!isReRender) {
            float motionThreshold = this.getMotionAnimThreshold((GeoAnimatable)animatable);
            class_243 velocity = animatable.method_18798();
            float avgVelocity = (float)((Math.abs(velocity.field_1352) + Math.abs(velocity.field_1350)) / 2.0);
            float headPitch = class_3532.method_16439((float)partialTick, (float)((class_1297)animatable).field_6004, (float)animatable.method_36455());
            long instanceId = this.getInstanceId(animatable);
            AnimationState<T> animationState = this.createAnimationState(animatable, instanceId, limbSwing, limbSwingAmount, partialTick, avgVelocity >= motionThreshold && limbSwingAmount != 0.0f);
            animationState.setData(DataTickets.ENTITY_MODEL_DATA, new EntityModelData(shouldSit, livingEntity != null && livingEntity.method_6109(), -netHeadYaw, -headPitch));
            this.getGeoModel().handleAnimations(animatable, instanceId, animationState, partialTick);
        }
        poseStack.method_46416(0.0f, 0.01f, 0.0f);
        this.modelRenderTranslations = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        if (buffer != null) {
            GeoRenderer.super.actuallyRender(poseStack, animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, renderColor);
        }
        poseStack.method_22909();
    }

    @Override
    public AnimationState<T> createAnimationState(T animatable, long instanceId, float limbSwing, float limbSwingAmount, float partialTick, boolean isMoving) {
        AnimationState<T> animationState = GeoRenderer.super.createAnimationState(animatable, instanceId, limbSwing, limbSwingAmount, partialTick, isMoving);
        animationState.setData(DataTickets.TICK, ((GeoAnimatable)animatable).getTick(animatable));
        animationState.setData(DataTickets.ENTITY, animatable);
        return animationState;
    }

    @Override
    public void applyRenderLayers(class_4587 poseStack, T animatable, BakedGeoModel model, @Nullable class_1921 renderType, class_4597 bufferSource, @Nullable class_4588 buffer, float partialTick, int packedLight, int packedOverlay, int renderColor) {
        if (!animatable.method_7325()) {
            GeoRenderer.super.applyRenderLayers(poseStack, animatable, model, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay, renderColor);
        }
    }

    @Override
    public void renderFinal(class_4587 poseStack, T animatable, BakedGeoModel model, class_4597 bufferSource, @Nullable class_4588 buffer, float partialTick, int packedLight, int packedOverlay, int renderColor) {
        super.method_3936(this.getEntityRenderState(), poseStack, bufferSource, packedLight);
    }

    @Override
    public void doPostRenderCleanup() {
        this.animatable = null;
        this.entityRenderTranslations = null;
        this.modelRenderTranslations = null;
    }

    @Override
    public void renderRecursively(class_4587 poseStack, T animatable, GeoBone bone, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int renderColor) {
        poseStack.method_22903();
        RenderUtil.translateMatrixToBone(poseStack, bone);
        RenderUtil.translateToPivotPoint(poseStack, bone);
        RenderUtil.rotateMatrixAroundBone(poseStack, bone);
        RenderUtil.scaleMatrixForBone(poseStack, bone);
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
            Matrix4f localMatrix = RenderUtil.invertAndMultiplyMatrices(poseState, this.entityRenderTranslations);
            bone.setModelSpaceMatrix(RenderUtil.invertAndMultiplyMatrices(poseState, this.modelRenderTranslations));
            bone.setLocalSpaceMatrix(RenderUtil.translateMatrix(localMatrix, this.method_23169(this.getEntityRenderState()).method_46409()));
            bone.setWorldSpaceMatrix(RenderUtil.translateMatrix(new Matrix4f((Matrix4fc)localMatrix), this.animatable.method_19538().method_46409()));
        }
        RenderUtil.translateAwayFromPivotPoint(poseStack, bone);
        buffer = this.checkAndRefreshBuffer(isReRender, buffer, bufferSource, renderType);
        this.renderCubesOfBone(poseStack, bone, buffer, packedLight, packedOverlay, renderColor);
        if (!isReRender) {
            this.applyRenderLayersForBone(poseStack, (GeoAnimatable)animatable, bone, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay, renderColor);
        }
        this.renderChildBones(poseStack, (GeoAnimatable)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, renderColor);
        poseStack.method_22909();
    }

    protected void applyRotations(T animatable, class_4587 poseStack, float ageInTicks, float rotationYaw, float partialTick, float nativeScale) {
        if (this.isShaking(animatable)) {
            rotationYaw += (float)(Math.cos((double)((class_1297)animatable).field_6012 * 3.25) * Math.PI * 0.4);
        }
        if (!animatable.method_41328(class_4050.field_18078)) {
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - rotationYaw));
        }
        if (animatable instanceof class_1309) {
            class_1309 livingEntity = (class_1309)animatable;
            if (livingEntity.field_6213 > 0) {
                float deathRotation = ((float)livingEntity.field_6213 + partialTick - 1.0f) / 20.0f * 1.6f;
                poseStack.method_22907(class_7833.field_40718.rotationDegrees(Math.min(class_3532.method_15355((float)deathRotation), 1.0f) * this.getDeathMaxRotation(animatable, partialTick)));
            } else if (livingEntity.method_6123()) {
                poseStack.method_22907(class_7833.field_40714.rotationDegrees(-90.0f - livingEntity.method_36455()));
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(ageInTicks * -75.0f));
            } else if (animatable.method_41328(class_4050.field_18078)) {
                class_2350 bedOrientation = livingEntity.method_18401();
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(bedOrientation != null ? RenderUtil.getDirectionAngle(bedOrientation) : rotationYaw));
                poseStack.method_22907(class_7833.field_40718.rotationDegrees(this.getDeathMaxRotation(animatable, partialTick)));
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(270.0f));
            } else if (class_922.method_38563((class_1309)livingEntity)) {
                poseStack.method_46416(0.0f, (animatable.method_17682() + 0.1f) / nativeScale, 0.0f);
                poseStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
            }
        }
    }

    protected float getDeathMaxRotation(T animatable, float partialTick) {
        return 90.0f;
    }

    public double getNameRenderCutoffDistance(T animatable) {
        return 32.0;
    }

    public boolean method_3921(T animatable, double distToCameraSq) {
        double nameRenderCutoff;
        if (!(animatable instanceof class_1309)) {
            return super.method_3921(animatable, distToCameraSq);
        }
        if (animatable.method_21751() && distToCameraSq >= (nameRenderCutoff = this.getNameRenderCutoffDistance(animatable)) * nameRenderCutoff) {
            return false;
        }
        if (!(!(animatable instanceof class_1308) || animatable.method_5733() || animatable.method_16914() && animatable == this.field_4676.field_4678)) {
            return false;
        }
        class_310 minecraft = class_310.method_1551();
        boolean visibleToClient = !animatable.method_5756((class_1657)minecraft.field_1724);
        class_268 entityTeam = animatable.method_5781();
        if (entityTeam == null) {
            return class_310.method_1498() && animatable != minecraft.method_1560() && visibleToClient && !animatable.method_5782();
        }
        class_268 playerTeam = minecraft.field_1724.method_5781();
        return switch (entityTeam.method_1201()) {
            default -> throw new MatchException(null, null);
            case class_270.class_272.field_1442 -> visibleToClient;
            case class_270.class_272.field_1443 -> false;
            case class_270.class_272.field_1444 -> {
                if (playerTeam == null) {
                    yield visibleToClient;
                }
                if (entityTeam.method_1206((class_270)playerTeam) && (entityTeam.method_1199() || visibleToClient)) {
                    yield true;
                }
                yield false;
            }
            case class_270.class_272.field_1446 -> playerTeam == null ? visibleToClient : !entityTeam.method_1206((class_270)playerTeam) && visibleToClient;
        };
    }

    @Override
    public int getPackedOverlay(T animatable, float u, float partialTick) {
        if (!(animatable instanceof class_1309)) {
            return class_4608.field_21444;
        }
        class_1309 entity = (class_1309)animatable;
        return class_4608.method_23625((int)class_4608.method_23210((float)u), (int)class_4608.method_23212((entity.field_6235 > 0 || entity.field_6213 > 0 ? 1 : 0) != 0));
    }

    public boolean isShaking(T animatable) {
        return animatable.method_32314();
    }

    @ApiStatus.Internal
    @Nullable
    public class_10017 method_55269() {
        return null;
    }

    @ApiStatus.Internal
    public final class_10017 method_62425(T entity, float partialTick) {
        this.animatable = entity;
        this.partialTick = partialTick;
        if (this.field_53189 == null) {
            this.field_53189 = entity instanceof class_1309 ? new class_10042() : new class_10017();
        }
        this.method_62354(entity, this.field_53189, partialTick);
        return this.field_53189;
    }

    @ApiStatus.Internal
    public void method_62354(T entity, @Nullable class_10017 entityRenderState, float partialTick) {
        super.method_62354(entity, entityRenderState, partialTick);
        if (entityRenderState instanceof class_10042) {
            class_10042 livingEntityRenderState = (class_10042)entityRenderState;
            RenderUtil.prepLivingEntityRenderState((class_1309)entity, livingEntityRenderState, partialTick, this.itemModelResolver);
        }
    }

    @Override
    public void fireCompileRenderLayersEvent() {
        GeckoLibServices.Client.EVENTS.fireCompileEntityRenderLayers(this);
    }

    @Override
    public boolean firePreRenderEvent(class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource, float partialTick, int packedLight) {
        return GeckoLibServices.Client.EVENTS.fireEntityPreRender(this, poseStack, model, bufferSource, partialTick, packedLight);
    }

    @Override
    public void firePostRenderEvent(class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource, float partialTick, int packedLight) {
        GeckoLibServices.Client.EVENTS.fireEntityPostRender(this, poseStack, model, bufferSource, partialTick, packedLight);
    }
}

