/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.cache.texture;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.class_1011;
import net.minecraft.class_10142;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_10537;
import net.minecraft.class_10539;
import net.minecraft.class_1084;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_4668;
import net.minecraft.class_7368;
import net.minecraft.class_9851;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.cache.texture.GeoAbstractTexture;
import software.bernie.geckolib.resource.GeoGlowingTextureMeta;

public class AutoGlowingTexture
extends GeoAbstractTexture {
    private static final class_4668.class_5942 SHADER_STATE = new class_4668.class_5942(class_10142.field_53893);
    private static final class_4668.class_4685 TRANSPARENCY_STATE = new class_4668.class_4685("translucent_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    private static final class_4668.class_4686 WRITE_MASK = new class_4668.class_4686(true, true);
    private static final BiFunction<class_2960, Boolean, class_1921> GLOWING_RENDER_TYPE = class_156.method_34865((texture, isGlowing) -> {
        class_4668.class_4683 textureState = new class_4668.class_4683(texture, class_9851.field_52395, false);
        return class_1921.method_24049((String)"geo_glowing_layer", (class_293)class_290.field_1580, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)false, (boolean)true, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578(SHADER_STATE).method_34577((class_4668.class_5939)textureState).method_23615(TRANSPARENCY_STATE).method_23611(new class_4668.class_4679(true)).method_23616(WRITE_MASK).method_23617(isGlowing.booleanValue()));
    });
    private static final String APPENDIX = "_glowmask";
    public static boolean PRINT_DEBUG_IMAGES = false;
    protected final class_2960 textureBase;

    public AutoGlowingTexture(class_2960 originalLocation, class_2960 location) {
        super(location);
        this.textureBase = originalLocation;
    }

    public static class_2960 getEmissiveResource(class_2960 baseResource) {
        class_2960 path = AutoGlowingTexture.appendToPath(baseResource, APPENDIX);
        AutoGlowingTexture.generateTexture(path, textureManager -> textureManager.method_65876(path, (class_10537)new AutoGlowingTexture(baseResource, path)));
        return path;
    }

    @Override
    protected class_10539 loadTexture(class_3300 resourceManager, class_310 mc) throws IOException {
        class_1011 class_10112;
        class_3298 baseTextureResource = resourceManager.getResourceOrThrow(this.textureBase);
        Optional glowmaskResource = resourceManager.method_14486(this.method_65859());
        class_1044 baseTexture = mc.method_1531().method_4619(this.textureBase);
        if (baseTexture instanceof class_1043) {
            class_1043 dynamicTexture = (class_1043)baseTexture;
            class_10112 = dynamicTexture.method_4525();
        } else {
            class_10112 = null;
        }
        class_1011 baseImage = class_10112;
        class_7368 baseTextureMeta = baseTextureResource.method_14481();
        class_1084 baseTextureMetaSection = baseTextureMeta.method_43041(class_1084.field_55542).orElse(null);
        if (baseImage == null) {
            try (InputStream stream = baseTextureResource.method_14482();){
                baseImage = class_1011.method_4309((InputStream)stream);
            }
        }
        class_1011 referenceImage = baseImage;
        Pair contents = glowmaskResource.map(resource -> {
            class_1011 image;
            try (InputStream stream = resource.method_14482();){
                image = class_1011.method_4309((InputStream)stream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return Pair.of((Object)image, (Object)GeoGlowingTextureMeta.fromExistingImage(image));
        }).orElseGet(() -> Pair.of((Object)new class_1011(referenceImage.method_4307(), referenceImage.method_4323(), true), (Object)baseTextureMeta.method_43041(GeoGlowingTextureMeta.TYPE).orElseGet(() -> {
            GeckoLibConstants.LOGGER.error("Attempting to use a glowmask but no glowmask or .png.mcmeta was found for texture: {}", (Object)this.textureBase);
            return new GeoGlowingTextureMeta(List.of());
        })));
        ((GeoGlowingTextureMeta)contents.right()).createImageMask(referenceImage, (class_1011)contents.left());
        if (PRINT_DEBUG_IMAGES && GeckoLibServices.PLATFORM.isDevelopmentEnvironment()) {
            this.printDebugImageToDisk(this.textureBase, referenceImage);
            this.printDebugImageToDisk(this.method_65859(), (class_1011)contents.left());
        }
        class_1044 class_10443 = baseTexture;
        Objects.requireNonNull(class_10443);
        class_1044 class_10444 = class_10443;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_10537.class, class_1043.class}, (Object)class_10444, n)) {
            case 0: {
                class_10537 reloadable = (class_10537)class_10444;
                reloadable.method_65857(new class_10539(referenceImage, baseTextureMetaSection));
                break;
            }
            case 1: {
                class_1043 dynamicTexture = (class_1043)class_10444;
                dynamicTexture.method_4524();
                break;
            }
            default: {
                AutoGlowingTexture.uploadTexture(baseTexture, new class_10539(referenceImage, baseTextureMetaSection));
            }
        }
        return new class_10539((class_1011)contents.left(), baseTextureMetaSection);
    }

    public static class_1921 getRenderType(class_2960 texture) {
        return GLOWING_RENDER_TYPE.apply(AutoGlowingTexture.getEmissiveResource(texture), false);
    }

    public static class_1921 getOutlineRenderType(class_2960 texture) {
        return GLOWING_RENDER_TYPE.apply(AutoGlowingTexture.getEmissiveResource(texture), true);
    }
}

