/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.cache.texture;

import com.mojang.blaze3d.platform.TextureUtil;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_1049;
import net.minecraft.class_10539;
import net.minecraft.class_1061;
import net.minecraft.class_1079;
import net.minecraft.class_1080;
import net.minecraft.class_1084;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3532;
import net.minecraft.class_7368;
import net.minecraft.class_7771;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.cache.texture.GeoAbstractTexture;
import software.bernie.geckolib.util.RenderUtil;

public class AnimatableTexture
extends class_1049
implements class_1061 {
    private AnimationContents animationContents = null;
    private boolean isAnimated = false;

    public AnimatableTexture(class_2960 location) {
        super(location);
    }

    public boolean isAnimated() {
        return this.isAnimated;
    }

    public class_10539 method_65809(class_3300 resourceManager) throws IOException {
        class_10539 textureContents;
        class_3298 resource = resourceManager.getResourceOrThrow(this.method_65859());
        class_7368 resourceMeta = resource.method_14481();
        Optional animationMeta = resourceMeta.method_43041(class_1079.field_55537);
        class_1084 textureMeta = resourceMeta.method_43041(class_1084.field_55542).orElse(null);
        if (animationMeta.isEmpty()) {
            class_1011 image = new class_1011(1, 1, false);
            textureContents = new class_10539(image, textureMeta);
            image.close();
        } else {
            class_1011 image;
            try (InputStream inputstream = resource.method_14482();){
                image = class_1011.method_4309((InputStream)inputstream);
            }
            textureContents = new class_10539(image, textureMeta);
            this.animationContents = new AnimationContents(image, (class_1079)animationMeta.get());
            if (this.animationContents.isValid()) {
                this.isAnimated = true;
                this.field_5205 = textureContents.method_65872();
                this.method_4622();
            }
        }
        return textureContents;
    }

    public void method_65857(class_10539 textureContents) {
        this.method_4622();
    }

    public void method_65856(class_1011 image, boolean blur, boolean clamp) {
        TextureUtil.prepareImage((int)this.method_4624(), (int)0, (int)image.method_4307(), (int)image.method_4323());
        this.method_4527(blur, false);
        this.method_65924(clamp);
        image.method_22619(0, 0, 0, 0, 0, image.method_4307(), image.method_4323(), false);
    }

    public void method_4622() {
        this.setAnimationFrame((int)RenderUtil.getCurrentTick());
    }

    public void setAnimationFrame(int tick) {
        if (this.animationContents != null && this.animationContents.animatedTexture != null) {
            this.animationContents.animatedTexture.setCurrentFrame(tick);
        }
    }

    private class AnimationContents {
        private final class_7771 frameSize;
        @Nullable
        private final Texture animatedTexture;

        private AnimationContents(class_1011 image, class_1079 animMeta) {
            this.frameSize = animMeta.method_24143(image.method_4307(), image.method_4323());
            this.animatedTexture = this.createTexture(image, animMeta);
        }

        private boolean isValid() {
            return this.animatedTexture != null;
        }

        @Nullable
        private Texture createTexture(class_1011 image, class_1079 animMeta) {
            if (!class_3532.method_48117((int)image.method_4307(), (int)this.frameSize.comp_1049()) || !class_3532.method_48117((int)image.method_4323(), (int)this.frameSize.comp_1050())) {
                GeckoLibConstants.LOGGER.error("Image {} size {},{} is not multiple of frame size {},{}", (Object)AnimatableTexture.this.method_65859(), (Object)image.method_4307(), (Object)image.method_4323(), (Object)this.frameSize.comp_1049(), (Object)this.frameSize.comp_1050());
                return null;
            }
            int columns = image.method_4307() / this.frameSize.comp_1049();
            int rows = image.method_4323() / this.frameSize.comp_1050();
            int maxFrameCount = columns * rows;
            int defaultFrameTime = animMeta.comp_3456();
            ObjectArrayList frames = new ObjectArrayList(animMeta.comp_3453().map(List::size).orElse(maxFrameCount).intValue());
            animMeta.comp_3453().ifPresentOrElse(arg_0 -> this.lambda$createTexture$0((List)frames, defaultFrameTime, maxFrameCount, arg_0), () -> AnimationContents.lambda$createTexture$1(maxFrameCount, (List)frames, defaultFrameTime));
            return frames.size() <= 1 ? null : new Texture(image, frames.toArray(new Frame[0]), columns, animMeta.comp_3457(), this.animatedTexture != null && this.animatedTexture.clamp, this.animatedTexture != null && this.animatedTexture.blur);
        }

        private static /* synthetic */ void lambda$createTexture$1(int maxFrameCount, List frames, int defaultFrameTime) {
            for (int i = 0; i < maxFrameCount; ++i) {
                frames.add(new Frame(i, defaultFrameTime));
            }
        }

        private /* synthetic */ void lambda$createTexture$0(List frames, int defaultFrameTime, int maxFrameCount, List animFrames) {
            for (class_1080 frame : animFrames) {
                frames.add(new Frame(frame.comp_3451(), frame.method_4691(defaultFrameTime)));
            }
            int index = 0;
            IntOpenHashSet unusedFrames = new IntOpenHashSet();
            for (Frame frame : frames) {
                if (frame.time <= 0) {
                    GeckoLibConstants.LOGGER.warn("Invalid frame duration on sprite {} frame {}: {}", (Object)AnimatableTexture.this.method_65859(), (Object)index, (Object)frame.time);
                    unusedFrames.add(frame.index);
                } else if (frame.index < 0 || frame.index >= maxFrameCount) {
                    GeckoLibConstants.LOGGER.warn("Invalid frame index on sprite {} frame {}: {}", (Object)AnimatableTexture.this.method_65859(), (Object)index, (Object)frame.index);
                    unusedFrames.add(frame.index);
                }
                ++index;
            }
            if (!unusedFrames.isEmpty()) {
                GeckoLibConstants.LOGGER.warn("Unused frames in sprite {}: {}", (Object)AnimatableTexture.this.method_65859(), (Object)Arrays.toString(unusedFrames.toArray()));
            }
        }

        private class Texture
        implements AutoCloseable {
            private final class_1011 baseImage;
            private final Frame[] frames;
            private final int framePanelSize;
            private final boolean interpolating;
            private final class_1011 interpolatedFrame;
            private final int totalFrameTime;
            private final boolean clamp;
            private final boolean blur;
            private int currentFrame;
            private int currentSubframe;

            private Texture(class_1011 baseImage, Frame[] frames, int framePanelSize, boolean interpolating, boolean clamp, boolean blur) {
                this.baseImage = baseImage;
                this.frames = frames;
                this.framePanelSize = framePanelSize;
                this.interpolating = interpolating;
                this.interpolatedFrame = interpolating ? new class_1011(AnimationContents.this.frameSize.comp_1049(), AnimationContents.this.frameSize.comp_1050(), false) : null;
                this.clamp = clamp;
                this.blur = blur;
                int time = 0;
                for (Frame frame : this.frames) {
                    time += frame.time;
                }
                this.totalFrameTime = time;
            }

            private int getFrameX(int frameIndex) {
                return frameIndex % this.framePanelSize;
            }

            private int getFrameY(int frameIndex) {
                return frameIndex / this.framePanelSize;
            }

            public void setCurrentFrame(int ticks) {
                if ((ticks %= this.totalFrameTime) == this.currentSubframe) {
                    return;
                }
                int lastSubframe = this.currentSubframe;
                int lastFrame = this.currentFrame;
                int time = 0;
                for (Frame frame : this.frames) {
                    if (ticks >= (time += frame.time)) continue;
                    this.currentFrame = frame.index;
                    this.currentSubframe = ticks % frame.time;
                    break;
                }
                if (this.currentFrame != lastFrame && this.currentSubframe == 0) {
                    int frameWidth = AnimationContents.this.frameSize.comp_1049();
                    int frameHeight = AnimationContents.this.frameSize.comp_1050();
                    GeoAbstractTexture.uploadTexture((class_1044)AnimatableTexture.this, this.baseImage, this.clamp, this.blur, this.getFrameX(this.currentFrame) * frameWidth, this.getFrameY(this.currentFrame) * frameHeight, frameWidth, frameHeight, false);
                } else if (this.currentSubframe != lastSubframe && this.interpolating) {
                    GeoAbstractTexture.runOnRenderThread(this::generateInterpolatedFrame);
                }
            }

            private void generateInterpolatedFrame() {
                Frame frame = this.frames[this.currentFrame];
                double frameProgress = 1.0 - (double)this.currentSubframe / (double)frame.time;
                int nextFrameIndex = this.frames[(this.currentFrame + 1) % this.frames.length].index;
                if (frame.index != nextFrameIndex) {
                    for (int y = 0; y < this.interpolatedFrame.method_4323(); ++y) {
                        for (int x = 0; x < this.interpolatedFrame.method_4307(); ++x) {
                            int prevFramePixel = this.getPixel(frame.index, x, y);
                            int nextFramePixel = this.getPixel(nextFrameIndex, x, y);
                            int blendedRed = this.interpolate(frameProgress, prevFramePixel >> 16 & 0xFF, nextFramePixel >> 16 & 0xFF);
                            int blendedGreen = this.interpolate(frameProgress, prevFramePixel >> 8 & 0xFF, nextFramePixel >> 8 & 0xFF);
                            int blendedBlue = this.interpolate(frameProgress, prevFramePixel & 0xFF, nextFramePixel & 0xFF);
                            this.interpolatedFrame.method_61941(x, y, prevFramePixel & 0xFF000000 | blendedRed << 16 | blendedGreen << 8 | blendedBlue);
                        }
                    }
                    GeoAbstractTexture.uploadTexture((class_1044)AnimatableTexture.this, this.interpolatedFrame, this.clamp, this.blur, 0, 0, AnimationContents.this.frameSize.comp_1049(), AnimationContents.this.frameSize.comp_1050(), false);
                }
            }

            private int getPixel(int frameIndex, int x, int y) {
                return this.baseImage.method_61940(x + this.getFrameX(frameIndex) * AnimationContents.this.frameSize.comp_1049(), y + this.getFrameY(frameIndex) * AnimationContents.this.frameSize.comp_1050());
            }

            private int interpolate(double frameProgress, double prevColor, double nextColor) {
                return (int)(frameProgress * prevColor + (1.0 - frameProgress) * nextColor);
            }

            @Override
            public void close() {
                this.baseImage.close();
                if (this.interpolatedFrame != null) {
                    this.interpolatedFrame.close();
                }
            }
        }

        private record Frame(int index, int time) {
        }
    }
}

