/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animation;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_2350;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationProcessor;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.EasingType;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.animation.keyframe.AnimationPoint;
import software.bernie.geckolib.animation.keyframe.BoneAnimation;
import software.bernie.geckolib.animation.keyframe.BoneAnimationQueue;
import software.bernie.geckolib.animation.keyframe.Keyframe;
import software.bernie.geckolib.animation.keyframe.KeyframeLocation;
import software.bernie.geckolib.animation.keyframe.KeyframeStack;
import software.bernie.geckolib.animation.keyframe.event.CustomInstructionKeyframeEvent;
import software.bernie.geckolib.animation.keyframe.event.ParticleKeyframeEvent;
import software.bernie.geckolib.animation.keyframe.event.SoundKeyframeEvent;
import software.bernie.geckolib.animation.keyframe.event.data.CustomInstructionKeyframeData;
import software.bernie.geckolib.animation.keyframe.event.data.KeyFrameData;
import software.bernie.geckolib.animation.keyframe.event.data.ParticleKeyframeData;
import software.bernie.geckolib.animation.keyframe.event.data.SoundKeyframeData;
import software.bernie.geckolib.animation.state.BoneSnapshot;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.loading.math.MathParser;
import software.bernie.geckolib.loading.math.MathValue;
import software.bernie.geckolib.loading.math.value.Constant;
import software.bernie.geckolib.model.GeoModel;

public class AnimationController<T extends GeoAnimatable> {
    protected final T animatable;
    protected final String name;
    protected final AnimationStateHandler<T> stateHandler;
    protected final Map<String, BoneAnimationQueue> boneAnimationQueues = new Object2ObjectOpenHashMap();
    protected final Map<String, BoneSnapshot> boneSnapshots = new Object2ObjectOpenHashMap();
    protected Queue<AnimationProcessor.QueuedAnimation> animationQueue = new LinkedList<AnimationProcessor.QueuedAnimation>();
    protected boolean isJustStarting = false;
    protected boolean needsAnimationReload = false;
    protected boolean shouldResetTick = false;
    private boolean justStopped = true;
    protected boolean justStartedTransition = false;
    protected SoundKeyframeHandler<T> soundKeyframeHandler = null;
    protected ParticleKeyframeHandler<T> particleKeyframeHandler = null;
    protected CustomKeyframeHandler<T> customKeyframeHandler = null;
    protected final Map<String, RawAnimation> triggerableAnimations = new Object2ObjectOpenHashMap(0);
    protected RawAnimation triggeredAnimation = null;
    protected boolean handlingTriggeredAnimations = false;
    protected double transitionLength;
    protected RawAnimation currentRawAnimation;
    protected AnimationProcessor.QueuedAnimation currentAnimation;
    protected State animationState = State.STOPPED;
    protected double tickOffset;
    protected double lastPollTime = -1.0;
    protected Function<T, Double> animationSpeedModifier = animatable -> 1.0;
    protected Function<T, EasingType> overrideEasingTypeFunction = animatable -> null;
    private final Set<KeyFrameData> executedKeyFrames = new ObjectOpenHashSet();
    protected GeoModel<T> lastModel;

    public AnimationController(T animatable, AnimationStateHandler<T> animationHandler) {
        this(animatable, "base_controller", 0, animationHandler);
    }

    public AnimationController(T animatable, String name, AnimationStateHandler<T> animationHandler) {
        this(animatable, name, 0, animationHandler);
    }

    public AnimationController(T animatable, int transitionTickTime, AnimationStateHandler<T> animationHandler) {
        this(animatable, "base_controller", transitionTickTime, animationHandler);
    }

    public AnimationController(T animatable2, String name, int transitionTickTime, AnimationStateHandler<T> animationHandler) {
        this.animatable = animatable2;
        this.name = name;
        this.transitionLength = transitionTickTime;
        this.stateHandler = animationHandler;
    }

    public AnimationController<T> setSoundKeyframeHandler(SoundKeyframeHandler<T> soundHandler) {
        this.soundKeyframeHandler = soundHandler;
        return this;
    }

    public AnimationController<T> setParticleKeyframeHandler(ParticleKeyframeHandler<T> particleHandler) {
        this.particleKeyframeHandler = particleHandler;
        return this;
    }

    public AnimationController<T> setCustomInstructionKeyframeHandler(CustomKeyframeHandler<T> customInstructionHandler) {
        this.customKeyframeHandler = customInstructionHandler;
        return this;
    }

    public AnimationController<T> setAnimationSpeedHandler(Function<T, Double> speedModFunction) {
        this.animationSpeedModifier = speedModFunction;
        return this;
    }

    public AnimationController<T> setAnimationSpeed(double speed) {
        return this.setAnimationSpeedHandler(animatable -> speed);
    }

    public AnimationController<T> setOverrideEasingType(EasingType easingTypeFunction) {
        return this.setOverrideEasingTypeFunction(animatable -> easingTypeFunction);
    }

    public AnimationController<T> setOverrideEasingTypeFunction(Function<T, EasingType> easingType) {
        this.overrideEasingTypeFunction = easingType;
        return this;
    }

    public AnimationController<T> triggerableAnim(String name, RawAnimation animation) {
        this.triggerableAnimations.put(name, animation);
        return this;
    }

    public AnimationController<T> receiveTriggeredAnimations() {
        this.handlingTriggeredAnimations = true;
        return this;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public AnimationProcessor.QueuedAnimation getCurrentAnimation() {
        return this.currentAnimation;
    }

    @Nullable
    public RawAnimation getTriggeredAnimation() {
        return this.triggeredAnimation;
    }

    public State getAnimationState() {
        return this.animationState;
    }

    public Map<String, BoneAnimationQueue> getBoneAnimationQueues() {
        return this.boneAnimationQueues;
    }

    public double getAnimationSpeed() {
        return this.animationSpeedModifier.apply(this.animatable);
    }

    public void forceAnimationReset() {
        this.needsAnimationReload = true;
    }

    public void stop() {
        this.animationState = State.STOPPED;
    }

    public AnimationController<T> transitionLength(int ticks) {
        this.transitionLength = ticks;
        return this;
    }

    public boolean hasAnimationFinished() {
        return this.currentRawAnimation != null && this.animationState == State.STOPPED;
    }

    public RawAnimation getCurrentRawAnimation() {
        return this.currentRawAnimation;
    }

    public boolean isPlayingTriggeredAnimation() {
        return this.triggeredAnimation != null && !this.hasAnimationFinished();
    }

    public void setAnimation(RawAnimation rawAnimation) {
        if (rawAnimation == null || rawAnimation.getAnimationStages().isEmpty()) {
            this.stop();
            return;
        }
        if (this.needsAnimationReload || !rawAnimation.equals(this.currentRawAnimation)) {
            Queue<AnimationProcessor.QueuedAnimation> animations;
            if (this.lastModel != null && (animations = this.lastModel.getAnimationProcessor().buildAnimationQueue(this.animatable, rawAnimation)) != null) {
                this.animationQueue = animations;
                this.currentRawAnimation = rawAnimation;
                this.shouldResetTick = true;
                this.animationState = State.TRANSITIONING;
                this.justStartedTransition = true;
                this.needsAnimationReload = false;
                return;
            }
            this.stop();
        }
    }

    public boolean tryTriggerAnimation(String animName) {
        RawAnimation anim = this.triggerableAnimations.get(animName);
        if (anim == null) {
            return false;
        }
        this.triggeredAnimation = anim;
        if (this.animationState == State.STOPPED) {
            this.animationState = State.TRANSITIONING;
            this.shouldResetTick = true;
            this.justStartedTransition = true;
        }
        return true;
    }

    protected boolean stopTriggeredAnimation() {
        if (this.triggeredAnimation == null) {
            return false;
        }
        if (this.currentRawAnimation == this.triggeredAnimation) {
            this.currentAnimation = null;
            this.currentRawAnimation = null;
        }
        this.triggeredAnimation = null;
        this.needsAnimationReload = true;
        return true;
    }

    protected PlayState handleAnimationState(AnimationState<T> state) {
        if (this.triggeredAnimation != null) {
            if (this.currentRawAnimation != this.triggeredAnimation) {
                this.currentAnimation = null;
            }
            this.setAnimation(this.triggeredAnimation);
            if (!(this.hasAnimationFinished() || this.handlingTriggeredAnimations && this.stateHandler.handle(state) != PlayState.CONTINUE)) {
                return PlayState.CONTINUE;
            }
            this.triggeredAnimation = null;
            this.needsAnimationReload = true;
        }
        return this.stateHandler.handle(state);
    }

    public void process(GeoModel<T> model, AnimationState<T> state, Map<String, GeoBone> bones, Map<String, BoneSnapshot> snapshots, double seekTime, boolean crashWhenCantFindBone) {
        PlayState playState;
        double adjustedTick = this.adjustTick(seekTime);
        this.lastModel = model;
        if (this.animationState == State.TRANSITIONING && adjustedTick >= this.transitionLength) {
            this.shouldResetTick = true;
            this.animationState = State.RUNNING;
            adjustedTick = this.adjustTick(seekTime);
        }
        if ((playState = this.handleAnimationState(state)) == PlayState.STOP || this.currentAnimation == null && this.animationQueue.isEmpty()) {
            this.animationState = State.STOPPED;
            this.justStopped = true;
            return;
        }
        this.createInitialQueues(bones.values());
        if (this.justStartedTransition && (this.shouldResetTick || this.justStopped)) {
            this.justStopped = false;
            adjustedTick = this.adjustTick(seekTime);
            if (this.currentAnimation == null) {
                this.animationState = State.TRANSITIONING;
            }
        } else if (this.currentAnimation == null) {
            this.shouldResetTick = true;
            this.animationState = State.TRANSITIONING;
            this.justStartedTransition = true;
            this.needsAnimationReload = false;
            adjustedTick = this.adjustTick(seekTime);
        } else if (this.animationState != State.TRANSITIONING) {
            this.animationState = State.RUNNING;
        }
        if (this.getAnimationState() == State.RUNNING) {
            this.processCurrentAnimation(adjustedTick, seekTime, crashWhenCantFindBone, state);
        } else if (this.animationState == State.TRANSITIONING) {
            if (this.lastPollTime != seekTime && (adjustedTick == 0.0 || this.isJustStarting)) {
                this.justStartedTransition = false;
                this.lastPollTime = seekTime;
                this.currentAnimation = this.animationQueue.poll();
                this.resetEventKeyFrames();
                if (this.currentAnimation == null) {
                    return;
                }
                this.saveSnapshotsForAnimation(this.currentAnimation, snapshots);
            }
            if (this.currentAnimation != null) {
                MathParser.setVariable("query.anim_time", () -> 0.0);
                for (BoneAnimation boneAnimation : this.currentAnimation.animation().boneAnimations()) {
                    BoneAnimationQueue boneAnimationQueue = this.boneAnimationQueues.get(boneAnimation.boneName());
                    BoneSnapshot boneSnapshot = this.boneSnapshots.get(boneAnimation.boneName());
                    GeoBone bone = bones.get(boneAnimation.boneName());
                    if (boneSnapshot == null) continue;
                    if (bone == null) {
                        if (!crashWhenCantFindBone) continue;
                        throw new RuntimeException("Could not find bone: " + boneAnimation.boneName());
                    }
                    KeyframeStack<Keyframe<MathValue>> rotationKeyFrames = boneAnimation.rotationKeyFrames();
                    KeyframeStack<Keyframe<MathValue>> positionKeyFrames = boneAnimation.positionKeyFrames();
                    KeyframeStack<Keyframe<MathValue>> scaleKeyFrames = boneAnimation.scaleKeyFrames();
                    if (!rotationKeyFrames.xKeyframes().isEmpty()) {
                        boneAnimationQueue.addNextRotation(null, adjustedTick, this.transitionLength, boneSnapshot, bone.getInitialSnapshot(), this.getAnimationPointAtTick(rotationKeyFrames.xKeyframes(), 0.0, true, class_2350.class_2351.field_11048), this.getAnimationPointAtTick(rotationKeyFrames.yKeyframes(), 0.0, true, class_2350.class_2351.field_11052), this.getAnimationPointAtTick(rotationKeyFrames.zKeyframes(), 0.0, true, class_2350.class_2351.field_11051));
                    }
                    if (!positionKeyFrames.xKeyframes().isEmpty()) {
                        boneAnimationQueue.addNextPosition(null, adjustedTick, this.transitionLength, boneSnapshot, this.getAnimationPointAtTick(positionKeyFrames.xKeyframes(), 0.0, false, class_2350.class_2351.field_11048), this.getAnimationPointAtTick(positionKeyFrames.yKeyframes(), 0.0, false, class_2350.class_2351.field_11052), this.getAnimationPointAtTick(positionKeyFrames.zKeyframes(), 0.0, false, class_2350.class_2351.field_11051));
                    }
                    if (scaleKeyFrames.xKeyframes().isEmpty()) continue;
                    boneAnimationQueue.addNextScale(null, adjustedTick, this.transitionLength, boneSnapshot, this.getAnimationPointAtTick(scaleKeyFrames.xKeyframes(), 0.0, false, class_2350.class_2351.field_11048), this.getAnimationPointAtTick(scaleKeyFrames.yKeyframes(), 0.0, false, class_2350.class_2351.field_11052), this.getAnimationPointAtTick(scaleKeyFrames.zKeyframes(), 0.0, false, class_2350.class_2351.field_11051));
                }
            }
        }
    }

    private void processCurrentAnimation(double adjustedTick, double seekTime, boolean crashWhenCantFindBone, AnimationState<T> animationState) {
        if (adjustedTick >= this.currentAnimation.animation().length()) {
            if (this.currentAnimation.loopType().shouldPlayAgain((GeoAnimatable)this.animatable, this, this.currentAnimation.animation())) {
                if (this.animationState != State.PAUSED) {
                    this.shouldResetTick = true;
                    adjustedTick = this.adjustTick(seekTime);
                    this.resetEventKeyFrames();
                }
            } else {
                AnimationProcessor.QueuedAnimation nextAnimation = this.animationQueue.peek();
                this.resetEventKeyFrames();
                if (nextAnimation == null) {
                    this.animationState = State.STOPPED;
                    return;
                }
                this.animationState = State.TRANSITIONING;
                this.shouldResetTick = true;
                adjustedTick = this.adjustTick(seekTime);
                this.currentAnimation = this.animationQueue.poll();
            }
        }
        double finalAdjustedTick = adjustedTick;
        MathParser.setVariable("query.anim_time", () -> finalAdjustedTick / 20.0);
        for (BoneAnimation boneAnimation : this.currentAnimation.animation().boneAnimations()) {
            BoneAnimationQueue boneAnimationQueue = this.boneAnimationQueues.get(boneAnimation.boneName());
            if (boneAnimationQueue == null) {
                if (!crashWhenCantFindBone) continue;
                throw new RuntimeException("Could not find bone: " + boneAnimation.boneName());
            }
            KeyframeStack<Keyframe<MathValue>> rotationKeyFrames = boneAnimation.rotationKeyFrames();
            KeyframeStack<Keyframe<MathValue>> positionKeyFrames = boneAnimation.positionKeyFrames();
            KeyframeStack<Keyframe<MathValue>> scaleKeyFrames = boneAnimation.scaleKeyFrames();
            if (!rotationKeyFrames.xKeyframes().isEmpty()) {
                boneAnimationQueue.addRotations(this.getAnimationPointAtTick(rotationKeyFrames.xKeyframes(), adjustedTick, true, class_2350.class_2351.field_11048), this.getAnimationPointAtTick(rotationKeyFrames.yKeyframes(), adjustedTick, true, class_2350.class_2351.field_11052), this.getAnimationPointAtTick(rotationKeyFrames.zKeyframes(), adjustedTick, true, class_2350.class_2351.field_11051));
            }
            if (!positionKeyFrames.xKeyframes().isEmpty()) {
                boneAnimationQueue.addPositions(this.getAnimationPointAtTick(positionKeyFrames.xKeyframes(), adjustedTick, false, class_2350.class_2351.field_11048), this.getAnimationPointAtTick(positionKeyFrames.yKeyframes(), adjustedTick, false, class_2350.class_2351.field_11052), this.getAnimationPointAtTick(positionKeyFrames.zKeyframes(), adjustedTick, false, class_2350.class_2351.field_11051));
            }
            if (scaleKeyFrames.xKeyframes().isEmpty()) continue;
            boneAnimationQueue.addScales(this.getAnimationPointAtTick(scaleKeyFrames.xKeyframes(), adjustedTick, false, class_2350.class_2351.field_11048), this.getAnimationPointAtTick(scaleKeyFrames.yKeyframes(), adjustedTick, false, class_2350.class_2351.field_11052), this.getAnimationPointAtTick(scaleKeyFrames.zKeyframes(), adjustedTick, false, class_2350.class_2351.field_11051));
        }
        adjustedTick += this.transitionLength;
        for (SoundKeyframeData soundKeyframeData : this.currentAnimation.animation().keyFrames().sounds()) {
            if (!(adjustedTick >= soundKeyframeData.getStartTick()) || !this.executedKeyFrames.add(soundKeyframeData)) continue;
            if (this.soundKeyframeHandler == null) {
                GeckoLibConstants.LOGGER.log(Level.WARN, "Sound Keyframe found for " + this.animatable.getClass().getSimpleName() + " -> " + this.getName() + ", but no keyframe handler registered");
                break;
            }
            this.soundKeyframeHandler.handle(new SoundKeyframeEvent<T>(this.animatable, adjustedTick, this, soundKeyframeData, animationState));
        }
        for (ParticleKeyframeData particleKeyframeData : this.currentAnimation.animation().keyFrames().particles()) {
            if (!(adjustedTick >= particleKeyframeData.getStartTick()) || !this.executedKeyFrames.add(particleKeyframeData)) continue;
            if (this.particleKeyframeHandler == null) {
                GeckoLibConstants.LOGGER.log(Level.WARN, "Particle Keyframe found for " + this.animatable.getClass().getSimpleName() + " -> " + this.getName() + ", but no keyframe handler registered");
                break;
            }
            this.particleKeyframeHandler.handle(new ParticleKeyframeEvent<T>(this.animatable, adjustedTick, this, particleKeyframeData, animationState));
        }
        for (CustomInstructionKeyframeData customInstructionKeyframeData : this.currentAnimation.animation().keyFrames().customInstructions()) {
            if (!(adjustedTick >= customInstructionKeyframeData.getStartTick()) || !this.executedKeyFrames.add(customInstructionKeyframeData)) continue;
            if (this.customKeyframeHandler == null) {
                GeckoLibConstants.LOGGER.log(Level.WARN, "Custom Instruction Keyframe found for " + this.animatable.getClass().getSimpleName() + " -> " + this.getName() + ", but no keyframe handler registered");
                break;
            }
            this.customKeyframeHandler.handle(new CustomInstructionKeyframeEvent<T>(this.animatable, adjustedTick, this, customInstructionKeyframeData, animationState));
        }
        if (this.transitionLength == 0.0 && this.shouldResetTick && this.animationState == State.TRANSITIONING) {
            this.currentAnimation = this.animationQueue.poll();
        }
    }

    private void createInitialQueues(Collection<GeoBone> modelRendererList) {
        this.boneAnimationQueues.clear();
        for (GeoBone modelRenderer : modelRendererList) {
            this.boneAnimationQueues.put(modelRenderer.getName(), new BoneAnimationQueue(modelRenderer));
        }
    }

    private void saveSnapshotsForAnimation(AnimationProcessor.QueuedAnimation animation, Map<String, BoneSnapshot> snapshots) {
        block0: for (BoneSnapshot snapshot : snapshots.values()) {
            if (animation.animation().boneAnimations() == null) continue;
            for (BoneAnimation boneAnimation : animation.animation().boneAnimations()) {
                if (!boneAnimation.boneName().equals(snapshot.getBone().getName())) continue;
                this.boneSnapshots.put(boneAnimation.boneName(), BoneSnapshot.copy(snapshot));
                continue block0;
            }
        }
    }

    protected double adjustTick(double tick) {
        if (!this.shouldResetTick) {
            return this.animationSpeedModifier.apply(this.animatable) * Math.max(tick - this.tickOffset, 0.0);
        }
        if (this.getAnimationState() != State.STOPPED) {
            this.tickOffset = tick;
        }
        this.shouldResetTick = false;
        return 0.0;
    }

    private AnimationPoint getAnimationPointAtTick(List<Keyframe<MathValue>> frames, double tick, boolean isRotation, class_2350.class_2351 axis) {
        KeyframeLocation<Keyframe<MathValue>> location = this.getCurrentKeyFrameLocation(frames, tick);
        Keyframe<MathValue> currentFrame = location.keyframe();
        double startValue = currentFrame.startValue().get();
        double endValue = currentFrame.endValue().get();
        if (isRotation) {
            if (!(currentFrame.startValue() instanceof Constant)) {
                startValue = Math.toRadians(startValue);
                if (axis == class_2350.class_2351.field_11048 || axis == class_2350.class_2351.field_11052) {
                    startValue *= -1.0;
                }
            }
            if (!(currentFrame.endValue() instanceof Constant)) {
                endValue = Math.toRadians(endValue);
                if (axis == class_2350.class_2351.field_11048 || axis == class_2350.class_2351.field_11052) {
                    endValue *= -1.0;
                }
            }
        }
        return new AnimationPoint(currentFrame, location.startTick(), currentFrame.length(), startValue, endValue);
    }

    private KeyframeLocation<Keyframe<MathValue>> getCurrentKeyFrameLocation(List<Keyframe<MathValue>> frames, double ageInTicks) {
        double totalFrameTime = 0.0;
        for (Keyframe<MathValue> frame : frames) {
            if (!((totalFrameTime += frame.length()) > ageInTicks)) continue;
            return new KeyframeLocation<Keyframe<MathValue>>(frame, ageInTicks - (totalFrameTime - frame.length()));
        }
        return new KeyframeLocation<Keyframe<MathValue>>(frames.get(frames.size() - 1), ageInTicks);
    }

    private void resetEventKeyFrames() {
        this.executedKeyFrames.clear();
    }

    @FunctionalInterface
    public static interface AnimationStateHandler<A extends GeoAnimatable> {
        public PlayState handle(AnimationState<A> var1);
    }

    @FunctionalInterface
    public static interface SoundKeyframeHandler<A extends GeoAnimatable> {
        public void handle(SoundKeyframeEvent<A> var1);
    }

    @FunctionalInterface
    public static interface ParticleKeyframeHandler<A extends GeoAnimatable> {
        public void handle(ParticleKeyframeEvent<A> var1);
    }

    @FunctionalInterface
    public static interface CustomKeyframeHandler<A extends GeoAnimatable> {
        public void handle(CustomInstructionKeyframeEvent<A> var1);
    }

    public static enum State {
        RUNNING,
        TRANSITIONING,
        PAUSED,
        STOPPED;

    }
}

