/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.service;

import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.constant.dataticket.SerializableDataTicket;
import software.bernie.geckolib.network.packet.BlockEntityAnimTriggerPacket;
import software.bernie.geckolib.network.packet.BlockEntityDataSyncPacket;
import software.bernie.geckolib.network.packet.EntityAnimTriggerPacket;
import software.bernie.geckolib.network.packet.EntityDataSyncPacket;
import software.bernie.geckolib.network.packet.MultiloaderPacket;
import software.bernie.geckolib.network.packet.SingletonAnimTriggerPacket;
import software.bernie.geckolib.network.packet.SingletonDataSyncPacket;

public interface GeckoLibNetworking {
    public static void init() {
        GeckoLibNetworking.registerPacket(BlockEntityAnimTriggerPacket.TYPE, BlockEntityAnimTriggerPacket.CODEC, true);
        GeckoLibNetworking.registerPacket(BlockEntityDataSyncPacket.TYPE, BlockEntityDataSyncPacket.CODEC, true);
        GeckoLibNetworking.registerPacket(EntityAnimTriggerPacket.TYPE, EntityAnimTriggerPacket.CODEC, true);
        GeckoLibNetworking.registerPacket(EntityDataSyncPacket.TYPE, EntityDataSyncPacket.CODEC, true);
        GeckoLibNetworking.registerPacket(SingletonAnimTriggerPacket.TYPE, SingletonAnimTriggerPacket.CODEC, true);
        GeckoLibNetworking.registerPacket(SingletonDataSyncPacket.TYPE, SingletonDataSyncPacket.CODEC, true);
    }

    @ApiStatus.Internal
    private static <B extends class_2540, P extends MultiloaderPacket> void registerPacket(class_8710.class_9154<P> payloadType, class_9139<B, P> codec, boolean isClientBound) {
        GeckoLibServices.NETWORK.registerPacketInternal(payloadType, codec, isClientBound);
    }

    @ApiStatus.Internal
    public <B extends class_2540, P extends MultiloaderPacket> void registerPacketInternal(class_8710.class_9154<P> var1, class_9139<B, P> var2, boolean var3);

    public void sendToAllPlayersTrackingEntity(MultiloaderPacket var1, class_1297 var2);

    public void sendToAllPlayersTrackingBlock(MultiloaderPacket var1, class_3218 var2, class_2338 var3);

    public void sendToPlayer(MultiloaderPacket var1, class_3222 var2);

    default public <D> void syncBlockEntityAnimData(class_2338 pos, SerializableDataTicket<D> dataTicket, D data, class_3218 level) {
        this.sendToAllPlayersTrackingBlock(new BlockEntityDataSyncPacket<D>(pos, dataTicket, data), level, pos);
    }

    default public void triggerBlockEntityAnim(class_2338 pos, @Nullable String controllerName, String animName, class_3218 level) {
        this.sendToAllPlayersTrackingBlock(new BlockEntityAnimTriggerPacket(pos, controllerName, animName), level, pos);
    }

    default public <D> void syncEntityAnimData(class_1297 entity, boolean isReplacedEntity, SerializableDataTicket<D> dataTicket, D data) {
        this.sendToAllPlayersTrackingEntity(new EntityDataSyncPacket<D>(entity.method_5628(), isReplacedEntity, dataTicket, data), entity);
    }

    default public void triggerEntityAnim(class_1297 entity, boolean isReplacedEntity, @Nullable String controllerName, String animName) {
        this.sendToAllPlayersTrackingEntity(new EntityAnimTriggerPacket(entity.method_5628(), isReplacedEntity, controllerName, animName), entity);
    }

    default public <D> void syncSingletonAnimData(long instanceId, SerializableDataTicket<D> dataTicket, D data, class_1297 entityToTrack) {
        this.sendToAllPlayersTrackingEntity(new SingletonDataSyncPacket<D>(this.getClass().toString(), instanceId, dataTicket, data), entityToTrack);
    }

    default public void triggerSingletonAnim(String animatableClassName, class_1297 entityToTrack, long instanceId, @Nullable String controllerName, String animName) {
        this.sendToAllPlayersTrackingEntity(new SingletonAnimTriggerPacket(animatableClassName, instanceId, controllerName, animName), entityToTrack);
    }
}

