/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.network.packet;

import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.network.AbstractPacket;
import software.bernie.geckolib.network.GeckoLibNetwork;
import software.bernie.geckolib.network.SerializableDataTicket;
import software.bernie.geckolib.util.ClientUtils;

public class EntityAnimDataSyncPacket<D>
extends AbstractPacket {
    private final int ENTITY_ID;
    private final SerializableDataTicket<D> DATA_TICKET;
    private final D DATA;

    public EntityAnimDataSyncPacket(int entityId, SerializableDataTicket<D> dataTicket, D data) {
        this.ENTITY_ID = entityId;
        this.DATA_TICKET = dataTicket;
        this.DATA = data;
    }

    @Override
    public class_2540 encode() {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10804(this.ENTITY_ID);
        buf.method_10814(this.DATA_TICKET.id());
        this.DATA_TICKET.encode(this.DATA, buf);
        return buf;
    }

    @Override
    public class_2960 getPacketID() {
        return GeckoLibNetwork.ENTITY_ANIM_DATA_SYNC_PACKET_ID;
    }

    public static <D> void receive(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        int ENTITY_ID = buf.method_10816();
        SerializableDataTicket<?> DATA_TICKET = DataTickets.byName(buf.method_19772());
        Object DATA = DATA_TICKET.decode(buf);
        client.execute(() -> EntityAnimDataSyncPacket.runOnThread(ENTITY_ID, DATA_TICKET, DATA));
    }

    private static <D> void runOnThread(int entityId, SerializableDataTicket<D> dataTicket, D data) {
        class_1297 entity = ClientUtils.getLevel().method_8469(entityId);
        if (entity instanceof GeoEntity) {
            GeoEntity geoEntity = (GeoEntity)entity;
            geoEntity.setAnimData(dataTicket, data);
        }
    }
}

