/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes.layouts;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.drawable.IScalableDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.inputs.IJeiInputHandler;
import mezz.jei.api.gui.inputs.RecipeSlotUnderMouse;
import mezz.jei.api.gui.widgets.IScrollBoxWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.common.Internal;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.gui.input.handlers.OffsetJeiInputHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class RecipeLayoutDrawableErrored<R>
implements IRecipeLayoutDrawable<R> {
    private final IRecipeCategory<R> recipeCategory;
    private final R recipe;
    private final IScrollBoxWidget scrollBoxWidget;
    private final IJeiInputHandler inputHandler;
    private final IScalableDrawable background;
    private final int borderPadding;
    private ImmutableRect2i area;

    public RecipeLayoutDrawableErrored(IRecipeCategory<R> recipeCategory, R recipe, IScalableDrawable background, int borderPadding) {
        this.recipeCategory = recipeCategory;
        this.recipe = recipe;
        this.area = new ImmutableRect2i(0, 0, Math.max(100, recipeCategory.getWidth()), recipeCategory.getHeight());
        this.background = background;
        this.borderPadding = borderPadding;
        ArrayList<FormattedText> lines = new ArrayList<FormattedText>();
        lines.add((FormattedText)Component.m_237115_((String)"gui.jei.category.recipe.crashed").m_130940_(ChatFormatting.RED));
        lines.add((FormattedText)Component.m_237119_());
        lines.add((FormattedText)Component.m_237113_((String)recipeCategory.getRecipeType().getUid().toString()).m_130940_(ChatFormatting.GRAY));
        ResourceLocation registryName = recipeCategory.getRegistryName(recipe);
        if (registryName != null) {
            lines.add((FormattedText)Component.m_237119_());
            lines.add((FormattedText)Component.m_237113_((String)registryName.toString()).m_130940_(ChatFormatting.GRAY));
        }
        IJeiRuntime jeiRuntime = Internal.getJeiRuntime();
        IJeiHelpers jeiHelpers = jeiRuntime.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        this.scrollBoxWidget = guiHelper.createScrollBoxWidget(this.area.width(), this.area.getHeight(), 0, 0).setContents(lines);
        this.inputHandler = new OffsetJeiInputHandler(this.scrollBoxWidget, this::getScreenPosition);
    }

    private ScreenPosition getScreenPosition() {
        return this.area.getScreenPosition();
    }

    @Override
    public void setPosition(int posX, int posY) {
        this.area = this.area.setPosition(posX, posY);
    }

    @Override
    public void drawRecipe(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.background.draw(guiGraphics, this.getRectWithBorder());
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)this.area.x(), (float)this.area.y(), 0.0f);
        int recipeMouseX = mouseX - this.area.x();
        int recipeMouseY = mouseY - this.area.y();
        ScreenPosition position = this.scrollBoxWidget.getPosition();
        poseStack.m_85836_();
        poseStack.m_252880_((float)position.f_263719_(), (float)position.f_263694_(), 0.0f);
        this.scrollBoxWidget.drawWidget(guiGraphics, recipeMouseX - position.f_263719_(), recipeMouseY - position.f_263694_());
        poseStack.m_85849_();
    }

    @Override
    public void drawOverlays(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.area.contains(mouseX, mouseY);
    }

    @Override
    public <T> Optional<T> getIngredientUnderMouse(int mouseX, int mouseY, IIngredientType<T> ingredientType) {
        return Optional.empty();
    }

    @Override
    public Optional<IRecipeSlotDrawable> getRecipeSlotUnderMouse(double mouseX, double mouseY) {
        return Optional.empty();
    }

    @Override
    public Optional<RecipeSlotUnderMouse> getSlotUnderMouse(double mouseX, double mouseY) {
        return Optional.empty();
    }

    @Override
    public Rect2i getRect() {
        return this.area.toMutable();
    }

    @Override
    public Rect2i getRectWithBorder() {
        return this.area.expandBy(this.borderPadding).toMutable();
    }

    @Override
    public Rect2i getRecipeTransferButtonArea() {
        return new Rect2i(0, 0, 0, 0);
    }

    @Override
    public Rect2i getRecipeBookmarkButtonArea() {
        return new Rect2i(0, 0, 0, 0);
    }

    @Override
    public IRecipeSlotsView getRecipeSlotsView() {
        return List::of;
    }

    @Override
    public IRecipeCategory<R> getRecipeCategory() {
        return this.recipeCategory;
    }

    @Override
    public R getRecipe() {
        return this.recipe;
    }

    @Override
    public IJeiInputHandler getInputHandler() {
        return this.inputHandler;
    }

    @Override
    public void tick() {
    }
}

