/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.load;

import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import mezz.jei.api.IModPlugin;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PluginCaller {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void callOnPlugins(String title, List<IModPlugin> plugins, Consumer<IModPlugin> func) {
        ArrayList<IModPlugin> erroredPlugins = new ArrayList<IModPlugin>();
        for (IModPlugin plugin : plugins) {
            try {
                ResourceLocation pluginUid = plugin.getPluginUid();
                LOGGER.info("{}: {} ...", (Object)title, (Object)pluginUid);
                Stopwatch stopwatch = Stopwatch.createStarted();
                func.accept(plugin);
                LOGGER.info("{}: {} took {}", (Object)title, (Object)pluginUid, (Object)stopwatch);
            }
            catch (LinkageError | RuntimeException e) {
                LOGGER.error("Caught an error from mod plugin: {} {}", plugin.getClass(), (Object)plugin.getPluginUid(), (Object)e);
                erroredPlugins.add(plugin);
            }
        }
        plugins.removeAll(erroredPlugins);
    }
}

