/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.platform.IPlatformIngredientHelper;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.library.ingredients.IngredientSet;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1845;
import net.minecraft.class_1847;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BrewingRecipeMakerCommon {
    private static final Logger LOGGER = LogManager.getLogger();

    public static Set<IJeiBrewingRecipe> getVanillaBrewingRecipes(IVanillaRecipeFactory recipeFactory, IIngredientManager ingredientManager, IVanillaPotionOutputSupplier vanillaOutputSupplier) {
        boolean foundNewPotions;
        HashSet<IJeiBrewingRecipe> recipes = new HashSet<IJeiBrewingRecipe>();
        IPlatformRegistry<class_1842> potionRegistry = Services.PLATFORM.getRegistry(class_2378.field_25109);
        IngredientSet<class_1799> knownPotions = BrewingRecipeMakerCommon.getBaseKnownPotions(ingredientManager, potionRegistry);
        List<class_1799> potionReagents = ingredientManager.getAllItemStacks().stream().filter(BrewingRecipeMakerCommon::isIngredient).toList();
        do {
            List<class_1799> newPotions;
            foundNewPotions = !(newPotions = BrewingRecipeMakerCommon.getNewPotions(recipeFactory, potionRegistry, knownPotions, potionReagents, vanillaOutputSupplier, recipes)).isEmpty();
            knownPotions.addAll(newPotions);
        } while (foundNewPotions);
        return recipes;
    }

    private static boolean isIngredient(class_1799 itemStack) {
        try {
            return class_1845.method_8077((class_1799)itemStack);
        }
        catch (LinkageError | RuntimeException e) {
            String itemStackInfo = ErrorUtil.getItemStackInfo(itemStack);
            LOGGER.error("Failed to check if item is a potion reagent {}.", (Object)itemStackInfo, (Object)e);
            return false;
        }
    }

    private static IngredientSet<class_1799> getBaseKnownPotions(IIngredientManager ingredientManager, IPlatformRegistry<class_1842> potionRegistry) {
        IPlatformIngredientHelper ingredientHelper = Services.PLATFORM.getIngredientHelper();
        List potionContainers = ingredientHelper.getPotionContainers().stream().flatMap(potionItem -> Arrays.stream(potionItem.method_8105())).toList();
        IIngredientHelper itemStackHelper = ingredientManager.getIngredientHelper(VanillaTypes.ITEM_STACK);
        IngredientSet<class_1799> knownPotions = IngredientSet.create(itemStackHelper, UidContext.Ingredient);
        potionRegistry.getValues().filter(potion -> potion != class_1847.field_8984).forEach(potion -> {
            for (class_1799 potionContainer : potionContainers) {
                class_1799 result = class_1844.method_8061((class_1799)potionContainer.method_7972(), (class_1842)potion);
                knownPotions.add(result);
            }
        });
        return knownPotions;
    }

    private static List<class_1799> getNewPotions(IVanillaRecipeFactory recipeFactory, IPlatformRegistry<class_1842> potionRegistry, Collection<class_1799> knownPotions, List<class_1799> potionReagents, IVanillaPotionOutputSupplier vanillaOutputSupplier, Collection<IJeiBrewingRecipe> recipes) {
        ArrayList<class_1799> newPotions = new ArrayList<class_1799>();
        for (class_1799 potionInput : knownPotions) {
            for (class_1799 potionReagent : potionReagents) {
                IJeiBrewingRecipe recipe;
                class_2960 outputId;
                class_1842 potionInputType;
                class_2960 inputId;
                class_1842 potionOutputType;
                class_1799 potionOutput = vanillaOutputSupplier.getOutput(potionInput.method_7972(), potionReagent);
                if (potionOutput.method_7960() || potionInput.method_7909() == potionOutput.method_7909() && ((potionOutputType = class_1844.method_8063((class_1799)potionOutput)) == class_1847.field_8991 || Objects.equals(inputId = (class_2960)potionRegistry.getRegistryName(potionInputType = class_1844.method_8063((class_1799)potionInput)).orElse(null), outputId = (class_2960)potionRegistry.getRegistryName(potionOutputType).orElse(null))) || recipes.contains(recipe = recipeFactory.createBrewingRecipe(List.of(potionReagent), potionInput.method_7972(), potionOutput))) continue;
                recipes.add(recipe);
                newPotions.add(potionOutput);
            }
        }
        return newPotions;
    }

    @FunctionalInterface
    public static interface IVanillaPotionOutputSupplier {
        public class_1799 getOutput(class_1799 var1, class_1799 var2);
    }
}

