/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.debug;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IBookmarkOverlay;
import mezz.jei.api.runtime.IIngredientFilter;
import mezz.jei.api.runtime.IIngredientListOverlay;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.library.plugins.debug.DebugRecipe;
import mezz.jei.library.plugins.jei.ingredients.DebugIngredient;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_490;
import net.minecraft.class_5250;
import net.minecraft.class_746;

public class DebugRecipeCategory<F>
implements IRecipeCategory<DebugRecipe> {
    public static final RecipeType<DebugRecipe> TYPE = RecipeType.create("jei", "debug", DebugRecipe.class);
    public static final int RECIPE_WIDTH = 160;
    public static final int RECIPE_HEIGHT = 60;
    private final IDrawable background;
    private final IPlatformFluidHelper<F> platformFluidHelper;
    private final IIngredientManager ingredientManager;
    private final class_2561 localizedName;
    private final IDrawable tankBackground;
    private final IDrawable tankOverlay;
    private final IDrawable item;
    @Nullable
    private IJeiRuntime runtime;
    private boolean hiddenRecipes;

    public DebugRecipeCategory(IGuiHelper guiHelper, IPlatformFluidHelper<F> platformFluidHelper, IIngredientManager ingredientManager) {
        this.background = guiHelper.createBlankDrawable(160, 60);
        this.platformFluidHelper = platformFluidHelper;
        this.ingredientManager = ingredientManager;
        this.localizedName = class_2561.method_43470((String)"debug");
        class_2960 backgroundTexture = new class_2960("jei", "textures/gui/debug.png");
        this.tankBackground = guiHelper.createDrawable(backgroundTexture, 220, 196, 18, 60);
        this.tankOverlay = guiHelper.createDrawable(backgroundTexture, 238, 196, 18, 60);
        this.item = guiHelper.createDrawableItemStack(new class_1799((class_1935)class_1802.field_17507));
    }

    public void setRuntime(IJeiRuntime runtime) {
        this.runtime = runtime;
    }

    @Override
    public RecipeType<DebugRecipe> getRecipeType() {
        return TYPE;
    }

    @Override
    public class_2561 getTitle() {
        return this.localizedName;
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public IDrawable getIcon() {
        Textures textures = Internal.getTextures();
        return textures.getConfigButtonIcon();
    }

    @Override
    public void draw(DebugRecipe recipe, IRecipeSlotsView recipeSlotsView, class_4587 poseStack, double mouseX, double mouseY) {
        if (this.runtime != null) {
            this.item.draw(poseStack, 50, 20);
            IIngredientFilter ingredientFilter = this.runtime.getIngredientFilter();
            class_310 minecraft = class_310.method_1551();
            minecraft.field_1772.method_1729(poseStack, ingredientFilter.getFilterText(), 20.0f, 52.0f, 0);
            IIngredientListOverlay ingredientListOverlay = this.runtime.getIngredientListOverlay();
            Optional<ITypedIngredient<?>> ingredientUnderMouse = DebugRecipeCategory.getIngredientUnderMouse(ingredientListOverlay, this.runtime.getBookmarkOverlay());
            ingredientUnderMouse.ifPresent(typedIngredient -> this.drawIngredientName(minecraft, poseStack, (ITypedIngredient)typedIngredient));
        }
        class_4185 button = recipe.getButton();
        button.method_25394(poseStack, (int)mouseX, (int)mouseY, 0.0f);
    }

    private static Optional<ITypedIngredient<?>> getIngredientUnderMouse(IIngredientListOverlay ingredientListOverlay, IBookmarkOverlay bookmarkOverlay) {
        return ingredientListOverlay.getIngredientUnderMouse().or(bookmarkOverlay::getIngredientUnderMouse);
    }

    private <T> void drawIngredientName(class_310 minecraft, class_4587 poseStack, ITypedIngredient<T> ingredient) {
        IIngredientHelper<T> ingredientHelper = this.ingredientManager.getIngredientHelper(ingredient.getType());
        String jeiUid = ingredientHelper.getUniqueId(ingredient.getIngredient(), UidContext.Ingredient);
        minecraft.field_1772.method_1729(poseStack, jeiUid, 50.0f, 52.0f, 0);
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, DebugRecipe recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 70, 0).addItemStack(new class_1799((class_1935)class_1802.field_8705))).addItemStack(new class_1799((class_1935)class_1802.field_27023));
        builder.addSlot(RecipeIngredientRole.INPUT, 110, 0).addIngredientsUnsafe(Arrays.asList(new class_1799((class_1935)class_1802.field_8187), null));
        long bucketVolume = this.platformFluidHelper.bucketVolume();
        IIngredientTypeWithSubtypes<class_3611, F> fluidType = this.platformFluidHelper.getFluidIngredientType();
        long capacity = 10L * bucketVolume;
        long amount = capacity / 2L + (long)((int)(Math.random() * (double)capacity / 2.0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 90, 0).setFluidRenderer(capacity, false, 16, 58).setOverlay(this.tankOverlay, -1, -1).setBackground(this.tankBackground, -1, -1).addFluidStack((class_3611)class_3612.field_15910, amount);
        capacity = 2L * bucketVolume;
        amount = capacity / 2L + (long)((int)(Math.random() * (double)capacity / 2.0));
        builder.addSlot(RecipeIngredientRole.INPUT, 24, 0).setFluidRenderer(capacity, true, 12, 47).addIngredient(fluidType, this.platformFluidHelper.create((class_3611)class_3612.field_15908, amount));
        builder.addSlot(RecipeIngredientRole.INPUT, 40, 0).addIngredients(DebugIngredient.TYPE, List.of(new DebugIngredient(0), new DebugIngredient(1)));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 40, 16).addIngredient(DebugIngredient.TYPE, new DebugIngredient(2));
        ((IRecipeSlotBuilder)((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 40, 32).addIngredient(DebugIngredient.TYPE, new DebugIngredient(3))).addIngredientsUnsafe(List.of(this.platformFluidHelper.create((class_3611)class_3612.field_15908, (int)((1.0 + Math.random()) * (double)bucketVolume)), new class_1799((class_1935)class_1802.field_8187)))).addTooltipCallback((recipeSlotView, tooltip) -> {
            switch (recipeSlotView.getRole()) {
                case INPUT: {
                    tooltip.add(class_2561.method_43470((String)"Input DebugIngredient"));
                    break;
                }
                case OUTPUT: {
                    tooltip.add(class_2561.method_43470((String)"Output DebugIngredient"));
                    break;
                }
                case CATALYST: {
                    tooltip.add(class_2561.method_43470((String)"Catalyst DebugIngredient"));
                }
            }
        });
    }

    @Override
    public List<class_2561> getTooltipStrings(DebugRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<class_2561> tooltipStrings = new ArrayList<class_2561>();
        tooltipStrings.add((class_2561)class_2561.method_43470((String)"Debug Recipe Category Tooltip is very long and going to wrap").method_27692(class_124.field_1065));
        if (recipe.checkHover(mouseX, mouseY)) {
            tooltipStrings.add((class_2561)class_2561.method_43470((String)"button tooltip!"));
        } else {
            class_5250 debug = class_2561.method_43470((String)"tooltip debug");
            tooltipStrings.add((class_2561)debug.method_27692(class_124.field_1067));
        }
        tooltipStrings.add((class_2561)class_2561.method_43470((String)(mouseX + ", " + mouseY)));
        return tooltipStrings;
    }

    @Override
    public boolean handleInput(DebugRecipe recipe, double mouseX, double mouseY, class_3675.class_306 input) {
        if (input.method_1442() != class_3675.class_307.field_1672) {
            return false;
        }
        class_4185 button = recipe.getButton();
        int mouseButton = input.method_1444();
        if (mouseButton == 0 && button.method_25402(mouseX, mouseY, mouseButton)) {
            class_310 minecraft = class_310.method_1551();
            class_746 player = minecraft.field_1724;
            if (player != null) {
                class_490 screen = new class_490((class_1657)player);
                minecraft.method_1507((class_437)screen);
            }
            if (this.runtime != null) {
                IIngredientFilter ingredientFilter = this.runtime.getIngredientFilter();
                String filterText = ingredientFilter.getFilterText();
                ingredientFilter.setFilterText(filterText + " test");
                IRecipeManager recipeManager = this.runtime.getRecipeManager();
                if (!this.hiddenRecipes) {
                    recipeManager.hideRecipeCategory(RecipeTypes.CRAFTING);
                    this.hiddenRecipes = true;
                } else {
                    recipeManager.unhideRecipeCategory(RecipeTypes.CRAFTING);
                    this.hiddenRecipes = false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public class_2960 getRegistryName(DebugRecipe recipe) {
        return recipe.getRegistryName();
    }
}

