/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.config;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mezz.jei.common.config.file.ConfigValue;
import mezz.jei.common.config.file.IConfigCategoryBuilder;
import mezz.jei.common.config.file.IConfigSchemaBuilder;
import mezz.jei.common.platform.IPlatformItemStackHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.StringUtil;
import mezz.jei.core.util.function.CachedSupplierTransformer;
import mezz.jei.library.config.IModIdFormatConfig;
import mezz.jei.library.config.serializers.ChatFormattingSerializer;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class ModIdFormatConfig
implements IModIdFormatConfig {
    protected static final List<class_124> defaultModNameFormat = List.of(class_124.field_1078, class_124.field_1056);
    public static final String MOD_NAME_FORMAT_CODE = "%MODNAME%";
    private final Supplier<String> modNameFormat;
    @Nullable
    private String cachedOverride;

    public ModIdFormatConfig(IConfigSchemaBuilder builder) {
        IConfigCategoryBuilder modName = builder.addCategory("modname");
        ConfigValue<List<class_124>> configValue = modName.addList("ModNameFormat", defaultModNameFormat, ChatFormattingSerializer.INSTANCE, "Formatting for the mod names in tooltips for JEI GUIs. Leave blank to disable.");
        this.modNameFormat = new CachedSupplierTransformer<List, String>(configValue, ModIdFormatConfig::toFormatString);
    }

    private static String toFormatString(List<class_124> values) {
        return values.stream().map(class_124::toString).collect(Collectors.joining());
    }

    private String getOverride() {
        if (this.cachedOverride == null) {
            this.cachedOverride = this.detectModNameTooltipFormatting();
        }
        return this.cachedOverride;
    }

    @Override
    public final String getModNameFormat() {
        String override = this.getOverride();
        if (!override.isEmpty()) {
            return override;
        }
        return this.modNameFormat.get();
    }

    @Override
    public final boolean isModNameFormatOverrideActive() {
        return !this.getOverride().isEmpty();
    }

    private String detectModNameTooltipFormatting() {
        IPlatformItemStackHelper itemStackHelper = Services.PLATFORM.getItemStackHelper();
        class_310 minecraft = class_310.method_1551();
        class_746 player = minecraft.field_1724;
        List<class_2561> tooltip = itemStackHelper.getTestTooltip((class_1657)player, new class_1799((class_1935)class_1802.field_8279));
        if (tooltip.size() <= 1) {
            return "";
        }
        for (int lineNum = 1; lineNum < tooltip.size(); ++lineNum) {
            String withoutFormatting;
            class_2561 line = tooltip.get(lineNum);
            String lineString = line.getString();
            if (!lineString.contains("Minecraft") || !(withoutFormatting = StringUtil.removeChatFormatting(lineString)).contains("Minecraft")) continue;
            return StringUtils.replaceOnce((String)lineString, (String)"Minecraft", (String)MOD_NAME_FORMAT_CODE);
        }
        return "";
    }
}

