/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IRecipesGui;
import mezz.jei.common.Internal;
import mezz.jei.common.config.DebugConfig;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.gui.JeiTooltip;
import mezz.jei.common.gui.elements.DrawableNineSliceTexture;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import mezz.jei.common.util.StringUtil;
import mezz.jei.gui.GuiProperties;
import mezz.jei.gui.elements.GuiIconButton;
import mezz.jei.gui.input.IClickableIngredientInternal;
import mezz.jei.gui.input.IDraggableIngredientInternal;
import mezz.jei.gui.input.IRecipeFocusSource;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.InputType;
import mezz.jei.gui.input.MouseUtil;
import mezz.jei.gui.input.UserInput;
import mezz.jei.gui.input.handlers.UserInputRouter;
import mezz.jei.gui.recipes.IRecipeGuiLogic;
import mezz.jei.gui.recipes.RecipeCatalysts;
import mezz.jei.gui.recipes.RecipeCategoryTitle;
import mezz.jei.gui.recipes.RecipeGuiLayouts;
import mezz.jei.gui.recipes.RecipeGuiLogic;
import mezz.jei.gui.recipes.RecipeGuiTabs;
import mezz.jei.gui.recipes.RecipeLayoutWithButtons;
import mezz.jei.gui.recipes.RecipeTransferButton;
import mezz.jei.gui.recipes.lookups.StaticFocusedRecipes;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import org.jetbrains.annotations.Nullable;

public class RecipesGui
extends class_437
implements IRecipesGui,
IRecipeFocusSource {
    private static final int borderPadding = 6;
    private static final int minRecipePadding = 4;
    private static final int navBarPadding = 2;
    private static final int titleInnerPadding = 14;
    private static final int smallButtonWidth = 13;
    private static final int smallButtonHeight = 13;
    private static final int minGuiWidth = 198;
    private final IInternalKeyMappings keyBindings;
    private final IFocusFactory focusFactory;
    private int headerHeight;
    private final IRecipeGuiLogic logic;
    private final RecipeGuiLayouts layouts;
    private String pageString = "1/1";
    private final DrawableNineSliceTexture background;
    private final RecipeCatalysts recipeCatalysts;
    private final RecipeGuiTabs recipeGuiTabs;
    private final UserInputRouter inputHandler;
    private final GuiIconButton nextRecipeCategory;
    private final GuiIconButton previousRecipeCategory;
    private final GuiIconButton nextPage;
    private final GuiIconButton previousPage;
    @Nullable
    private class_437 parentScreen;
    private ImmutableRect2i idealArea = ImmutableRect2i.EMPTY;
    private ImmutableRect2i area = ImmutableRect2i.EMPTY;
    private RecipeCategoryTitle recipeCategoryTitle = new RecipeCategoryTitle();
    private boolean init = false;

    public RecipesGui(IRecipeManager recipeManager, IInternalKeyMappings keyBindings, IFocusFactory focusFactory, IGuiHelper guiHelper) {
        super((class_2561)class_2561.method_43470((String)"Recipes"));
        this.keyBindings = keyBindings;
        this.logic = new RecipeGuiLogic(recipeManager, this::updateLayout, focusFactory, this::createRecipeLayoutWithButtons);
        this.recipeCatalysts = new RecipeCatalysts(recipeManager);
        this.recipeGuiTabs = new RecipeGuiTabs(this.logic, recipeManager, guiHelper);
        this.focusFactory = focusFactory;
        this.field_22787 = class_310.method_1551();
        this.layouts = new RecipeGuiLayouts();
        Textures textures = Internal.getTextures();
        IDrawableStatic arrowNext = textures.getArrowNext();
        IDrawableStatic arrowPrevious = textures.getArrowPrevious();
        this.nextRecipeCategory = new GuiIconButton(0, 0, 13, 13, arrowNext, b -> this.logic.nextRecipeCategory());
        this.previousRecipeCategory = new GuiIconButton(0, 0, 13, 13, arrowPrevious, b -> this.logic.previousRecipeCategory());
        this.nextPage = new GuiIconButton(0, 0, 13, 13, arrowNext, b -> this.logic.nextPage());
        this.previousPage = new GuiIconButton(0, 0, 13, 13, arrowPrevious, b -> this.logic.previousPage());
        this.background = textures.getRecipeGuiBackground();
        this.inputHandler = new UserInputRouter("RecipesGui", this.layouts.createInputHandler(), new UserInputHandler(this), this.recipeGuiTabs.createInputHandler(), this.nextRecipeCategory.createInputHandler(), this.previousRecipeCategory.createInputHandler(), this.nextPage.createInputHandler(), this.previousPage.createInputHandler());
    }

    public ImmutableRect2i getArea() {
        return this.area;
    }

    public int getLeftSideExtraWidth() {
        if (this.recipeCatalysts.isEmpty()) {
            return 0;
        }
        return this.recipeCatalysts.getWidth();
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25426() {
        super.method_25426();
        int xSize = 198;
        IClientConfig clientConfig = Internal.getJeiClientConfigs().getClientConfig();
        int ySize = clientConfig.isCenterSearchBarEnabled() ? this.field_22790 - 76 : this.field_22790 - 58;
        int extraSpace = 0;
        int maxHeight = clientConfig.getMaxRecipeGuiHeight();
        if (ySize > maxHeight) {
            extraSpace = ySize - maxHeight;
            ySize = maxHeight;
        }
        int guiLeft = (this.field_22789 - 198) / 2;
        int guiTop = 45 + extraSpace / 2;
        this.area = this.idealArea = new ImmutableRect2i(guiLeft, guiTop, 198, ySize);
        int rightButtonX = guiLeft + 198 - 6 - 13;
        int leftButtonX = guiLeft + 6;
        Objects.requireNonNull(this.field_22793);
        int titleHeight = 9 + 6;
        int recipeClassButtonTop = guiTop + titleHeight - 13 + 2;
        this.nextRecipeCategory.setX(rightButtonX);
        this.nextRecipeCategory.setY(recipeClassButtonTop);
        this.previousRecipeCategory.setX(leftButtonX);
        this.previousRecipeCategory.setY(recipeClassButtonTop);
        int pageButtonTop = recipeClassButtonTop + 13 + 2;
        this.nextPage.setX(rightButtonX);
        this.nextPage.setY(pageButtonTop);
        this.previousPage.setX(leftButtonX);
        this.previousPage.setY(pageButtonTop);
        this.headerHeight = pageButtonTop + 13 - guiTop;
        this.init = true;
        this.updateLayout();
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.field_22787 == null) {
            return;
        }
        this.method_25420(poseStack);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.background.draw(poseStack, this.area);
        RenderSystem.disableBlend();
        class_332.method_25294((class_4587)poseStack, (int)(this.previousRecipeCategory.getX() + this.previousRecipeCategory.method_25368()), (int)this.previousRecipeCategory.getY(), (int)this.nextRecipeCategory.getX(), (int)(this.nextRecipeCategory.getY() + this.nextRecipeCategory.method_25364()), (int)0x30000000);
        class_332.method_25294((class_4587)poseStack, (int)(this.previousPage.getX() + this.previousPage.method_25368()), (int)this.previousPage.getY(), (int)this.nextPage.getX(), (int)(this.nextPage.getY() + this.nextPage.method_25364()), (int)0x30000000);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.recipeCategoryTitle.draw(poseStack, this.field_22793);
        ImmutableRect2i pageArea = MathUtil.union(this.previousPage.getArea(), this.nextPage.getArea());
        StringUtil.drawCenteredStringWithShadow(poseStack, this.field_22793, this.pageString, pageArea);
        this.nextRecipeCategory.method_25394(poseStack, mouseX, mouseY, partialTicks);
        this.previousRecipeCategory.method_25394(poseStack, mouseX, mouseY, partialTicks);
        this.nextPage.method_25394(poseStack, mouseX, mouseY, partialTicks);
        this.previousPage.method_25394(poseStack, mouseX, mouseY, partialTicks);
        Optional<IRecipeLayoutDrawable<?>> hoveredRecipeLayout = this.layouts.draw(poseStack, mouseX, mouseY);
        Optional<IRecipeSlotDrawable> hoveredRecipeCatalyst = this.recipeCatalysts.draw(poseStack, mouseX, mouseY);
        this.recipeGuiTabs.draw(this.field_22787, poseStack, mouseX, mouseY, partialTicks);
        this.layouts.drawTooltips(poseStack, mouseX, mouseY);
        RenderSystem.disableBlend();
        hoveredRecipeLayout.ifPresent(l -> l.drawOverlays(poseStack, mouseX, mouseY));
        hoveredRecipeCatalyst.ifPresent(h -> h.drawHoverOverlays(poseStack));
        hoveredRecipeCatalyst.ifPresent(h -> {
            JeiTooltip tooltip = new JeiTooltip();
            tooltip.addAll(h.getTooltip());
            tooltip.draw(poseStack, mouseX, mouseY);
        });
        RenderSystem.enableDepthTest();
        if (this.recipeCategoryTitle.isMouseOver(mouseX, mouseY)) {
            JeiTooltip tooltip = new JeiTooltip();
            this.recipeCategoryTitle.getTooltip(tooltip);
            if (!this.logic.hasAllCategories()) {
                tooltip.addKeyUsageComponent("jei.tooltip.show.all.recipes.hotkey", this.keyBindings.getLeftClick());
            }
            tooltip.draw(poseStack, mouseX, mouseY);
        }
        if (DebugConfig.isDebugGuisEnabled()) {
            class_332.method_25294((class_4587)poseStack, (int)this.idealArea.getX(), (int)this.idealArea.getY(), (int)(this.idealArea.getX() + this.idealArea.getWidth()), (int)(this.idealArea.getY() + this.idealArea.getHeight()), (int)0x4400FF00);
            class_332.method_25294((class_4587)poseStack, (int)this.area.getX(), (int)this.area.getY(), (int)(this.area.getX() + this.area.getWidth()), (int)(this.area.getY() + this.area.getHeight()), (int)0x44990044);
            ImmutableRect2i recipeLayoutsArea = this.getRecipeLayoutsArea();
            class_332.method_25294((class_4587)poseStack, (int)recipeLayoutsArea.getX(), (int)recipeLayoutsArea.getY(), (int)(recipeLayoutsArea.getX() + recipeLayoutsArea.getWidth()), (int)(recipeLayoutsArea.getY() + recipeLayoutsArea.getHeight()), (int)0x44228844);
        }
    }

    private static ImmutableRect2i calculateAreaToFitLayouts(ImmutableRect2i idealArea, int screenWidth, int recipeWidth) {
        if (recipeWidth == 0) {
            return idealArea;
        }
        int padding = 12;
        int width = 186;
        width = Math.max(recipeWidth, width);
        int newWidth = width + 12;
        int newX = (screenWidth - newWidth) / 2;
        return new ImmutableRect2i(newX, idealArea.getY(), newWidth, idealArea.getHeight());
    }

    public void method_25393() {
        super.method_25393();
        class_1703 container = this.getParentContainerMenu();
        this.layouts.tick(container);
        this.logic.tick();
    }

    public boolean method_25405(double mouseX, double mouseY) {
        if (this.field_22787 != null && this.field_22787.field_1755 == this) {
            return this.area.contains(mouseX, mouseY);
        }
        return false;
    }

    @Override
    public Stream<IClickableIngredientInternal<?>> getIngredientUnderMouse(double mouseX, double mouseY) {
        if (this.isOpen()) {
            return Stream.concat(this.recipeCatalysts.getIngredientUnderMouse(mouseX, mouseY), this.layouts.getIngredientUnderMouse(mouseX, mouseY));
        }
        return Stream.empty();
    }

    @Override
    public Stream<IDraggableIngredientInternal<?>> getDraggableIngredientUnderMouse(double mouseX, double mouseY) {
        return Stream.empty();
    }

    public void method_16014(double mouseX, double mouseY) {
        this.layouts.mouseMoved(mouseX, mouseY);
    }

    public boolean method_25403(double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        class_3675.class_306 input = class_3675.class_307.field_1672.method_1447(mouseButton);
        return this.layouts.mouseDragged(mouseX, mouseY, input, dragX, dragY);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollDelta) {
        if (this.inputHandler.handleMouseScrolled(mouseX, mouseY, scrollDelta)) {
            return true;
        }
        return super.method_25401(mouseX, mouseY, scrollDelta);
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        boolean handled = UserInput.fromVanilla(mouseX, mouseY, mouseButton, InputType.SIMULATE).map(this::handleInput).orElse(false);
        if (handled) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    public boolean method_25406(double mouseX, double mouseY, int mouseButton) {
        boolean handled = UserInput.fromVanilla(mouseX, mouseY, mouseButton, InputType.EXECUTE).map(this::handleInput).orElse(false);
        if (handled) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        UserInput input = UserInput.fromVanilla(keyCode, scanCode, modifiers, InputType.IMMEDIATE);
        return this.handleInput(input);
    }

    private boolean handleInput(UserInput input) {
        return this.inputHandler.handleUserInput(this, input, this.keyBindings);
    }

    public boolean isOpen() {
        return this.field_22787 != null && this.field_22787.field_1755 == this;
    }

    private void open() {
        if (this.field_22787 != null) {
            if (!this.isOpen()) {
                this.parentScreen = this.field_22787.field_1755;
            }
            this.field_22787.method_1507((class_437)this);
        }
    }

    public void method_25419() {
        if (this.isOpen() && this.field_22787 != null) {
            this.field_22787.method_1507(this.parentScreen);
            this.parentScreen = null;
            this.logic.clearHistory();
            return;
        }
        super.method_25419();
    }

    @Override
    public void show(List<IFocus<?>> focuses) {
        IFocusGroup checkedFocuses = this.focusFactory.createFocusGroup(focuses);
        if (this.logic.showFocus(checkedFocuses)) {
            this.open();
        }
    }

    @Override
    public void showTypes(List<RecipeType<?>> recipeTypes) {
        ErrorUtil.checkNotEmpty(recipeTypes, "recipeTypes");
        if (this.logic.showCategories(recipeTypes)) {
            this.open();
        }
    }

    @Override
    public <T> void showRecipes(IRecipeCategory<T> recipeCategory, List<T> recipes, List<IFocus<?>> focuses) {
        ErrorUtil.checkNotNull(recipeCategory, "recipeCategory");
        ErrorUtil.checkNotEmpty(recipes, "recipes");
        IFocusGroup checkedFocuses = this.focusFactory.createFocusGroup(focuses);
        StaticFocusedRecipes<T> focusedRecipes = new StaticFocusedRecipes<T>(recipeCategory, recipes);
        if (this.logic.showRecipes(focusedRecipes, checkedFocuses)) {
            this.open();
        }
    }

    @Override
    public <T> Optional<T> getIngredientUnderMouse(IIngredientType<T> ingredientType) {
        double x = MouseUtil.getX();
        double y = MouseUtil.getY();
        return this.getIngredientUnderMouse(x, y).map(IClickableIngredientInternal::getTypedIngredient).flatMap(i -> i.getIngredient(ingredientType).stream()).findFirst();
    }

    public void back() {
        this.logic.back();
    }

    private void updateLayout() {
        if (!this.init) {
            return;
        }
        ImmutableRect2i titleArea = MathUtil.union(this.previousRecipeCategory.getArea(), this.nextRecipeCategory.getArea()).cropLeft(this.previousRecipeCategory.method_25368() + 14).cropRight(this.nextRecipeCategory.method_25368() + 14);
        IRecipeCategory<?> recipeCategory = this.logic.getSelectedRecipeCategory();
        this.recipeCategoryTitle = RecipeCategoryTitle.create(recipeCategory, this.field_22793, titleArea);
        ImmutableRect2i recipeLayoutsArea = this.getRecipeLayoutsArea();
        int availableHeight = recipeLayoutsArea.getHeight();
        class_1703 containerMenu = this.getParentContainerMenu();
        List<RecipeLayoutWithButtons<?>> recipeLayoutsWithButtons = this.logic.getVisibleRecipeLayoutsWithButtons(availableHeight, 4, containerMenu);
        int recipesPerPage = this.logic.getRecipesPerPage();
        this.layouts.setRecipeLayoutsWithButtons(recipeLayoutsWithButtons);
        this.layouts.tick(containerMenu);
        this.area = RecipesGui.calculateAreaToFitLayouts(this.idealArea, this.field_22789, this.layouts.getWidth());
        recipeLayoutsArea = this.getRecipeLayoutsArea();
        this.layouts.updateLayout(recipeLayoutsArea, recipesPerPage);
        this.nextPage.field_22763 = this.previousPage.field_22763 = this.logic.hasMultiplePages();
        this.nextRecipeCategory.field_22763 = this.previousRecipeCategory.field_22763 = this.logic.hasMultipleCategories();
        this.pageString = this.logic.getPageString();
        List<ITypedIngredient<?>> recipeCatalystIngredients = this.logic.getRecipeCatalysts().toList();
        this.recipeCatalysts.updateLayout(recipeCatalystIngredients, this.area);
        this.recipeGuiTabs.initLayout(this.idealArea);
    }

    private ImmutableRect2i getRecipeLayoutsArea() {
        return new ImmutableRect2i(this.area.getX() + 6, this.area.getY() + this.headerHeight + 2, this.area.getWidth() - 12, this.area.getHeight() - (this.headerHeight + 6 + 2));
    }

    private <T> RecipeLayoutWithButtons<T> createRecipeLayoutWithButtons(IRecipeLayoutDrawable<T> recipeLayoutDrawable) {
        RecipeTransferButton transferButton = RecipeTransferButton.create(recipeLayoutDrawable, this::method_25419);
        return new RecipeLayoutWithButtons<T>(recipeLayoutDrawable, transferButton);
    }

    @Nullable
    private class_1703 getParentContainerMenu() {
        class_437 screen = this.parentScreen == null ? class_310.method_1551().field_1755 : this.parentScreen;
        if (screen instanceof class_465) {
            class_465 containerScreen = (class_465)screen;
            return containerScreen.method_17577();
        }
        return null;
    }

    @Nullable
    public IGuiProperties getProperties() {
        if (this.field_22789 <= 0 || this.field_22790 <= 0) {
            return null;
        }
        int extraWidth = this.getLeftSideExtraWidth();
        ImmutableRect2i recipeArea = this.getArea();
        int guiXSize = recipeArea.getWidth() + extraWidth;
        int guiYSize = recipeArea.getHeight();
        if (guiXSize <= 0 || guiYSize <= 0) {
            return null;
        }
        return new GuiProperties(this.getClass(), recipeArea.getX() - extraWidth, recipeArea.getY(), guiXSize, guiYSize, this.field_22789, this.field_22790);
    }

    private static class UserInputHandler
    implements IUserInputHandler {
        private final RecipesGui recipesGui;

        public UserInputHandler(RecipesGui recipesGui) {
            this.recipesGui = recipesGui;
        }

        @Override
        public Optional<IUserInputHandler> handleUserInput(class_437 screen, UserInput input, IInternalKeyMappings keyBindings) {
            double mouseY;
            double mouseX = input.getMouseX();
            if (this.recipesGui.method_25405(mouseX, mouseY = input.getMouseY()) && this.recipesGui.recipeCategoryTitle.isMouseOver(mouseX, mouseY) && input.is(keyBindings.getLeftClick()) && this.recipesGui.logic.showAllRecipes()) {
                return Optional.of(this);
            }
            class_310 minecraft = class_310.method_1551();
            if (input.is(keyBindings.getCloseRecipeGui()) || input.is(minecraft.field_1690.field_1822)) {
                this.recipesGui.method_25419();
                return Optional.of(this);
            }
            if (input.is(keyBindings.getRecipeBack())) {
                this.recipesGui.back();
                return Optional.of(this);
            }
            if (input.is(keyBindings.getNextCategory())) {
                this.recipesGui.logic.nextRecipeCategory();
                return Optional.of(this);
            }
            if (input.is(keyBindings.getPreviousCategory())) {
                this.recipesGui.logic.previousRecipeCategory();
                return Optional.of(this);
            }
            if (input.is(keyBindings.getNextRecipePage())) {
                this.recipesGui.logic.nextPage();
                return Optional.of(this);
            }
            if (input.is(keyBindings.getPreviousRecipePage())) {
                this.recipesGui.logic.previousPage();
                return Optional.of(this);
            }
            return Optional.empty();
        }

        @Override
        public Optional<IUserInputHandler> handleMouseScrolled(double mouseX, double mouseY, double scrollDelta) {
            if (this.recipesGui.method_25405(mouseX, mouseY)) {
                if (scrollDelta < 0.0) {
                    this.recipesGui.logic.nextPage();
                    return Optional.of(this);
                }
                if (scrollDelta > 0.0) {
                    this.recipesGui.logic.previousPage();
                    return Optional.of(this);
                }
            }
            return Optional.empty();
        }
    }
}

