/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferManager;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.JeiTooltip;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.transfer.RecipeTransferErrorInternal;
import mezz.jei.common.transfer.RecipeTransferUtil;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.input.UserInput;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_768;
import org.jetbrains.annotations.Nullable;

public class RecipeTransferButton
extends GuiIconToggleButton {
    private final IRecipeLayoutDrawable<?> recipeLayout;
    private final Runnable onClose;
    @Nullable
    private IRecipeTransferError recipeTransferError;
    @Nullable
    private class_1703 parentContainer;
    @Nullable
    private class_1657 player;

    public static RecipeTransferButton create(IRecipeLayoutDrawable<?> recipeLayout, Runnable onClose) {
        class_768 buttonArea = recipeLayout.getRecipeTransferButtonArea();
        class_768 layoutArea = recipeLayout.getRect();
        buttonArea.method_35778(buttonArea.method_3321() + layoutArea.method_3321());
        buttonArea.method_35781(buttonArea.method_3322() + layoutArea.method_3322());
        Textures textures = Internal.getTextures();
        IDrawableStatic icon = textures.getRecipeTransfer();
        RecipeTransferButton transferButton = new RecipeTransferButton(icon, recipeLayout, onClose);
        transferButton.updateBounds(buttonArea);
        return transferButton;
    }

    private RecipeTransferButton(IDrawable icon, IRecipeLayoutDrawable<?> recipeLayout, Runnable onClose) {
        super(icon, icon);
        this.recipeLayout = recipeLayout;
        this.onClose = onClose;
    }

    public void update(@Nullable class_1703 parentContainer, @Nullable class_1657 player) {
        this.player = player;
        this.parentContainer = parentContainer;
        if (parentContainer != null && player != null) {
            IRecipeTransferManager recipeTransferManager = Internal.getJeiRuntime().getRecipeTransferManager();
            this.recipeTransferError = RecipeTransferUtil.getTransferRecipeError(recipeTransferManager, parentContainer, this.recipeLayout, player).orElse(null);
        } else {
            this.recipeTransferError = RecipeTransferErrorInternal.INSTANCE;
        }
        if (this.recipeTransferError == null || this.recipeTransferError.getType().allowsTransfer) {
            this.button.field_22763 = true;
            this.button.field_22764 = true;
        } else {
            this.button.field_22763 = false;
            IRecipeTransferError.Type type = this.recipeTransferError.getType();
            this.button.field_22764 = type == IRecipeTransferError.Type.USER_FACING;
        }
    }

    @Override
    protected boolean onMouseClicked(UserInput input) {
        if (!input.isSimulate()) {
            IRecipeTransferManager recipeTransferManager = Internal.getJeiRuntime().getRecipeTransferManager();
            boolean maxTransfer = class_437.method_25442();
            if (this.parentContainer != null && this.player != null && RecipeTransferUtil.transferRecipe(recipeTransferManager, this.parentContainer, this.recipeLayout, this.player, maxTransfer)) {
                this.onClose.run();
            }
        }
        return true;
    }

    @Override
    protected void getTooltips(JeiTooltip tooltip) {
        if (this.recipeTransferError == null) {
            class_5250 tooltipTransfer = class_2561.method_43471((String)"jei.tooltip.transfer");
            tooltip.add((class_2561)tooltipTransfer);
        } else {
            this.recipeTransferError.getTooltip(tooltip);
        }
    }

    @Override
    protected boolean isIconToggledOn() {
        return false;
    }

    @Override
    public void draw(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        super.draw(poseStack, mouseX, mouseY, partialTicks);
        IRecipeTransferError recipeTransferError = this.recipeTransferError;
        if (recipeTransferError != null) {
            if (recipeTransferError.getType() == IRecipeTransferError.Type.COSMETIC) {
                class_332.method_25294((class_4587)poseStack, (int)this.button.getX(), (int)this.button.getY(), (int)(this.button.getX() + this.button.method_25368()), (int)(this.button.getY() + this.button.method_25364()), (int)recipeTransferError.getButtonHighlightColor());
            }
            if (this.isMouseOver(mouseX, mouseY)) {
                IRecipeSlotsView recipeSlotsView = this.recipeLayout.getRecipeSlotsView();
                class_768 recipeRect = this.recipeLayout.getRect();
                recipeTransferError.showError(poseStack, mouseX, mouseY, recipeSlotsView, recipeRect.method_3321(), recipeRect.method_3322());
            }
        }
    }
}

