/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.stream.Stream;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.common.util.MathUtil;
import mezz.jei.gui.recipes.IRecipeGuiLogic;
import mezz.jei.gui.recipes.IRecipeLayoutWithButtonsFactory;
import mezz.jei.gui.recipes.IRecipeLogicStateListener;
import mezz.jei.gui.recipes.RecipeLayoutWithButtons;
import mezz.jei.gui.recipes.layouts.IRecipeLayoutList;
import mezz.jei.gui.recipes.lookups.IFocusedRecipes;
import mezz.jei.gui.recipes.lookups.ILookupState;
import mezz.jei.gui.recipes.lookups.IngredientLookupState;
import mezz.jei.gui.recipes.lookups.SingleCategoryLookupState;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_310;
import net.minecraft.class_746;
import net.minecraft.class_768;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class RecipeGuiLogic
implements IRecipeGuiLogic {
    private final IRecipeManager recipeManager;
    private final IRecipeLogicStateListener stateListener;
    private boolean initialState = true;
    private ILookupState state;
    private final Stack<ILookupState> history = new Stack();
    private final IFocusFactory focusFactory;
    private final IRecipeLayoutWithButtonsFactory recipeLayoutFactory;
    @Nullable
    private IRecipeCategory<?> cachedRecipeCategory;
    @Nullable
    private IRecipeLayoutList cachedRecipeLayoutsWithButtons;

    public RecipeGuiLogic(IRecipeManager recipeManager, IRecipeLogicStateListener stateListener, IFocusFactory focusFactory, IRecipeLayoutWithButtonsFactory recipeLayoutFactory) {
        this.recipeManager = recipeManager;
        this.stateListener = stateListener;
        this.recipeLayoutFactory = recipeLayoutFactory;
        List<IRecipeCategory<?>> recipeCategories = recipeManager.createRecipeCategoryLookup().get().toList();
        this.state = IngredientLookupState.create(recipeManager, focusFactory.getEmptyFocusGroup(), recipeCategories);
        this.focusFactory = focusFactory;
    }

    @Override
    public void tick() {
        if (this.cachedRecipeLayoutsWithButtons != null) {
            this.cachedRecipeLayoutsWithButtons.tick();
        }
    }

    @Override
    public boolean showFocus(IFocusGroup focuses) {
        List<IRecipeCategory<?>> recipeCategories = this.recipeManager.createRecipeCategoryLookup().limitFocus(focuses.getAllFocuses()).get().toList();
        ILookupState state = IngredientLookupState.create(this.recipeManager, focuses, recipeCategories);
        return this.setState(state, true);
    }

    @Override
    public boolean showRecipes(IFocusedRecipes<?> recipes, IFocusGroup focuses) {
        SingleCategoryLookupState state = new SingleCategoryLookupState(recipes, focuses);
        return this.setState(state, true);
    }

    @Override
    public boolean back() {
        if (this.history.empty()) {
            return false;
        }
        ILookupState state = this.history.pop();
        this.setState(state, false);
        return true;
    }

    @Override
    public void clearHistory() {
        while (!this.history.empty()) {
            this.history.pop();
        }
    }

    private boolean setState(ILookupState state, boolean saveHistory) {
        List<IRecipeCategory<?>> recipeCategories = state.getRecipeCategories();
        if (recipeCategories.isEmpty()) {
            return false;
        }
        if (saveHistory && !this.initialState) {
            this.history.push(this.state);
        }
        this.state = state;
        this.initialState = false;
        this.cachedRecipeCategory = null;
        this.cachedRecipeLayoutsWithButtons = null;
        this.stateListener.onStateChange();
        return true;
    }

    @Override
    public boolean showAllRecipes() {
        IRecipeCategory<?> recipeCategory = this.getSelectedRecipeCategory();
        List<IRecipeCategory<?>> recipeCategories = this.recipeManager.createRecipeCategoryLookup().get().toList();
        ILookupState state = IngredientLookupState.create(this.recipeManager, this.focusFactory.getEmptyFocusGroup(), recipeCategories);
        state.moveToRecipeCategory(recipeCategory);
        this.setState(state, true);
        return true;
    }

    @Override
    public boolean showCategories(List<RecipeType<?>> recipeTypes) {
        List<IRecipeCategory<?>> recipeCategories = this.recipeManager.createRecipeCategoryLookup().limitTypes(recipeTypes).get().toList();
        ILookupState state = IngredientLookupState.create(this.recipeManager, this.focusFactory.getEmptyFocusGroup(), recipeCategories);
        if (state.getRecipeCategories().isEmpty()) {
            return false;
        }
        this.setState(state, true);
        return true;
    }

    @Override
    public Stream<ITypedIngredient<?>> getRecipeCatalysts() {
        IRecipeCategory<?> category = this.getSelectedRecipeCategory();
        return this.getRecipeCatalysts(category);
    }

    @Override
    public Stream<ITypedIngredient<?>> getRecipeCatalysts(IRecipeCategory<?> recipeCategory) {
        RecipeType<?> recipeType = recipeCategory.getRecipeType();
        return this.recipeManager.createRecipeCatalystLookup(recipeType).get();
    }

    @Override
    public IRecipeCategory<?> getSelectedRecipeCategory() {
        return this.state.getFocusedRecipes().getRecipeCategory();
    }

    @Override
    public @Unmodifiable List<IRecipeCategory<?>> getRecipeCategories() {
        return this.state.getRecipeCategories();
    }

    @Override
    public List<RecipeLayoutWithButtons<?>> getVisibleRecipeLayoutsWithButtons(int availableHeight, int minRecipePadding, @Nullable class_1703 container) {
        class_746 player = class_310.method_1551().field_1724;
        IRecipeCategory<?> recipeCategory = this.getSelectedRecipeCategory();
        if (this.cachedRecipeLayoutsWithButtons == null || this.cachedRecipeCategory != recipeCategory) {
            IFocusedRecipes<?> focusedRecipes = this.state.getFocusedRecipes();
            this.cachedRecipeLayoutsWithButtons = this.createRecipeLayoutsWithButtons(focusedRecipes, container, (class_1657)player);
            this.cachedRecipeCategory = recipeCategory;
        }
        int recipeHeight = this.cachedRecipeLayoutsWithButtons.findFirst().map(RecipeLayoutWithButtons::recipeLayout).map(IRecipeLayoutDrawable::getRectWithBorder).map(class_768::method_3320).orElseGet(recipeCategory::getHeight);
        int recipesPerPage = Math.max(1, 1 + (availableHeight - recipeHeight) / (recipeHeight + minRecipePadding));
        this.state.setRecipesPerPage(recipesPerPage);
        return this.state.getVisible(this.cachedRecipeLayoutsWithButtons);
    }

    @Override
    public int getRecipesPerPage() {
        return this.state.getRecipesPerPage();
    }

    private <T> @Unmodifiable IRecipeLayoutList createRecipeLayoutsWithButtons(IFocusedRecipes<T> selectedRecipes, @Nullable class_1703 container, @Nullable class_1657 player) {
        IRecipeCategory recipeCategory = selectedRecipes.getRecipeCategory();
        List<T> recipes = selectedRecipes.getRecipes();
        ArrayList brokenRecipes = new ArrayList();
        List<RecipeLayoutWithButtons> results = recipes.stream().mapMulti((recipe, acceptor) -> this.recipeManager.createRecipeLayoutDrawable(recipeCategory, recipe, this.state.getFocuses()).ifPresentOrElse((Consumer<IRecipeLayoutDrawable<Object>>)acceptor, () -> brokenRecipes.add(recipe))).map(this.recipeLayoutFactory::create).toList();
        if (!brokenRecipes.isEmpty()) {
            RecipeType<T> recipeType = recipeCategory.getRecipeType();
            this.recipeManager.hideRecipes(recipeType, brokenRecipes);
        }
        return IRecipeLayoutList.create(container, player, results);
    }

    @Override
    public void nextRecipeCategory() {
        this.state.nextRecipeCategory();
        this.stateListener.onStateChange();
    }

    @Override
    public void setRecipeCategory(IRecipeCategory<?> category) {
        if (this.state.moveToRecipeCategory(category)) {
            this.stateListener.onStateChange();
        }
    }

    @Override
    public boolean hasMultiplePages() {
        List<?> recipes = this.state.getFocusedRecipes().getRecipes();
        return recipes.size() > this.state.getRecipesPerPage();
    }

    @Override
    public void previousRecipeCategory() {
        this.state.previousRecipeCategory();
        this.stateListener.onStateChange();
    }

    @Override
    public void goToFirstPage() {
        this.state.goToFirstPage();
        this.stateListener.onStateChange();
    }

    @Override
    public void nextPage() {
        this.state.nextPage();
        this.stateListener.onStateChange();
    }

    @Override
    public void previousPage() {
        this.state.previousPage();
        this.stateListener.onStateChange();
    }

    @Override
    public String getPageString() {
        int pageIndex = MathUtil.divideCeil(this.state.getRecipeIndex() + 1, this.state.getRecipesPerPage());
        return pageIndex + "/" + this.state.pageCount();
    }

    @Override
    public boolean hasMultipleCategories() {
        return this.state.getRecipeCategories().size() > 1;
    }

    @Override
    public boolean hasAllCategories() {
        long categoryCount = this.recipeManager.createRecipeCategoryLookup().get().count();
        return (long)this.state.getRecipeCategories().size() == categoryCount;
    }
}

