/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.common.Internal;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.UserInput;
import mezz.jei.gui.recipes.IRecipeGuiLogic;
import mezz.jei.gui.recipes.RecipeCategoryIconUtil;
import mezz.jei.gui.recipes.RecipeGuiTab;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class RecipeCategoryTab
extends RecipeGuiTab {
    private final IRecipeGuiLogic logic;
    private final IRecipeCategory<?> category;
    private final IRecipeManager recipeManager;
    private final IGuiHelper guiHelper;

    public RecipeCategoryTab(IRecipeGuiLogic logic, IRecipeCategory<?> category, int x, int y, IRecipeManager recipeManager, IGuiHelper guiHelper) {
        super(x, y);
        this.logic = logic;
        this.category = category;
        this.recipeManager = recipeManager;
        this.guiHelper = guiHelper;
    }

    @Override
    public Optional<IUserInputHandler> handleUserInput(class_437 screen, UserInput input, IInternalKeyMappings keyBindings) {
        if (!this.isMouseOver(input.getMouseX(), input.getMouseY())) {
            return Optional.empty();
        }
        if (input.is(keyBindings.getLeftClick())) {
            if (!input.isSimulate()) {
                this.logic.setRecipeCategory(this.category);
                class_1144 soundHandler = class_310.method_1551().method_1483();
                soundHandler.method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
            }
            return Optional.of(this);
        }
        return Optional.empty();
    }

    @Override
    public void draw(boolean selected, class_4587 poseStack, int mouseX, int mouseY) {
        super.draw(selected, poseStack, mouseX, mouseY);
        IDrawable icon = RecipeCategoryIconUtil.create(this.category, this.recipeManager, this.guiHelper);
        int iconX = this.x + (24 - icon.getWidth()) / 2;
        int iconY = this.y + (24 - icon.getHeight()) / 2;
        icon.draw(poseStack, iconX, iconY);
    }

    @Override
    public boolean isSelected(IRecipeCategory<?> selectedCategory) {
        return this.category.getRecipeType().equals(selectedCategory.getRecipeType());
    }

    @Override
    public List<class_2561> getTooltip() {
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        class_2561 title = this.category.getTitle();
        if (title != null) {
            tooltip.add(title);
        }
        class_2960 uid = this.category.getRecipeType().getUid();
        String modId = uid.method_12836();
        IModIdHelper modIdHelper = Internal.getJeiRuntime().getJeiHelpers().getModIdHelper();
        if (modIdHelper.isDisplayingModNameEnabled()) {
            String modName = modIdHelper.getFormattedModNameForModId(modId);
            tooltip.add((class_2561)class_2561.method_43470((String)modName));
        }
        return tooltip;
    }
}

