/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientListOverlay;
import mezz.jei.api.runtime.IScreenHelper;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.core.config.IWorldConfig;
import mezz.jei.gui.GuiProperties;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.filter.IFilterTextSource;
import mezz.jei.gui.input.GuiTextFieldFilter;
import mezz.jei.gui.input.ICharTypedHandler;
import mezz.jei.gui.input.IClickableIngredientInternal;
import mezz.jei.gui.input.IDragHandler;
import mezz.jei.gui.input.IDraggableIngredientInternal;
import mezz.jei.gui.input.IRecipeFocusSource;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.MouseUtil;
import mezz.jei.gui.input.handlers.CombinedInputHandler;
import mezz.jei.gui.input.handlers.NullDragHandler;
import mezz.jei.gui.input.handlers.NullInputHandler;
import mezz.jei.gui.input.handlers.ProxyDragHandler;
import mezz.jei.gui.input.handlers.ProxyInputHandler;
import mezz.jei.gui.overlay.ConfigButton;
import mezz.jei.gui.overlay.IIngredientGridSource;
import mezz.jei.gui.overlay.IngredientGridWithNavigation;
import mezz.jei.gui.overlay.ScreenPropertiesCache;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

public class IngredientListOverlay
implements IIngredientListOverlay,
IRecipeFocusSource,
ICharTypedHandler {
    private static final int BORDER_MARGIN = 6;
    private static final int INNER_PADDING = 2;
    private static final int BUTTON_SIZE = 20;
    private static final int SEARCH_HEIGHT = 20;
    private final GuiIconToggleButton configButton;
    private final IngredientGridWithNavigation contents;
    private final IClientConfig clientConfig;
    private final IWorldConfig worldConfig;
    private final GuiTextFieldFilter searchField;
    private final IInternalKeyMappings keyBindings;
    private final ScreenPropertiesCache screenPropertiesCache;
    private final IFilterTextSource filterTextSource;

    public IngredientListOverlay(IIngredientGridSource ingredientGridSource, IFilterTextSource filterTextSource, IScreenHelper screenHelper, IngredientGridWithNavigation contents, IClientConfig clientConfig, IWorldConfig worldConfig, IInternalKeyMappings keyBindings) {
        this.screenPropertiesCache = new ScreenPropertiesCache(screenHelper);
        this.contents = contents;
        this.clientConfig = clientConfig;
        this.worldConfig = worldConfig;
        this.searchField = new GuiTextFieldFilter(contents::isEmpty);
        this.keyBindings = keyBindings;
        this.filterTextSource = filterTextSource;
        this.searchField.method_1852(filterTextSource.getFilterText());
        this.searchField.method_25365(false);
        this.searchField.method_1863(filterTextSource::setFilterText);
        filterTextSource.addListener(this.searchField::method_1852);
        ingredientGridSource.addSourceListChangedListener(() -> {
            class_310 minecraft = class_310.method_1551();
            this.getScreenPropertiesUpdater().updateScreen(minecraft.field_1755).update();
        });
        this.configButton = ConfigButton.create(this::isListDisplayed, worldConfig, keyBindings);
    }

    @Override
    public boolean isListDisplayed() {
        return (this.worldConfig.isOverlayEnabled() || this.keyBindings.getToggleOverlay().isUnbound()) && this.screenPropertiesCache.hasValidScreen() && this.contents.hasRoom();
    }

    private static ImmutableRect2i createDisplayArea(IGuiProperties guiProperties) {
        ImmutableRect2i screenRectangle = GuiProperties.getScreenRectangle(guiProperties);
        int guiRight = GuiProperties.getGuiRight(guiProperties);
        return screenRectangle.cropLeft(guiRight);
    }

    public ScreenPropertiesCache.Updater getScreenPropertiesUpdater() {
        return this.screenPropertiesCache.getUpdater(this::onScreenPropertiesChanged);
    }

    private void onScreenPropertiesChanged() {
        this.screenPropertiesCache.getGuiProperties().ifPresentOrElse(guiProperties -> {
            ImmutableRect2i displayArea = IngredientListOverlay.createDisplayArea(guiProperties);
            Set<ImmutableRect2i> guiExclusionAreas = this.screenPropertiesCache.getGuiExclusionAreas();
            this.updateBounds((IGuiProperties)guiProperties, displayArea, guiExclusionAreas);
        }, () -> {
            this.contents.close();
            this.searchField.method_25365(false);
        });
    }

    private void updateBounds(IGuiProperties guiProperties, ImmutableRect2i displayArea, Set<ImmutableRect2i> guiExclusionAreas) {
        boolean searchBarCentered = IngredientListOverlay.isSearchBarCentered(this.clientConfig, guiProperties);
        ImmutableRect2i availableContentsArea = this.getAvailableContentsArea(displayArea, searchBarCentered);
        this.contents.updateBounds(availableContentsArea, guiExclusionAreas, null);
        this.contents.updateLayout(false);
        ImmutableRect2i searchAndConfigArea = this.getSearchAndConfigArea(displayArea, searchBarCentered, guiProperties);
        ImmutableRect2i searchArea = searchAndConfigArea.cropRight(20);
        ImmutableRect2i configButtonArea = searchAndConfigArea.keepRight(20);
        this.searchField.method_1852(this.filterTextSource.getFilterText());
        this.searchField.updateBounds(searchArea);
        this.configButton.updateBounds(configButtonArea);
    }

    private static boolean isSearchBarCentered(IClientConfig clientConfig, IGuiProperties guiProperties) {
        return clientConfig.isCenterSearchBarEnabled() && GuiProperties.getGuiBottom(guiProperties) + 20 < guiProperties.getScreenHeight();
    }

    private ImmutableRect2i getAvailableContentsArea(ImmutableRect2i displayArea, boolean searchBarCentered) {
        if (searchBarCentered) {
            return displayArea;
        }
        return displayArea.cropBottom(22);
    }

    private ImmutableRect2i getSearchAndConfigArea(ImmutableRect2i displayArea, boolean searchBarCentered, IGuiProperties guiProperties) {
        displayArea = displayArea.insetBy(6);
        if (searchBarCentered) {
            ImmutableRect2i guiRectangle = GuiProperties.getGuiRectangle(guiProperties);
            return displayArea.keepBottom(20).matchWidthAndX(guiRectangle);
        }
        if (this.contents.hasRoom()) {
            ImmutableRect2i contentsArea = this.contents.getBackgroundArea();
            return displayArea.keepBottom(20).matchWidthAndX(contentsArea);
        }
        return displayArea.keepBottom(20);
    }

    public void drawScreen(class_310 minecraft, class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.isListDisplayed()) {
            this.searchField.method_25394(poseStack, mouseX, mouseY, partialTicks);
            this.contents.draw(minecraft, poseStack, mouseX, mouseY, partialTicks);
        }
        if (this.screenPropertiesCache.hasValidScreen()) {
            this.configButton.draw(poseStack, mouseX, mouseY, partialTicks);
        }
    }

    public void drawTooltips(class_310 minecraft, class_4587 poseStack, int mouseX, int mouseY) {
        if (this.isListDisplayed()) {
            this.contents.drawTooltips(minecraft, poseStack, mouseX, mouseY);
        }
        if (this.screenPropertiesCache.hasValidScreen()) {
            this.configButton.drawTooltips(poseStack, mouseX, mouseY);
        }
    }

    public void drawOnForeground(class_4587 poseStack, int mouseX, int mouseY) {
        if (this.isListDisplayed()) {
            this.contents.drawOnForeground(poseStack, mouseX, mouseY);
        }
    }

    public void handleTick() {
        if (this.isListDisplayed()) {
            this.searchField.method_1865();
        }
    }

    @Override
    public Stream<IClickableIngredientInternal<?>> getIngredientUnderMouse(double mouseX, double mouseY) {
        if (this.isListDisplayed()) {
            return this.contents.getIngredientUnderMouse(mouseX, mouseY);
        }
        return Stream.empty();
    }

    @Override
    public Stream<IDraggableIngredientInternal<?>> getDraggableIngredientUnderMouse(double mouseX, double mouseY) {
        if (this.isListDisplayed()) {
            return this.contents.getDraggableIngredientUnderMouse(mouseX, mouseY);
        }
        return Stream.empty();
    }

    public IUserInputHandler createInputHandler() {
        CombinedInputHandler displayedInputHandler = new CombinedInputHandler("IngredientListOverlay", this.searchField.createInputHandler(), this.configButton.createInputHandler(), this.contents.createInputHandler());
        IUserInputHandler configButtonInputHandler = this.configButton.createInputHandler();
        return new ProxyInputHandler(() -> {
            if (this.isListDisplayed()) {
                return displayedInputHandler;
            }
            if (this.screenPropertiesCache.hasValidScreen()) {
                return configButtonInputHandler;
            }
            return NullInputHandler.INSTANCE;
        });
    }

    public IDragHandler createDragHandler() {
        IDragHandler displayedDragHandler = this.contents.createDragHandler();
        return new ProxyDragHandler(() -> {
            if (this.isListDisplayed()) {
                return displayedDragHandler;
            }
            return NullDragHandler.INSTANCE;
        });
    }

    @Override
    public boolean hasKeyboardFocus() {
        return this.isListDisplayed() && this.searchField.method_25370();
    }

    @Override
    public boolean onCharTyped(char codePoint, int modifiers) {
        return this.searchField.method_25400(codePoint, modifiers);
    }

    @Override
    public Optional<ITypedIngredient<?>> getIngredientUnderMouse() {
        if (this.isListDisplayed()) {
            double mouseX = MouseUtil.getX();
            double mouseY = MouseUtil.getY();
            return this.contents.getIngredientUnderMouse(mouseX, mouseY).map(IClickableIngredientInternal::getTypedIngredient).findFirst();
        }
        return Optional.empty();
    }

    @Override
    @Nullable
    public <T> T getIngredientUnderMouse(IIngredientType<T> ingredientType) {
        if (this.isListDisplayed()) {
            double mouseX = MouseUtil.getX();
            double mouseY = MouseUtil.getY();
            return this.contents.getIngredientUnderMouse(mouseX, mouseY).map(IClickableIngredientInternal::getTypedIngredient).map(i -> i.getIngredient(ingredientType)).flatMap(Optional::stream).findFirst().orElse(null);
        }
        return null;
    }

    @Override
    public <T> List<T> getVisibleIngredients(IIngredientType<T> ingredientType) {
        if (this.isListDisplayed()) {
            return this.contents.getVisibleIngredients(ingredientType).toList();
        }
        return Collections.emptyList();
    }
}

