/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.Internal;
import mezz.jei.common.config.IIngredientFilterConfig;
import mezz.jei.common.gui.JeiTooltip;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.util.IngredientTooltipHelper;
import mezz.jei.common.util.SafeIngredientUtil;
import mezz.jei.core.config.IWorldConfig;
import mezz.jei.core.search.SearchMode;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_5250;

public final class IngredientGridTooltipHelper {
    private final IIngredientManager ingredientManager;
    private final IIngredientFilterConfig ingredientFilterConfig;
    private final IWorldConfig worldConfig;
    private final IInternalKeyMappings keyBindings;
    private final IColorHelper colorHelper;

    public IngredientGridTooltipHelper(IIngredientManager ingredientManager, IIngredientFilterConfig ingredientFilterConfig, IWorldConfig worldConfig, IInternalKeyMappings keyBindings, IColorHelper colorHelper) {
        this.ingredientManager = ingredientManager;
        this.ingredientFilterConfig = ingredientFilterConfig;
        this.worldConfig = worldConfig;
        this.keyBindings = keyBindings;
        this.colorHelper = colorHelper;
    }

    public <T> void drawTooltip(class_4587 poseStack, int mouseX, int mouseY, ITypedIngredient<T> typedIngredient) {
        IIngredientType<T> ingredientType = typedIngredient.getType();
        IIngredientRenderer<T> ingredientRenderer = this.ingredientManager.getIngredientRenderer(ingredientType);
        IIngredientHelper<T> ingredientHelper = this.ingredientManager.getIngredientHelper(ingredientType);
        JeiTooltip tooltip = new JeiTooltip();
        this.getTooltip(tooltip, typedIngredient, ingredientRenderer, ingredientHelper);
        tooltip.draw(poseStack, mouseX, mouseY);
    }

    public <T> void getTooltip(JeiTooltip tooltip, ITypedIngredient<T> typedIngredient, IIngredientRenderer<T> ingredientRenderer, IIngredientHelper<T> ingredientHelper) {
        T ingredient = typedIngredient.getIngredient();
        IngredientTooltipHelper.getIngredientTooltipSafe(tooltip, ingredient, ingredientRenderer);
        IModIdHelper modIdHelper = Internal.getJeiRuntime().getJeiHelpers().getModIdHelper();
        modIdHelper.getModNameForTooltip(typedIngredient).ifPresent(tooltip::add);
        if (this.ingredientFilterConfig.getColorSearchMode() != SearchMode.DISABLED) {
            this.addColorSearchInfoToTooltip(tooltip, ingredient, ingredientHelper);
        }
        if (this.worldConfig.isEditModeEnabled()) {
            IngredientGridTooltipHelper.addEditModeInfoToTooltip(tooltip, this.keyBindings);
        }
    }

    private <T> void addColorSearchInfoToTooltip(JeiTooltip tooltip, T ingredient, IIngredientHelper<T> ingredientHelper) {
        Iterable<Integer> colors = ingredientHelper.getColors(ingredient);
        String colorNamesString = StreamSupport.stream(colors.spliterator(), false).map(this.colorHelper::getClosestColorName).collect(Collectors.joining(", "));
        if (!colorNamesString.isEmpty()) {
            class_5250 colorTranslation = class_2561.method_43469((String)"jei.tooltip.item.colors", (Object[])new Object[]{colorNamesString}).method_27692(class_124.field_1080);
            tooltip.add((class_2561)colorTranslation);
        }
    }

    private static void addEditModeInfoToTooltip(JeiTooltip tooltip, IInternalKeyMappings keyBindings) {
        List<class_5250> lines = List.of(class_5244.field_39003, class_2561.method_43471((String)"gui.jei.editMode.description").method_27692(class_124.field_1077), class_2561.method_43469((String)"gui.jei.editMode.description.hide", (Object[])new Object[]{keyBindings.getToggleHideIngredient().getTranslatedKeyMessage()}).method_27692(class_124.field_1080), class_2561.method_43469((String)"gui.jei.editMode.description.hide.wild", (Object[])new Object[]{keyBindings.getToggleWildcardHideIngredient().getTranslatedKeyMessage()}).method_27692(class_124.field_1080));
        tooltip.addAll(lines);
    }

    public <T> void getIngredientTooltip(JeiTooltip tooltip, ITypedIngredient<T> typedIngredient, IIngredientRenderer<T> ingredientRenderer, IIngredientHelper<T> ingredientHelper) {
        SafeIngredientUtil.getTooltip(tooltip, this.ingredientManager, ingredientRenderer, typedIngredient);
        if (this.ingredientFilterConfig.getColorSearchMode() != SearchMode.DISABLED) {
            this.addColorSearchInfoToTooltip(tooltip, typedIngredient.getIngredient(), ingredientHelper);
        }
        if (this.worldConfig.isEditModeEnabled()) {
            IngredientGridTooltipHelper.addEditModeInfoToTooltip(tooltip, this.keyBindings);
        }
    }
}

