/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.input.handlers;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import mezz.jei.common.config.DebugConfig;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.InputType;
import mezz.jei.gui.input.UserInput;
import mezz.jei.gui.input.handlers.CombinedInputHandler;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserInputRouter {
    private static final Logger LOGGER = LogManager.getLogger();
    private final CombinedInputHandler combinedInputHandler;
    private final Map<class_3675.class_306, IUserInputHandler> pending = new HashMap<class_3675.class_306, IUserInputHandler>();

    public UserInputRouter(String debugName, IUserInputHandler ... inputHandlers) {
        this.combinedInputHandler = new CombinedInputHandler(debugName, inputHandlers);
    }

    public boolean handleUserInput(class_437 screen, UserInput input, IInternalKeyMappings keyBindings) {
        if (DebugConfig.isDebugInputsEnabled()) {
            LOGGER.debug("Received user input: {}", (Object)input);
        }
        return switch (input.getClickState()) {
            default -> throw new IncompatibleClassChangeError();
            case InputType.IMMEDIATE -> this.handleImmediateClick(screen, input, keyBindings);
            case InputType.SIMULATE -> this.handleSimulateClick(screen, input, keyBindings);
            case InputType.EXECUTE -> this.handleExecuteClick(screen, input, keyBindings);
        };
    }

    private boolean handleImmediateClick(class_437 screen, UserInput input, IInternalKeyMappings keyBindings) {
        IUserInputHandler oldClick = this.pending.remove(input.getKey());
        if (oldClick != null && DebugConfig.isDebugInputsEnabled()) {
            LOGGER.debug("Canceled previous user input: {}", (Object)oldClick);
        }
        return this.combinedInputHandler.handleUserInput(screen, input, keyBindings).map(callback -> {
            if (DebugConfig.isDebugInputsEnabled()) {
                LOGGER.debug("Immediate click handled by: {}\n{}", callback, (Object)input);
            }
            return true;
        }).orElse(false);
    }

    private boolean handleSimulateClick(class_437 screen, UserInput input, IInternalKeyMappings keyBindings) {
        IUserInputHandler oldClick = this.pending.remove(input.getKey());
        if (oldClick != null && DebugConfig.isDebugInputsEnabled()) {
            LOGGER.debug("Canceled pending user input: {}", (Object)oldClick);
        }
        return this.combinedInputHandler.handleUserInput(screen, input, keyBindings).map(callback -> {
            this.pending.put(input.getKey(), (IUserInputHandler)callback);
            if (DebugConfig.isDebugInputsEnabled()) {
                LOGGER.debug("Click successfully simulated by: {}\n{}", callback, (Object)input);
            }
            return true;
        }).orElse(false);
    }

    private boolean handleExecuteClick(class_437 screen, UserInput input, IInternalKeyMappings keyBindings) {
        return Optional.ofNullable(this.pending.remove(input.getKey())).flatMap(inputHandler -> inputHandler.handleUserInput(screen, input, keyBindings)).map(callback -> {
            if (DebugConfig.isDebugInputsEnabled()) {
                LOGGER.debug("Click successfully executed by: {}\n{}", callback, (Object)input);
            }
            return true;
        }).orElse(false);
    }

    public void handleGuiChange() {
        if (DebugConfig.isDebugInputsEnabled()) {
            LOGGER.debug("The GUI has changed, clearing all pending clicks");
        }
        this.combinedInputHandler.unfocus();
        this.pending.clear();
    }

    public boolean handleMouseScrolled(double mouseX, double mouseY, double scrollDelta) {
        return this.combinedInputHandler.handleMouseScrolled(mouseX, mouseY, scrollDelta).map(callback -> {
            if (DebugConfig.isDebugInputsEnabled()) {
                LOGGER.debug("Scroll handled by: {}", callback);
            }
            return true;
        }).orElse(false);
    }
}

