/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.rendering.BatchRenderElement;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.Internal;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.config.IJeiClientConfigs;
import mezz.jei.common.util.ErrorUtil;
import net.minecraft.class_124;
import net.minecraft.class_128;
import net.minecraft.class_148;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SafeIngredientUtil {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<IIngredientRenderer<?>> CRASHING_INGREDIENT_BATCH_RENDERERS = new HashSet();
    private static final Set<Object> CRASHING_INGREDIENT_RENDERERS = new HashSet<Object>();
    private static final Set<Object> CRASHING_INGREDIENT_TOOLTIPS = new HashSet<Object>();

    private SafeIngredientUtil() {
    }

    public static <T> void getTooltip(ITooltipBuilder tooltip, IIngredientManager ingredientManager, IIngredientRenderer<T> ingredientRenderer, ITypedIngredient<T> typedIngredient) {
        class_310 minecraft = class_310.method_1551();
        class_1836.class_1837 tooltipFlag = minecraft.field_1690.field_1827 ? class_1836.class_1837.field_8935 : class_1836.class_1837.field_8934;
        SafeIngredientUtil.getTooltip(tooltip, ingredientManager, ingredientRenderer, typedIngredient, tooltipFlag);
    }

    public static <T> void getTooltip(ITooltipBuilder tooltip, IIngredientManager ingredientManager, IIngredientRenderer<T> ingredientRenderer, ITypedIngredient<T> typedIngredient, class_1836.class_1837 tooltipFlag) {
        T ingredient = typedIngredient.getIngredient();
        if (CRASHING_INGREDIENT_TOOLTIPS.contains(ingredient)) {
            SafeIngredientUtil.getTooltipErrorTooltip(tooltip);
            return;
        }
        tooltip.setIngredient(typedIngredient);
        try {
            tooltip.addAll(ingredientRenderer.getTooltip(ingredient, (class_1836)tooltipFlag));
        }
        catch (LinkageError | RuntimeException e) {
            CRASHING_INGREDIENT_TOOLTIPS.add(ingredient);
            ErrorUtil.logIngredientCrash(e, "Caught an error getting an Ingredient's tooltip", ingredientManager, typedIngredient.getType(), ingredient);
            SafeIngredientUtil.getTooltipErrorTooltip(tooltip);
        }
    }

    private static void getTooltipErrorTooltip(ITooltipBuilder tooltip) {
        class_5250 crash = class_2561.method_43471((String)"jei.tooltip.error.crash");
        tooltip.add((class_2561)crash.method_27692(class_124.field_1061));
    }

    public static <T> void renderBatch(class_4587 poseStack, IIngredientType<T> ingredientType, IIngredientRenderer<T> ingredientRenderer, List<BatchRenderElement<T>> elements) {
        if (CRASHING_INGREDIENT_BATCH_RENDERERS.contains(ingredientRenderer)) {
            for (BatchRenderElement<T> element : elements) {
                SafeIngredientUtil.render(poseStack, ingredientRenderer, ingredientType, element);
            }
            return;
        }
        try {
            ingredientRenderer.renderBatch(poseStack, elements);
        }
        catch (LinkageError | RuntimeException e) {
            CRASHING_INGREDIENT_BATCH_RENDERERS.add(ingredientRenderer);
            LOGGER.error("Caught an error while rendering a batch of Ingredients with ingredient renderer: {}", ingredientRenderer.getClass(), (Object)e);
        }
    }

    public static <T> void render(class_4587 poseStack, IIngredientRenderer<T> ingredientRenderer, ITypedIngredient<T> typedIngredient, int x, int y) {
        SafeIngredientUtil.render(poseStack, ingredientRenderer, typedIngredient.getType(), typedIngredient.getIngredient(), x, y);
    }

    public static <T> void render(class_4587 poseStack, IIngredientRenderer<T> ingredientRenderer, IIngredientType<T> ingredientType, BatchRenderElement<T> element) {
        SafeIngredientUtil.render(poseStack, ingredientRenderer, ingredientType, element.ingredient(), element.x(), element.y());
    }

    public static <T> void render(class_4587 poseStack, IIngredientRenderer<T> ingredientRenderer, IIngredientType<T> ingredientType, T ingredient, int x, int y) {
        if (CRASHING_INGREDIENT_RENDERERS.contains(ingredient)) {
            SafeIngredientUtil.renderError(poseStack);
            return;
        }
        try {
            ingredientRenderer.render(poseStack, ingredient, x, y);
        }
        catch (LinkageError | RuntimeException e) {
            CRASHING_INGREDIENT_RENDERERS.add(ingredient);
            IIngredientManager ingredientManager = Internal.getJeiRuntime().getIngredientManager();
            if (SafeIngredientUtil.shouldCatchRenderErrors()) {
                ErrorUtil.logIngredientCrash(e, "Caught an error rendering an Ingredient", ingredientManager, ingredientType, ingredient);
                SafeIngredientUtil.renderError(poseStack);
            }
            class_128 crashReport = ErrorUtil.createIngredientCrashReport(e, "Rendering ingredient", ingredientManager, ingredientType, ingredient);
            throw new class_148(crashReport);
        }
    }

    private static boolean shouldCatchRenderErrors() {
        return Internal.getOptionalJeiClientConfigs().map(IJeiClientConfigs::getClientConfig).map(IClientConfig::isCatchRenderErrorsEnabled).orElse(false);
    }

    private static void renderError(class_4587 poseStack) {
        class_310 minecraft = class_310.method_1551();
        class_327 font = minecraft.field_1772;
        class_437.method_25303((class_4587)poseStack, (class_327)font, (String)"ERR", (int)0, (int)0, (int)-65536);
        class_437.method_25303((class_4587)poseStack, (class_327)font, (String)"OR", (int)0, (int)8, (int)-65536);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

