/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.util;

import java.util.Collection;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.platform.IPlatformModHelper;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.common.platform.Services;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class ErrorUtil {
    private static final Logger LOGGER = LogManager.getLogger();

    private ErrorUtil() {
    }

    public static <T> String getIngredientInfo(T ingredient, IIngredientType<T> ingredientType, IIngredientManager ingredientManager) {
        IIngredientHelper<T> ingredientHelper = ingredientManager.getIngredientHelper(ingredientType);
        return ingredientHelper.getErrorInfo(ingredient);
    }

    public static String getItemStackInfo(@Nullable class_1799 itemStack) {
        if (itemStack == null) {
            return "null";
        }
        class_1792 item = itemStack.method_7909();
        IPlatformRegistry<class_1792> itemRegistry = Services.PLATFORM.getRegistry(class_2378.field_25108);
        String itemName = itemRegistry.getRegistryName(item).map(class_2960::toString).orElseGet(() -> {
            if (item instanceof class_1747) {
                String blockName;
                class_2248 block = ((class_1747)item).method_7711();
                if (block == null) {
                    blockName = "null";
                } else {
                    IPlatformRegistry<class_2248> blockRegistry = Services.PLATFORM.getRegistry(class_2378.field_25105);
                    blockName = blockRegistry.getRegistryName(block).map(class_2960::toString).orElseGet(() -> block.getClass().getName());
                }
                return "BlockItem(" + blockName + ")";
            }
            return item.getClass().getName();
        });
        class_2487 nbt = itemStack.method_7969();
        if (nbt != null) {
            return itemStack + " " + itemName + " nbt:" + nbt;
        }
        return itemStack + " " + itemName;
    }

    public static void checkNotEmpty(class_1799 itemStack) {
        if (itemStack == null) {
            throw new NullPointerException("ItemStack must not be null.");
        }
        if (itemStack.method_7960()) {
            String info = ErrorUtil.getItemStackInfo(itemStack);
            throw new IllegalArgumentException("ItemStack value must not be empty. " + info);
        }
    }

    public static void checkNotEmpty(class_1799 itemStack, String name) {
        if (itemStack == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (itemStack.method_7960()) {
            String info = ErrorUtil.getItemStackInfo(itemStack);
            throw new IllegalArgumentException("ItemStack " + name + " must not be empty. " + info);
        }
    }

    public static <T> void checkNotEmpty(T[] values, String name) {
        if (values == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException(name + " must not be empty.");
        }
        for (T value : values) {
            if (value != null) continue;
            throw new NullPointerException(name + " must not contain null values.");
        }
    }

    public static void checkNotEmpty(Collection<?> values, String name) {
        if (values == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (values.isEmpty()) {
            throw new IllegalArgumentException(name + " must not be empty.");
        }
        if (!(values instanceof class_2371)) {
            for (Object value : values) {
                if (value != null) continue;
                throw new NullPointerException(name + " must not contain null values.");
            }
        }
    }

    public static <T> void checkNotNull(@Nullable T object, String name) {
        if (object == null) {
            throw new NullPointerException(name + " must not be null.");
        }
    }

    public static void checkNotNull(Collection<?> values, String name) {
        if (values == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (!(values instanceof class_2371)) {
            for (Object value : values) {
                if (value != null) continue;
                throw new NullPointerException(name + " must not contain null values.");
            }
        }
    }

    public static void assertMainThread() {
        class_310 minecraft = class_310.method_1551();
        if (minecraft != null && !minecraft.method_18854()) {
            Thread currentThread = Thread.currentThread();
            throw new IllegalStateException("A JEI API method is being called by another mod from the wrong thread:\n" + currentThread + "\nIt must be called on the main thread by using Minecraft.addScheduledTask.");
        }
    }

    public static <T> class_128 createIngredientCrashReport(Throwable throwable, String title, IIngredientManager ingredientManager, ITypedIngredient<T> typedIngredient) {
        return ErrorUtil.createIngredientCrashReport(throwable, title, ingredientManager, typedIngredient.getType(), typedIngredient.getIngredient());
    }

    public static <T> class_128 createIngredientCrashReport(Throwable throwable, String title, IIngredientManager ingredientManager, IIngredientType<T> ingredientType, T ingredient) {
        class_128 crashReport = class_128.method_560((Throwable)throwable, (String)title);
        class_129 category = crashReport.method_562("Ingredient");
        ErrorUtil.setIngredientCategoryDetails(category, ingredientType, ingredient, ingredientManager);
        return crashReport;
    }

    public static <T> void logIngredientCrash(Throwable throwable, String title, IIngredientManager ingredientManager, IIngredientType<T> ingredientType, T ingredient) {
        class_129 category = new class_129("Ingredient");
        ErrorUtil.setIngredientCategoryDetails(category, ingredientType, ingredient, ingredientManager);
        LOGGER.error(ErrorUtil.crashReportToString(throwable, title, category));
    }

    private static <T> void setIngredientCategoryDetails(class_129 category, IIngredientType<T> ingredientType, T ingredient, IIngredientManager ingredientManager) {
        IIngredientHelper ingredientHelper = ingredientManager.getIngredientHelper(ingredientType);
        IPlatformModHelper modHelper = Services.PLATFORM.getModHelper();
        category.method_577("Name", () -> ingredientHelper.getDisplayName(ingredient));
        category.method_577("Mod's Name", () -> {
            String modId = ingredientHelper.getDisplayModId(ingredient);
            return modHelper.getModNameForModId(modId);
        });
        category.method_577("Unique Id (for Blacklist)", () -> ingredientHelper.getUniqueId(ingredient, UidContext.Ingredient));
        category.method_577("Registry Name", () -> ingredientHelper.getResourceLocation(ingredient).toString());
        category.method_577("Class Name", () -> ingredient.getClass().toString());
        category.method_577("toString Name", ingredient::toString);
        category.method_577("Ingredient Type for JEI", () -> ingredientType.getIngredientClass().toString());
        category.method_577("Error Info gathered from JEI", () -> ingredientHelper.getErrorInfo(ingredient));
    }

    public static <T> class_148 createRenderIngredientException(Throwable throwable, T ingredient, IIngredientManager ingredientManager) {
        class_128 crashreport = class_128.method_560((Throwable)throwable, (String)"Rendering ingredient");
        class_129 ingredientCategory = crashreport.method_562("Ingredient being rendered");
        ingredientCategory.method_577("String Name", ingredient::toString);
        ingredientCategory.method_577("Class Name", () -> ingredient.getClass().toString());
        IPlatformModHelper modHelper = Services.PLATFORM.getModHelper();
        ingredientManager.getIngredientTypeChecked(ingredient).ifPresentOrElse(ingredientType -> {
            IIngredientHelper ingredientHelper = ingredientManager.getIngredientHelper(ingredientType);
            ingredientCategory.method_577("Mod Name", () -> {
                String modId = ingredientHelper.getDisplayModId(ingredient);
                return modHelper.getModNameForModId(modId);
            });
            ingredientCategory.method_577("Registry Name", () -> ingredientHelper.getResourceLocation(ingredient).toString());
            ingredientCategory.method_577("Display Name", () -> ingredientHelper.getDisplayName(ingredient));
            class_129 jeiCategory = crashreport.method_562("JEI render details");
            jeiCategory.method_577("Unique Id (for Blacklist)", () -> ingredientHelper.getUniqueId(ingredient, UidContext.Ingredient));
            jeiCategory.method_577("Ingredient Type", () -> ingredientType.getIngredientClass().toString());
            jeiCategory.method_577("Error Info", () -> ingredientHelper.getErrorInfo(ingredient));
        }, () -> {
            class_129 jeiCategory = crashreport.method_562("JEI render details");
            jeiCategory.method_578("Ingredient Type", (Object)"Error, Unknown Ingredient Type");
        });
        throw new class_148(crashreport);
    }

    private static String crashReportToString(Throwable t, String title, class_129 ... categories) {
        StringBuilder sb = new StringBuilder();
        sb.append(title);
        sb.append(":\n\n");
        for (class_129 category : categories) {
            category.method_574(sb);
            sb.append("\n\n");
        }
        sb.append("-- Stack Trace --\n\n");
        sb.append(ExceptionUtils.getStackTrace((Throwable)t));
        return sb.toString();
    }
}

