/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui;

import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.Internal;
import mezz.jei.common.platform.IPlatformRenderHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.core.util.LimitedLogger;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class TooltipRenderer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final LimitedLogger LIMITED_LOGGER = new LimitedLogger(LOGGER, Duration.ofSeconds(30L));

    private TooltipRenderer() {
    }

    public static void drawHoveringText(class_4587 poseStack, List<class_2561> textLines, int x, int y) {
        class_310 minecraft = class_310.method_1551();
        class_437 screen = minecraft.field_1755;
        if (screen == null) {
            return;
        }
        class_327 font = minecraft.field_1772;
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        try {
            renderHelper.renderTooltip(screen, poseStack, textLines, Optional.empty(), x, y, font, class_1799.field_8037);
        }
        catch (RuntimeException e) {
            String stringTooltip = TooltipRenderer.getTooltipDebugString(textLines, "\n");
            String message = "Failed to render tooltip:\n" + stringTooltip;
            LIMITED_LOGGER.log(Level.ERROR, message, message, stringTooltip, e);
        }
    }

    public static <T> void drawHoveringText(class_4587 poseStack, List<class_2561> textLines, int x, int y, ITypedIngredient<T> typedIngredient, IIngredientManager ingredientManager) {
        IIngredientType<T> ingredientType = typedIngredient.getType();
        IIngredientRenderer<T> ingredientRenderer = ingredientManager.getIngredientRenderer(ingredientType);
        TooltipRenderer.drawHoveringText(poseStack, textLines, x, y, typedIngredient, ingredientRenderer);
    }

    public static <T> void drawHoveringText(class_4587 poseStack, List<class_2561> textLines, int x, int y, ITypedIngredient<T> typedIngredient, IIngredientRenderer<T> ingredientRenderer) {
        class_310 minecraft = class_310.method_1551();
        T ingredient = typedIngredient.getIngredient();
        class_327 font = ingredientRenderer.getFontRenderer(minecraft, ingredient);
        TooltipRenderer.drawHoveringText(poseStack, textLines, x, y, typedIngredient, font);
    }

    private static <T> void drawHoveringText(class_4587 poseStack, List<class_2561> textLines, int x, int y, ITypedIngredient<T> typedIngredient, class_327 font) {
        class_310 minecraft = class_310.method_1551();
        class_437 screen = minecraft.field_1755;
        if (screen == null) {
            return;
        }
        class_1799 itemStack = typedIngredient.getItemStack().orElse(class_1799.field_8037);
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        try {
            Optional tooltipImage = itemStack.method_32347();
            renderHelper.renderTooltip(screen, poseStack, textLines, tooltipImage, x, y, font, itemStack);
        }
        catch (RuntimeException e) {
            T ingredient = typedIngredient.getIngredient();
            IIngredientType<T> type = typedIngredient.getType();
            IIngredientManager ingredientManager = Internal.getIngredientManager();
            String ingredientInfo = ErrorUtil.getIngredientInfo(ingredient, type, ingredientManager);
            String stringTooltip = TooltipRenderer.getTooltipDebugString(textLines, "\n");
            String message = String.format("Failed to render tooltip for ingredient %s:\n%s", ingredientInfo, stringTooltip);
            LIMITED_LOGGER.log(Level.ERROR, message, message, e);
        }
    }

    private static String getTooltipDebugString(List<class_2561> textLines, String joinDelimiter) {
        return textLines.stream().map(class_2561::method_27662).map(class_5250::toString).collect(Collectors.joining(joinDelimiter));
    }
}

