/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiKeyMapping;
import mezz.jei.common.Internal;
import mezz.jei.common.config.DebugConfig;
import mezz.jei.common.platform.IPlatformRenderHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import net.minecraft.class_124;
import net.minecraft.class_128;
import net.minecraft.class_148;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.Nullable;

public class JeiTooltip
implements ITooltipBuilder {
    private final List<class_2561> lines = new ArrayList<class_2561>();
    @Nullable
    private ITypedIngredient<?> typedIngredient;

    @Override
    public void add(@Nullable class_2561 formattedText) {
        if (formattedText == null) {
            if (Services.PLATFORM.getModHelper().isInDev()) {
                throw new NullPointerException("Tried to add null tooltip text");
            }
            return;
        }
        this.lines.add(formattedText);
    }

    @Override
    public void setIngredient(ITypedIngredient<?> typedIngredient) {
        this.typedIngredient = typedIngredient;
    }

    public void addKeyUsageComponent(String translationKey, IJeiKeyMapping keyMapping) {
        class_5250 translatedKeyMessage = keyMapping.getTranslatedKeyMessage().method_27661();
        this.addKeyUsageComponent(translationKey, translatedKeyMessage);
    }

    public void addKeyUsageComponent(String translationKey, class_5250 keyMapping) {
        class_5250 boldKeyMapping = keyMapping.method_27692(class_124.field_1067);
        class_5250 component = class_2561.method_43469((String)translationKey, (Object[])new Object[]{boldKeyMapping}).method_27692(class_124.field_1056).method_27692(class_124.field_1080);
        this.add((class_2561)component);
    }

    @Override
    public void addAll(Collection<? extends class_2561> components) {
        for (class_2561 class_25612 : components) {
            this.add(class_25612);
        }
    }

    @Override
    public void clear() {
        this.lines.clear();
        this.typedIngredient = null;
    }

    public void addAll(JeiTooltip tooltip) {
        this.lines.addAll(tooltip.lines);
    }

    public boolean isEmpty() {
        return this.lines.isEmpty() && this.typedIngredient == null;
    }

    public String toString() {
        return this.lines.stream().map(class_5348::getString).collect(Collectors.joining("\n", "[\n", "\n]"));
    }

    public void draw(class_4587 poseStack, int x, int y) {
        if (this.typedIngredient != null) {
            this.draw(poseStack, x, y, this.typedIngredient);
            return;
        }
        if (this.isEmpty()) {
            return;
        }
        class_310 minecraft = class_310.method_1551();
        class_437 screen = minecraft.field_1755;
        if (screen == null) {
            return;
        }
        class_327 font = minecraft.field_1772;
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        try {
            renderHelper.renderTooltip(screen, poseStack, this.lines, Optional.empty(), x, y, font, class_1799.field_8037);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Crashed when rendering tooltip:\n" + this);
        }
    }

    private <T> void draw(class_4587 poseStack, int x, int y, ITypedIngredient<T> typedIngredient) {
        IIngredientType<T> ingredientType = typedIngredient.getType();
        IIngredientManager ingredientManager = Internal.getJeiRuntime().getIngredientManager();
        IIngredientRenderer<T> ingredientRenderer = ingredientManager.getIngredientRenderer(ingredientType);
        this.draw(poseStack, x, y, typedIngredient, ingredientRenderer, ingredientManager);
    }

    public <T> void draw(class_4587 poseStack, int x, int y, ITypedIngredient<T> typedIngredient, IIngredientRenderer<T> ingredientRenderer, IIngredientManager ingredientManager) {
        class_310 minecraft = class_310.method_1551();
        class_437 screen = minecraft.field_1755;
        if (screen == null) {
            return;
        }
        T ingredient = typedIngredient.getIngredient();
        class_327 font = ingredientRenderer.getFontRenderer(minecraft, ingredient);
        class_1799 itemStack = typedIngredient.getItemStack().orElse(class_1799.field_8037);
        Optional tooltipImage = itemStack.method_32347();
        this.addDebugInfo(ingredientManager, typedIngredient);
        IJeiHelpers jeiHelpers = Internal.getJeiRuntime().getJeiHelpers();
        IModIdHelper modIdHelper = jeiHelpers.getModIdHelper();
        modIdHelper.getModNameForTooltip(typedIngredient).ifPresent(this::add);
        if (this.isEmpty()) {
            return;
        }
        try {
            IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
            renderHelper.renderTooltip(screen, poseStack, this.lines, tooltipImage, x, y, font, itemStack);
        }
        catch (RuntimeException e) {
            class_128 crashReport = ErrorUtil.createIngredientCrashReport(e, "Rendering ingredient tooltip", ingredientManager, typedIngredient);
            crashReport.method_562("tooltip").method_578("value", (Object)this);
            throw new class_148(crashReport);
        }
    }

    private <T> void addDebugInfo(IIngredientManager ingredientManager, ITypedIngredient<T> typedIngredient) {
        if (!DebugConfig.isDebugInfoTooltipsEnabled() || !class_310.method_1551().field_1690.field_1827) {
            return;
        }
        T ingredient = typedIngredient.getIngredient();
        IIngredientType<T> type = typedIngredient.getType();
        IIngredientHelper<T> ingredientHelper = ingredientManager.getIngredientHelper(type);
        this.add((class_2561)class_2561.method_43473());
        this.add((class_2561)class_2561.method_43470((String)"JEI Debug:").method_27692(class_124.field_1063));
        this.add((class_2561)class_2561.method_43470((String)("\u2022 type: " + ingredientHelper.getIngredientType().getIngredientClass())).method_27692(class_124.field_1063));
        this.add((class_2561)class_2561.method_43470((String)("\u2022 uid: " + ingredientHelper.getUniqueId(ingredient, UidContext.Ingredient))).method_27692(class_124.field_1063));
        this.add((class_2561)class_2561.method_43470((String)("\u2022 extra info: " + ingredientHelper.getErrorInfo(ingredient))).method_27692(class_124.field_1063));
        this.add((class_2561)class_2561.method_43473());
    }

    @Override
    public List<class_2561> getLegacyComponents() {
        return this.lines;
    }
}

