/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.api.ingredients;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public interface IIngredientHelper<V> {
    public IIngredientType<V> getIngredientType();

    public String getDisplayName(V var1);

    public String getUniqueId(V var1, UidContext var2);

    default public boolean hasSubtypes(V ingredient) {
        return this.getIngredientType() instanceof IIngredientTypeWithSubtypes;
    }

    default public String getWildcardId(V ingredient) {
        return this.getUniqueId(ingredient, UidContext.Ingredient);
    }

    default public String getDisplayModId(V ingredient) {
        return this.getResourceLocation(ingredient).method_12836();
    }

    default public Iterable<Integer> getColors(V ingredient) {
        return Collections.emptyList();
    }

    public class_2960 getResourceLocation(V var1);

    default public class_1799 getCheatItemStack(V ingredient) {
        return class_1799.field_8037;
    }

    public V copyIngredient(V var1);

    default public V normalizeIngredient(V ingredient) {
        return this.copyIngredient(ingredient);
    }

    default public boolean isValidIngredient(V ingredient) {
        return true;
    }

    default public boolean isIngredientOnServer(V ingredient) {
        return true;
    }

    @Deprecated(since="11.5.1")
    default public Collection<class_2960> getTags(V ingredient) {
        return Collections.emptyList();
    }

    default public Stream<class_2960> getTagStream(V ingredient) {
        return this.getTags(ingredient).stream();
    }

    default public Collection<String> getCreativeTabNames(V ingredient) {
        return Collections.emptyList();
    }

    public String getErrorInfo(@Nullable V var1);

    @Deprecated(since="11.7.0", forRemoval=true)
    default public Optional<class_2960> getTagEquivalent(Collection<V> ingredients) {
        return this.getTagKeyEquivalent(ingredients).map(class_6862::comp_327);
    }

    default public Optional<class_6862<?>> getTagKeyEquivalent(Collection<V> ingredients) {
        return Optional.empty();
    }
}

