/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.api.gui.ingredient;

import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.class_1799;
import net.minecraft.class_4587;

public interface IRecipeSlotView {
    default public <T> Stream<T> getIngredients(IIngredientType<T> ingredientType) {
        return this.getAllIngredients().map(i -> i.getIngredient(ingredientType)).flatMap(Optional::stream);
    }

    default public Stream<class_1799> getItemStacks() {
        return this.getIngredients(VanillaTypes.ITEM_STACK);
    }

    public Stream<ITypedIngredient<?>> getAllIngredients();

    default public boolean isEmpty() {
        return this.getAllIngredients().findAny().isEmpty();
    }

    default public Optional<class_1799> getDisplayedItemStack() {
        return this.getDisplayedIngredient(VanillaTypes.ITEM_STACK);
    }

    default public <T> Optional<T> getDisplayedIngredient(IIngredientType<T> ingredientType) {
        return this.getDisplayedIngredient().flatMap(i -> i.getIngredient(ingredientType));
    }

    public Optional<ITypedIngredient<?>> getDisplayedIngredient();

    public Optional<String> getSlotName();

    public RecipeIngredientRole getRole();

    public void drawHighlight(class_4587 var1, int var2);
}

