/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.util;

import java.util.Collection;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.ingredients.RegisteredIngredients;
import mezz.jei.common.platform.IPlatformModHelper;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.common.platform.Services;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public final class ErrorUtil {
    private ErrorUtil() {
    }

    public static <T> String getIngredientInfo(T ingredient, IIngredientType<T> ingredientType, RegisteredIngredients registeredIngredients) {
        IIngredientHelper<T> ingredientHelper = registeredIngredients.getIngredientHelper(ingredientType);
        return ingredientHelper.getErrorInfo(ingredient);
    }

    public static String getItemStackInfo(@Nullable class_1799 itemStack) {
        Object itemName;
        if (itemStack == null) {
            return "null";
        }
        class_1792 item = itemStack.method_7909();
        IPlatformRegistry<class_1792> itemRegistry = Services.PLATFORM.getRegistry(class_2378.field_25108);
        class_2960 registryName = itemRegistry.getRegistryName(item);
        if (registryName != null) {
            itemName = registryName.toString();
        } else if (item instanceof class_1747) {
            IPlatformRegistry<class_2248> blockRegistry;
            class_2960 blockRegistryName;
            class_2248 block = ((class_1747)item).method_7711();
            String blockName = block == null ? "null" : ((blockRegistryName = (blockRegistry = Services.PLATFORM.getRegistry(class_2378.field_25105)).getRegistryName(block)) != null ? blockRegistryName.toString() : block.getClass().getName());
            itemName = "BlockItem(" + blockName + ")";
        } else {
            itemName = item.getClass().getName();
        }
        class_2487 nbt = itemStack.method_7969();
        if (nbt != null) {
            return itemStack + " " + (String)itemName + " nbt:" + nbt;
        }
        return itemStack + " " + (String)itemName;
    }

    public static void checkNotEmpty(class_1799 itemStack) {
        if (itemStack == null) {
            throw new NullPointerException("ItemStack must not be null.");
        }
        if (itemStack.method_7960()) {
            String info = ErrorUtil.getItemStackInfo(itemStack);
            throw new IllegalArgumentException("ItemStack value must not be empty. " + info);
        }
    }

    public static void checkNotEmpty(class_1799 itemStack, String name) {
        if (itemStack == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (itemStack.method_7960()) {
            String info = ErrorUtil.getItemStackInfo(itemStack);
            throw new IllegalArgumentException("ItemStack " + name + " must not be empty. " + info);
        }
    }

    public static <T> void checkNotEmpty(T[] values, String name) {
        if (values == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (values.length <= 0) {
            throw new IllegalArgumentException(name + " must not be empty.");
        }
        for (T value : values) {
            if (value != null) continue;
            throw new NullPointerException(name + " must not contain null values.");
        }
    }

    public static void checkNotEmpty(Collection<?> values, String name) {
        if (values == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (values.isEmpty()) {
            throw new IllegalArgumentException(name + " must not be empty.");
        }
        if (!(values instanceof class_2371)) {
            for (Object value : values) {
                if (value != null) continue;
                throw new NullPointerException(name + " must not contain null values.");
            }
        }
    }

    public static <T> void checkNotNull(@Nullable T object, String name) {
        if (object == null) {
            throw new NullPointerException(name + " must not be null.");
        }
    }

    public static void checkNotNull(Collection<?> values, String name) {
        if (values == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (!(values instanceof class_2371)) {
            for (Object value : values) {
                if (value != null) continue;
                throw new NullPointerException(name + " must not contain null values.");
            }
        }
    }

    public static void assertMainThread() {
        class_310 minecraft = class_310.method_1551();
        if (minecraft != null && !minecraft.method_18854()) {
            Thread currentThread = Thread.currentThread();
            throw new IllegalStateException("A JEI API method is being called by another mod from the wrong thread:\n" + currentThread + "\nIt must be called on the main thread by using Minecraft.addScheduledTask.");
        }
    }

    public static <T> class_148 createRenderIngredientException(Throwable throwable, T ingredient, RegisteredIngredients registeredIngredients) {
        IIngredientType ingredientType = registeredIngredients.getIngredientType(ingredient);
        IIngredientHelper ingredientHelper = registeredIngredients.getIngredientHelper(ingredientType);
        class_128 crashreport = class_128.method_560((Throwable)throwable, (String)"Rendering ingredient");
        class_129 ingredientCategory = crashreport.method_562("Ingredient being rendered");
        IPlatformModHelper modHelper = Services.PLATFORM.getModHelper();
        ingredientCategory.method_577("Mod Name", () -> {
            String modId = ingredientHelper.getDisplayModId(ingredient);
            return modHelper.getModNameForModId(modId);
        });
        ingredientCategory.method_577("Registry Name", () -> ingredientHelper.getResourceLocation(ingredient).toString());
        ingredientCategory.method_577("Display Name", () -> ingredientHelper.getDisplayName(ingredient));
        ingredientCategory.method_577("String Name", ingredient::toString);
        class_129 jeiCategory = crashreport.method_562("JEI render details");
        jeiCategory.method_577("Unique Id (for Blacklist)", () -> ingredientHelper.getUniqueId(ingredient, UidContext.Ingredient));
        jeiCategory.method_577("Ingredient Type", () -> ingredientType.getIngredientClass().toString());
        jeiCategory.method_577("Error Info", () -> ingredientHelper.getErrorInfo(ingredient));
        throw new class_148(crashreport);
    }
}

