/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.plugins.vanilla.crafting;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.common.plugins.vanilla.crafting.CategoryRecipeValidator;
import mezz.jei.common.util.ErrorUtil;
import net.minecraft.class_1263;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_310;
import net.minecraft.class_3859;
import net.minecraft.class_3861;
import net.minecraft.class_3862;
import net.minecraft.class_3920;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_3975;
import net.minecraft.class_5357;
import net.minecraft.class_638;

public final class VanillaRecipes {
    private final class_1863 recipeManager;

    public VanillaRecipes() {
        class_310 minecraft = class_310.method_1551();
        ErrorUtil.checkNotNull(minecraft, "minecraft");
        class_638 world = minecraft.field_1687;
        ErrorUtil.checkNotNull(world, "minecraft world");
        this.recipeManager = world.method_8433();
    }

    public Map<Boolean, List<class_3955>> getCraftingRecipes(IRecipeCategory<class_3955> craftingCategory) {
        CategoryRecipeValidator<class_3955> validator = new CategoryRecipeValidator<class_3955>(craftingCategory, 9);
        return this.recipeManager.method_30027(class_3956.field_17545).stream().filter(validator::isRecipeValid).collect(Collectors.partitioningBy(validator::isRecipeHandled));
    }

    public List<class_3975> getStonecuttingRecipes(IRecipeCategory<class_3975> stonecuttingCategory) {
        CategoryRecipeValidator<class_3975> validator = new CategoryRecipeValidator<class_3975>(stonecuttingCategory, 1);
        return VanillaRecipes.getValidHandledRecipes(this.recipeManager, class_3956.field_17641, validator);
    }

    public List<class_3861> getFurnaceRecipes(IRecipeCategory<class_3861> furnaceCategory) {
        CategoryRecipeValidator<class_3861> validator = new CategoryRecipeValidator<class_3861>(furnaceCategory, 1);
        return VanillaRecipes.getValidHandledRecipes(this.recipeManager, class_3956.field_17546, validator);
    }

    public List<class_3862> getSmokingRecipes(IRecipeCategory<class_3862> smokingCategory) {
        CategoryRecipeValidator<class_3862> validator = new CategoryRecipeValidator<class_3862>(smokingCategory, 1);
        return VanillaRecipes.getValidHandledRecipes(this.recipeManager, class_3956.field_17548, validator);
    }

    public List<class_3859> getBlastingRecipes(IRecipeCategory<class_3859> blastingCategory) {
        CategoryRecipeValidator<class_3859> validator = new CategoryRecipeValidator<class_3859>(blastingCategory, 1);
        return VanillaRecipes.getValidHandledRecipes(this.recipeManager, class_3956.field_17547, validator);
    }

    public List<class_3920> getCampfireCookingRecipes(IRecipeCategory<class_3920> campfireCategory) {
        CategoryRecipeValidator<class_3920> validator = new CategoryRecipeValidator<class_3920>(campfireCategory, 1);
        return VanillaRecipes.getValidHandledRecipes(this.recipeManager, class_3956.field_17549, validator);
    }

    public List<class_5357> getSmithingRecipes(IRecipeCategory<class_5357> smithingCategory) {
        CategoryRecipeValidator<class_5357> validator = new CategoryRecipeValidator<class_5357>(smithingCategory, 0);
        return VanillaRecipes.getValidHandledRecipes(this.recipeManager, class_3956.field_25388, validator);
    }

    private static <C extends class_1263, T extends class_1860<C>> List<T> getValidHandledRecipes(class_1863 recipeManager, class_3956<T> recipeType, CategoryRecipeValidator<T> validator) {
        return recipeManager.method_30027(recipeType).stream().filter(r -> validator.isRecipeValid(r) && validator.isRecipeHandled(r)).toList();
    }
}

