/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.input;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import javax.annotation.Nullable;
import mezz.jei.common.gui.HoverChecker;
import mezz.jei.common.gui.elements.DrawableNineSliceTexture;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.input.IUserInputHandler;
import mezz.jei.common.input.handlers.TextFieldInputHandler;
import mezz.jei.common.platform.IPlatformInputHelper;
import mezz.jei.common.platform.IPlatformScreenHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.core.util.TextHistory;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class GuiTextFieldFilter
extends class_342 {
    private static final int maxSearchLength = 128;
    private static final TextHistory history = new TextHistory();
    private final HoverChecker hoverChecker;
    private final DrawableNineSliceTexture background;
    private ImmutableRect2i backgroundBounds;
    private boolean previousKeyboardRepeatEnabled;
    @Nullable
    private class_339 previouslyFocusedWidget;

    public GuiTextFieldFilter(Textures textures) {
        super(class_310.method_1551().field_1772, 0, 0, 0, 0, class_2585.field_24366);
        this.method_1880(128);
        this.hoverChecker = new HoverChecker();
        this.background = textures.getSearchBackground();
        this.backgroundBounds = ImmutableRect2i.EMPTY;
        this.method_1858(false);
    }

    public void updateBounds(ImmutableRect2i area) {
        this.backgroundBounds = area;
        this.field_22760 = area.getX() + 4;
        this.field_22761 = area.getY() + (area.getHeight() - 8) / 2;
        this.field_22758 = area.getWidth() - 12;
        this.field_22759 = area.getHeight();
        this.hoverChecker.updateBounds(area);
    }

    public void method_1852(String filterText) {
        if (!filterText.equals(this.method_1882())) {
            super.method_1852(filterText);
        }
    }

    public Optional<String> getHistory(TextHistory.Direction direction) {
        String currentText = this.method_1882();
        return history.get(direction, currentText);
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.hoverChecker.checkHover(mouseX, mouseY);
    }

    public IUserInputHandler createInputHandler() {
        return new TextFieldInputHandler(this);
    }

    public void method_25365(boolean keyboardFocus) {
        boolean previousFocus = this.method_25370();
        super.method_25365(keyboardFocus);
        if (previousFocus != keyboardFocus) {
            class_310 minecraft = class_310.method_1551();
            if (keyboardFocus) {
                IPlatformInputHelper inputHelper = Services.PLATFORM.getInputHelper();
                this.previousKeyboardRepeatEnabled = inputHelper.isSendRepeatsToGui(minecraft.field_1774);
                minecraft.field_1774.method_1462(true);
                class_437 screen = minecraft.field_1755;
                if (screen != null) {
                    class_364 class_3642 = screen.method_25399();
                    if (class_3642 instanceof class_339) {
                        class_339 widget = (class_339)class_3642;
                        IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
                        screenHelper.setFocused(widget, false);
                        this.previouslyFocusedWidget = widget;
                    }
                    screen.method_25395(null);
                }
            } else {
                if (this.previouslyFocusedWidget != null) {
                    class_437 screen = minecraft.field_1755;
                    if (screen != null) {
                        IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
                        screenHelper.setFocused(this.previouslyFocusedWidget, true);
                        screen.method_25395((class_364)this.previouslyFocusedWidget);
                    }
                    this.previouslyFocusedWidget = null;
                }
                minecraft.field_1774.method_1462(this.previousKeyboardRepeatEnabled);
            }
            String text = this.method_1882();
            history.add(text);
        }
    }

    public void method_25359(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.method_1885()) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.background.draw(poseStack, this.backgroundBounds);
        }
        super.method_25359(poseStack, mouseX, mouseY, partialTicks);
    }
}

