/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui.overlay.bookmarks;

import java.util.List;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.common.bookmarks.BookmarkList;
import mezz.jei.common.gui.elements.GuiIconToggleButton;
import mezz.jei.common.gui.overlay.bookmarks.BookmarkOverlay;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.input.IKeyBindings;
import mezz.jei.common.input.UserInput;
import mezz.jei.common.input.keys.IJeiKeyMapping;
import mezz.jei.core.config.IWorldConfig;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2588;

public class BookmarkButton
extends GuiIconToggleButton {
    private final BookmarkOverlay bookmarkOverlay;
    private final BookmarkList bookmarkList;
    private final IWorldConfig worldConfig;
    private final IKeyBindings keyBindings;

    public static BookmarkButton create(BookmarkOverlay bookmarkOverlay, BookmarkList bookmarkList, Textures textures, IWorldConfig worldConfig, IKeyBindings keyBindings) {
        IDrawableStatic offIcon = textures.getBookmarkButtonDisabledIcon();
        IDrawableStatic onIcon = textures.getBookmarkButtonEnabledIcon();
        return new BookmarkButton(offIcon, onIcon, textures, bookmarkOverlay, bookmarkList, worldConfig, keyBindings);
    }

    private BookmarkButton(IDrawable offIcon, IDrawable onIcon, Textures textures, BookmarkOverlay bookmarkOverlay, BookmarkList bookmarkList, IWorldConfig worldConfig, IKeyBindings keyBindings) {
        super(offIcon, onIcon, textures);
        this.bookmarkOverlay = bookmarkOverlay;
        this.bookmarkList = bookmarkList;
        this.worldConfig = worldConfig;
        this.keyBindings = keyBindings;
    }

    @Override
    protected void getTooltips(List<class_2561> tooltip) {
        tooltip.add((class_2561)new class_2588("jei.tooltip.bookmarks"));
        IJeiKeyMapping bookmarkKey = this.keyBindings.getBookmark();
        if (bookmarkKey.isUnbound()) {
            class_2588 noKey = new class_2588("jei.tooltip.bookmarks.usage.nokey");
            tooltip.add((class_2561)noKey.method_27692(class_124.field_1061));
        } else if (!this.bookmarkOverlay.hasRoom()) {
            class_2588 notEnoughSpace = new class_2588("jei.tooltip.bookmarks.not.enough.space");
            tooltip.add((class_2561)notEnoughSpace.method_27692(class_124.field_1065));
        } else {
            class_2588 key = new class_2588("jei.tooltip.bookmarks.usage.key", new Object[]{bookmarkKey.getTranslatedKeyMessage()});
            tooltip.add((class_2561)key.method_27692(class_124.field_1080));
        }
    }

    @Override
    protected boolean isIconToggledOn() {
        return this.bookmarkOverlay.isListDisplayed();
    }

    @Override
    protected boolean onMouseClicked(UserInput input) {
        if (!this.bookmarkList.isEmpty() && this.bookmarkOverlay.hasRoom()) {
            if (!input.isSimulate()) {
                this.worldConfig.toggleBookmarkEnabled();
            }
            return true;
        }
        return false;
    }
}

