/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui.overlay;

import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.common.gui.elements.GuiIconToggleButton;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.input.IKeyBindings;
import mezz.jei.common.input.UserInput;
import mezz.jei.common.platform.IPlatformConfigHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.core.config.IWorldConfig;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class ConfigButton
extends GuiIconToggleButton {
    private final IKeyBindings keyBindings;
    private final BooleanSupplier isListDisplayed;
    private final IWorldConfig worldConfig;

    public static ConfigButton create(BooleanSupplier isListDisplayed, IWorldConfig worldConfig, Textures textures, IKeyBindings keyBindings) {
        return new ConfigButton(textures.getConfigButtonIcon(), textures.getConfigButtonCheatIcon(), isListDisplayed, worldConfig, textures, keyBindings);
    }

    private ConfigButton(IDrawable disabledIcon, IDrawable enabledIcon, BooleanSupplier isListDisplayed, IWorldConfig worldConfig, Textures textures, IKeyBindings keyBindings) {
        super(disabledIcon, enabledIcon, textures);
        this.isListDisplayed = isListDisplayed;
        this.worldConfig = worldConfig;
        this.keyBindings = keyBindings;
    }

    @Override
    protected void getTooltips(List<class_2561> tooltip) {
        tooltip.add((class_2561)new class_2588("jei.tooltip.config"));
        if (!this.worldConfig.isOverlayEnabled()) {
            class_2588 disabled = new class_2588("jei.tooltip.ingredient.list.disabled");
            class_2588 disabledFix = new class_2588("jei.tooltip.ingredient.list.disabled.how.to.fix", new Object[]{this.keyBindings.getToggleOverlay().getTranslatedKeyMessage()});
            tooltip.add((class_2561)disabled.method_27692(class_124.field_1065));
            tooltip.add((class_2561)disabledFix.method_27692(class_124.field_1065));
        } else if (!this.isListDisplayed.getAsBoolean()) {
            class_2588 notEnoughSpace = new class_2588("jei.tooltip.not.enough.space");
            tooltip.add((class_2561)notEnoughSpace.method_27692(class_124.field_1065));
        }
        if (this.worldConfig.isCheatItemsEnabled()) {
            class_5250 enabled = new class_2588("jei.tooltip.cheat.mode.button.enabled").method_27692(class_124.field_1061);
            tooltip.add((class_2561)enabled);
            if (!this.keyBindings.getToggleCheatMode().isUnbound()) {
                component = new class_2588("jei.tooltip.cheat.mode.how.to.disable.hotkey", new Object[]{this.keyBindings.getToggleCheatMode().getTranslatedKeyMessage()}).method_27692(class_124.field_1061);
                tooltip.add((class_2561)component);
            } else if (!this.keyBindings.getToggleCheatModeConfigButton().isUnbound()) {
                component = new class_2588("jei.tooltip.cheat.mode.how.to.disable.hover.config.button.hotkey", new Object[]{this.keyBindings.getToggleCheatModeConfigButton().getTranslatedKeyMessage()}).method_27692(class_124.field_1061);
                tooltip.add((class_2561)component);
            }
        }
    }

    @Override
    protected boolean isIconToggledOn() {
        return this.worldConfig.isCheatItemsEnabled();
    }

    @Override
    protected boolean onMouseClicked(UserInput input) {
        if (this.worldConfig.isOverlayEnabled()) {
            if (!input.isSimulate()) {
                if (input.is(this.keyBindings.getToggleCheatModeConfigButton())) {
                    this.worldConfig.toggleCheatItemsEnabled();
                } else {
                    ConfigButton.openSettings();
                }
            }
            return true;
        }
        return false;
    }

    private static void openSettings() {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null) {
            return;
        }
        IPlatformConfigHelper configHelper = Services.PLATFORM.getConfigHelper();
        Optional<class_437> configScreen = configHelper.getConfigScreen();
        if (configScreen.isPresent()) {
            mc.method_1507(configScreen.get());
        } else {
            class_2561 message = configHelper.getMissingConfigScreenMessage();
            mc.field_1724.method_7353(message, false);
        }
    }
}

