/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui.ghost;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.common.input.UserInput;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5944;
import net.minecraft.class_757;
import net.minecraft.class_768;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class GhostIngredientDrag<T> {
    private static final int targetColor = 1075038474;
    private static final int hoverColor = -2142451431;
    private final IGhostIngredientHandler<?> handler;
    private final List<IGhostIngredientHandler.Target<T>> targets;
    private final IIngredientRenderer<T> ingredientRenderer;
    private final T ingredient;
    private final double mouseStartX;
    private final double mouseStartY;
    @Nullable
    private final ImmutableRect2i origin;

    public GhostIngredientDrag(IGhostIngredientHandler<?> handler, List<IGhostIngredientHandler.Target<T>> targets, IIngredientRenderer<T> ingredientRenderer, T ingredient, double mouseX, double mouseY, @Nullable ImmutableRect2i origin) {
        this.handler = handler;
        this.targets = targets;
        this.ingredientRenderer = ingredientRenderer;
        this.ingredient = ingredient;
        this.origin = origin;
        this.mouseStartX = mouseX;
        this.mouseStartY = mouseY;
    }

    public void drawTargets(class_4587 poseStack, int mouseX, int mouseY) {
        if (this.handler.shouldHighlightTargets()) {
            GhostIngredientDrag.drawTargets(poseStack, mouseX, mouseY, this.targets);
        }
    }

    public static boolean farEnoughToDraw(GhostIngredientDrag<?> drag, double mouseX, double mouseY) {
        double centerY;
        double centerX;
        ImmutableRect2i origin = drag.getOrigin();
        if (origin != null) {
            centerX = (double)origin.getX() + (double)origin.getWidth() / 2.0;
            centerY = (double)origin.getY() + (double)origin.getHeight() / 2.0;
        } else {
            centerX = drag.mouseStartX;
            centerY = drag.mouseStartY;
        }
        double mouseXDist = centerX - mouseX;
        double mouseYDist = centerY - mouseY;
        double mouseDistSq = mouseXDist * mouseXDist + mouseYDist * mouseYDist;
        return mouseDistSq > 64.0;
    }

    public void drawItem(class_310 minecraft, class_4587 poseStack, int mouseX, int mouseY) {
        if (!GhostIngredientDrag.farEnoughToDraw(this, mouseX, mouseY)) {
            return;
        }
        if (this.origin != null) {
            int originX = this.origin.getX() + this.origin.getWidth() / 2;
            int originY = this.origin.getY() + this.origin.getHeight() / 2;
            RenderSystem.disableTexture();
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            class_5944 oldShader = RenderSystem.getShader();
            RenderSystem.setShader(class_757::method_34540);
            GL11.glEnable((int)2848);
            GL11.glHint((int)3154, (int)4354);
            class_289 tesselator = RenderSystem.renderThreadTesselator();
            class_287 builder = tesselator.method_1349();
            builder.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
            float red = 0.2509804f;
            float green = 0.07450981f;
            float blue = 0.7882353f;
            float alpha = 0.039215688f;
            builder.method_22912((double)mouseX, (double)mouseY, 150.0).method_22915(red, green, blue, alpha).method_1344();
            builder.method_22912((double)originX, (double)originY, 150.0).method_22915(red, green, blue, alpha).method_1344();
            tesselator.method_1350();
            RenderSystem.setShader(() -> oldShader);
            RenderSystem.enableDepthTest();
            RenderSystem.enableTexture();
            RenderSystem.depthMask((boolean)true);
        }
        class_918 itemRenderer = minecraft.method_1480();
        itemRenderer.field_4730 += 150.0f;
        poseStack.method_22903();
        poseStack.method_22904((double)(mouseX - 8), (double)(mouseY - 8), 0.0);
        this.ingredientRenderer.render(poseStack, this.ingredient);
        poseStack.method_22909();
        itemRenderer.field_4730 -= 150.0f;
    }

    public static <V> void drawTargets(class_4587 poseStack, int mouseX, int mouseY, List<IGhostIngredientHandler.Target<V>> targets) {
        RenderSystem.disableDepthTest();
        for (IGhostIngredientHandler.Target<V> target : targets) {
            class_768 area = target.getArea();
            int color = MathUtil.contains(area, (double)mouseX, (double)mouseY) ? -2142451431 : 1075038474;
            class_332.method_25294((class_4587)poseStack, (int)area.method_3321(), (int)area.method_3322(), (int)(area.method_3321() + area.method_3319()), (int)(area.method_3322() + area.method_3320()), (int)color);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean onClick(UserInput input) {
        for (IGhostIngredientHandler.Target<T> target : this.targets) {
            class_768 area = target.getArea();
            if (!MathUtil.contains(area, input.getMouseX(), input.getMouseY())) continue;
            if (!input.isSimulate()) {
                target.accept(this.ingredient);
                this.handler.onComplete();
            }
            return true;
        }
        if (!input.isSimulate()) {
            this.handler.onComplete();
        }
        return false;
    }

    public void stop() {
        this.handler.onComplete();
    }

    public IIngredientRenderer<T> getIngredientRenderer() {
        return this.ingredientRenderer;
    }

    public T getIngredient() {
        return this.ingredient;
    }

    @Nullable
    public ImmutableRect2i getOrigin() {
        return this.origin;
    }
}

