/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui;

import mezz.jei.common.gui.elements.GuiIconButton;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.input.IPaged;
import mezz.jei.common.input.IUserInputHandler;
import mezz.jei.common.input.handlers.CombinedInputHandler;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class PageNavigation {
    private final IPaged paged;
    private final GuiIconButton nextButton;
    private final GuiIconButton backButton;
    private final boolean hideOnSinglePage;
    private String pageNumDisplayString = "1/1";
    private ImmutableRect2i area = ImmutableRect2i.EMPTY;

    public PageNavigation(IPaged paged, boolean hideOnSinglePage, Textures textures) {
        this.paged = paged;
        this.nextButton = new GuiIconButton(textures.getArrowNext(), b -> paged.nextPage(), textures);
        this.backButton = new GuiIconButton(textures.getArrowPrevious(), b -> paged.previousPage(), textures);
        this.hideOnSinglePage = hideOnSinglePage;
    }

    private boolean isVisible() {
        if (this.area.isEmpty()) {
            return false;
        }
        return !this.hideOnSinglePage || this.paged.hasNext() || this.paged.hasPrevious();
    }

    public void updateBounds(ImmutableRect2i area) {
        this.area = area;
        int buttonSize = area.getHeight();
        ImmutableRect2i backArea = area.keepLeft(buttonSize);
        this.backButton.updateBounds(backArea);
        ImmutableRect2i nextArea = area.keepRight(buttonSize);
        this.nextButton.updateBounds(nextArea);
    }

    public void updatePageNumber() {
        int pageNum = this.paged.getPageNumber();
        int pageCount = this.paged.getPageCount();
        this.pageNumDisplayString = String.format("%d/%d", pageNum + 1, pageCount);
    }

    public void draw(class_310 minecraft, class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.isVisible()) {
            class_332.method_25294((class_4587)poseStack, (int)(this.backButton.field_22760 + this.backButton.method_25368()), (int)this.backButton.field_22761, (int)this.nextButton.field_22760, (int)(this.nextButton.field_22761 + this.nextButton.method_25364()), (int)0x30000000);
            class_327 font = minecraft.field_1772;
            ImmutableRect2i centerArea = MathUtil.centerTextArea(this.area, font, this.pageNumDisplayString);
            font.method_1720(poseStack, this.pageNumDisplayString, (float)centerArea.getX(), (float)centerArea.getY(), -1);
            this.nextButton.method_25394(poseStack, mouseX, mouseY, partialTicks);
            this.backButton.method_25394(poseStack, mouseX, mouseY, partialTicks);
        }
    }

    public IUserInputHandler createInputHandler() {
        return new CombinedInputHandler(this.nextButton.createInputHandler(), this.backButton.createInputHandler());
    }
}

