/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.deprecated.gui.ingredients.adapters;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.runtime.IIngredientVisibility;
import mezz.jei.common.deprecated.gui.ingredients.adapters.LegacyAdaptedIngredientRenderer;
import mezz.jei.common.deprecated.gui.ingredients.adapters.LegacyTooltipAdapter;
import mezz.jei.common.deprecated.gui.ingredients.adapters.RecipeSlotGuiIngredientAdapter;
import mezz.jei.common.focus.FocusGroup;
import mezz.jei.common.gui.ingredients.RecipeSlot;
import mezz.jei.common.gui.ingredients.RecipeSlots;
import mezz.jei.common.ingredients.RegisteredIngredients;
import mezz.jei.common.ingredients.TypedIngredient;
import mezz.jei.common.util.ErrorUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class RecipeSlotsGuiIngredientGroupAdapter<T>
implements IGuiIngredientGroup<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final RecipeSlots recipeSlots;
    private final RegisteredIngredients registeredIngredients;
    private final IIngredientType<T> ingredientType;
    private final Map<Integer, RecipeSlotGuiIngredientAdapter<T>> guiIngredientsCache = new Int2ObjectArrayMap();
    private final List<IRecipeSlotTooltipCallback> legacyTooltipCallbacks = new ArrayList<IRecipeSlotTooltipCallback>();
    private final int cycleOffset;
    private IFocusGroup focuses = FocusGroup.EMPTY;
    private boolean slotsCreatedWithLegacyInit = false;
    private IIngredientVisibility ingredientVisibility;

    public RecipeSlotsGuiIngredientGroupAdapter(RecipeSlots recipeSlots, RegisteredIngredients registeredIngredients, IIngredientType<T> ingredientType, IIngredientVisibility ingredientVisibility, int cycleOffset) {
        this.recipeSlots = recipeSlots;
        this.registeredIngredients = registeredIngredients;
        this.ingredientType = ingredientType;
        this.ingredientVisibility = ingredientVisibility;
        this.cycleOffset = cycleOffset;
    }

    private Optional<RecipeSlot> getSlot(int guiIngredientIndex) {
        Map<Integer, RecipeSlotGuiIngredientAdapter<T>> guiIngredients = this.getGuiIngredients();
        RecipeSlotGuiIngredientAdapter<T> adapter = guiIngredients.get(guiIngredientIndex);
        return Optional.ofNullable(adapter).map(RecipeSlotGuiIngredientAdapter::getRecipeSlot);
    }

    @Override
    public void setBackground(int slotIndex, IDrawable background) {
        ErrorUtil.checkNotNull(background, "background");
        this.getSlot(slotIndex).ifPresent(recipeSlot -> recipeSlot.setBackground(background));
    }

    @Override
    public Map<Integer, RecipeSlotGuiIngredientAdapter<T>> getGuiIngredients() {
        List<RecipeSlot> slots = this.recipeSlots.getSlots();
        if (!this.slotsCreatedWithLegacyInit) {
            for (RecipeSlot recipeSlot : slots) {
                int index = recipeSlot.getLegacyIngredientIndex();
                if (this.guiIngredientsCache.containsKey(index)) continue;
                RecipeSlotGuiIngredientAdapter<T> adapter = new RecipeSlotGuiIngredientAdapter<T>(recipeSlot, this.ingredientType);
                this.guiIngredientsCache.put(index, adapter);
            }
        }
        return Collections.unmodifiableMap(this.guiIngredientsCache);
    }

    @Override
    public void init(int ingredientIndex, boolean input, int xPosition, int yPosition) {
        RecipeIngredientRole role = input ? RecipeIngredientRole.INPUT : RecipeIngredientRole.OUTPUT;
        IIngredientRenderer<T> ingredientRenderer = this.registeredIngredients.getIngredientRenderer(this.ingredientType);
        this.addSlot(ingredientIndex, role, ingredientRenderer, xPosition, yPosition, 16, 16, 0, 0);
    }

    @Override
    public void init(int ingredientIndex, boolean input, IIngredientRenderer<T> ingredientRenderer, int xPosition, int yPosition, int width, int height, int xInset, int yInset) {
        ErrorUtil.checkNotNull(ingredientRenderer, "ingredientRenderer");
        RecipeIngredientRole role = input ? RecipeIngredientRole.INPUT : RecipeIngredientRole.OUTPUT;
        this.addSlot(ingredientIndex, role, ingredientRenderer, xPosition, yPosition, width, height, xInset, yInset);
    }

    private void addSlot(int legacyIngredientIndex, RecipeIngredientRole role, IIngredientRenderer<T> ingredientRenderer, int xPosition, int yPosition, int width, int height, int xInset, int yInset) {
        IIngredientRenderer<T> legacyAdaptedIngredientRenderer = LegacyAdaptedIngredientRenderer.create(ingredientRenderer, width, height, xInset, yInset);
        RecipeSlot recipeSlot = new RecipeSlot(this.registeredIngredients, role, xPosition, yPosition, this.cycleOffset, legacyIngredientIndex);
        recipeSlot.addRenderOverride(this.ingredientType, legacyAdaptedIngredientRenderer);
        this.recipeSlots.addSlot(recipeSlot);
        RecipeSlotGuiIngredientAdapter<T> adapter = new RecipeSlotGuiIngredientAdapter<T>(recipeSlot, this.ingredientType);
        this.guiIngredientsCache.put(legacyIngredientIndex, adapter);
        this.slotsCreatedWithLegacyInit = true;
    }

    @Override
    public void setOverrideDisplayFocus(@Nullable IFocus<T> focus) {
        this.focuses = FocusGroup.createFromNullable(focus, this.registeredIngredients);
    }

    @Override
    public void addTooltipCallback(ITooltipCallback<T> tooltipCallback) {
        ErrorUtil.checkNotNull(tooltipCallback, "tooltipCallback");
        LegacyTooltipAdapter legacyTooltipAdapter = new LegacyTooltipAdapter(this.ingredientType, tooltipCallback);
        this.legacyTooltipCallbacks.add(legacyTooltipAdapter);
        this.recipeSlots.getSlots().forEach(slot -> slot.addTooltipCallback(legacyTooltipAdapter));
    }

    @Override
    public void set(IIngredients ingredients) {
        ErrorUtil.checkNotNull(ingredients, "ingredients");
        List<@Nullable List<@Nullable T>> inputs = ingredients.getInputs(this.ingredientType);
        List<@Nullable List<@Nullable T>> outputs = ingredients.getOutputs(this.ingredientType);
        int inputIndex = 0;
        int outputIndex = 0;
        Map<Integer, RecipeSlotGuiIngredientAdapter<T>> guiIngredients = this.getGuiIngredients();
        ArrayList<Integer> slotIndexes = new ArrayList<Integer>(guiIngredients.keySet());
        Collections.sort(slotIndexes);
        Iterator iterator = slotIndexes.iterator();
        while (iterator.hasNext()) {
            int slotIndex = (Integer)iterator.next();
            IGuiIngredient guiIngredient = guiIngredients.get(slotIndex);
            if (guiIngredient.isInput()) {
                if (inputIndex >= inputs.size()) continue;
                @Nullable List<@Nullable T> input = inputs.get(inputIndex);
                ++inputIndex;
                this.set(slotIndex, input);
                continue;
            }
            if (outputIndex >= outputs.size()) continue;
            @Nullable List<@Nullable T> output = outputs.get(outputIndex);
            ++outputIndex;
            this.set(slotIndex, output);
        }
    }

    @Override
    public void set(int ingredientIndex, @Nullable T value) {
        this.set(ingredientIndex, Collections.singletonList(value));
    }

    @Override
    public void set(int slotIndex, @Nullable @Nullable List<@Nullable T> ingredients) {
        if (ingredients != null) {
            Class<T> ingredientClass = this.ingredientType.getIngredientClass();
            for (T ingredient : ingredients) {
                if (ingredientClass.isInstance(ingredient) || ingredient == null) continue;
                LOGGER.error("Received wrong type of ingredient. Expected {}, got {}", ingredientClass, ingredient.getClass(), (Object)new IllegalArgumentException());
                return;
            }
        }
        this.getSlot(slotIndex).ifPresent(recipeSlot -> {
            List<Optional<ITypedIngredient<?>>> typedIngredients = this.getTypedIngredients(ingredients);
            IntSet focusMatches = this.getMatches(this.focuses, recipeSlot.getRole(), typedIngredients);
            recipeSlot.set(typedIngredients, focusMatches, this.ingredientVisibility);
            this.legacyTooltipCallbacks.forEach(recipeSlot::addTooltipCallback);
        });
    }

    private List<Optional<ITypedIngredient<?>>> getTypedIngredients(@Nullable @Nullable List<@Nullable T> ingredients) {
        if (ingredients == null) {
            return List.of();
        }
        return ingredients.stream().map(i -> TypedIngredient.create(this.registeredIngredients, this.ingredientType, i)).toList();
    }

    private IntSet getMatches(IFocusGroup focuses, RecipeIngredientRole role, List<Optional<ITypedIngredient<?>>> ingredients) {
        int[] matches = focuses.getFocuses(this.ingredientType, role).map(focus -> this.getMatch((IFocus<T>)focus, ingredients)).flatMapToInt(OptionalInt::stream).distinct().toArray();
        return new IntArraySet(matches);
    }

    private OptionalInt getMatch(IFocus<T> focus, List<Optional<ITypedIngredient<?>>> ingredients) {
        if (ingredients.isEmpty()) {
            return OptionalInt.empty();
        }
        ITypedIngredient<T> focusValue = focus.getTypedValue();
        T focusIngredient = focusValue.getIngredient();
        IIngredientHelper ingredientHelper = this.registeredIngredients.getIngredientHelper(this.ingredientType);
        String focusUid = ingredientHelper.getUniqueId(focusIngredient, UidContext.Ingredient);
        return IntStream.range(0, ingredients.size()).filter(i -> ((Optional)ingredients.get(i)).flatMap(typedIngredient -> typedIngredient.getIngredient(this.ingredientType)).map(ingredient -> {
            String uniqueId = ingredientHelper.getUniqueId(ingredient, UidContext.Ingredient);
            return focusUid.equals(uniqueId);
        }).orElse(false)).findFirst();
    }
}

