/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mezz.jei.Internal;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.HoverChecker;
import mezz.jei.gui.elements.DrawableNineSliceTexture;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.gui.overlay.IIngredientGridSource;
import mezz.jei.input.TextHistory;
import mezz.jei.input.UserInput;
import mezz.jei.input.mouse.IUserInputHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.TextComponent;

public class GuiTextFieldFilter
extends EditBox {
    private static final int maxSearchLength = 128;
    private static final TextHistory history = new TextHistory();
    private final HoverChecker hoverChecker;
    private final IIngredientGridSource ingredientSource;
    private final DrawableNineSliceTexture background;
    private boolean previousKeyboardRepeatEnabled;
    private boolean isDrawing = false;

    public GuiTextFieldFilter(IIngredientGridSource ingredientSource) {
        super(Minecraft.m_91087_().f_91062_, 0, 0, 0, 0, TextComponent.f_131282_);
        this.m_94199_(128);
        this.hoverChecker = new HoverChecker();
        this.ingredientSource = ingredientSource;
        this.background = Internal.getTextures().getSearchBackground();
    }

    public void updateBounds(Rect2i area) {
        this.f_93620_ = area.m_110085_();
        this.f_93621_ = area.m_110086_();
        this.f_93618_ = area.m_110090_();
        this.f_93619_ = area.m_110091_();
        this.hoverChecker.updateBounds(area.m_110086_(), area.m_110086_() + area.m_110091_(), area.m_110085_(), area.m_110085_() + area.m_110090_());
        this.m_94208_(this.m_94207_());
    }

    public void m_94144_(String filterText) {
        List<IIngredientListElement<?>> ingredientList;
        if (!filterText.equals(this.m_94155_())) {
            super.m_94144_(filterText);
        }
        if ((ingredientList = this.ingredientSource.getIngredientList(filterText)).size() == 0) {
            this.m_94202_(-65536);
        } else {
            this.m_94202_(-1);
        }
    }

    private boolean navigateHistory(UserInput userInput) {
        String currentText = this.m_94155_();
        String newText = null;
        if (userInput.is(KeyBindings.previousSearch)) {
            newText = history.getPrevious(currentText);
        } else if (userInput.is(KeyBindings.nextSearch)) {
            newText = history.getNext(currentText);
        }
        if (newText != null) {
            if (!userInput.isSimulate()) {
                this.m_94144_(newText);
            }
            return true;
        }
        return false;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return this.hoverChecker.checkHover(mouseX, mouseY);
    }

    public IUserInputHandler createInputHandler() {
        return new UserInputHandler();
    }

    public void m_93692_(boolean keyboardFocus) {
        boolean previousFocus = this.m_93696_();
        super.m_93692_(keyboardFocus);
        if (previousFocus != keyboardFocus) {
            Minecraft minecraft = Minecraft.m_91087_();
            if (keyboardFocus) {
                this.previousKeyboardRepeatEnabled = minecraft.f_91068_.f_90868_;
                minecraft.f_91068_.m_90926_(true);
            } else {
                minecraft.f_91068_.m_90926_(this.previousKeyboardRepeatEnabled);
            }
            String text = this.m_94155_();
            history.add(text);
        }
    }

    protected boolean m_94219_() {
        if (this.isDrawing) {
            return false;
        }
        return super.m_94219_();
    }

    public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.isDrawing = true;
        if (this.m_94213_()) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.background.draw(poseStack, this.f_93620_, this.f_93621_, this.f_93618_, this.f_93619_);
        }
        super.m_6303_(poseStack, mouseX, mouseY, partialTicks);
        this.isDrawing = false;
    }

    private class UserInputHandler
    implements IUserInputHandler {
        private UserInputHandler() {
        }

        @Override
        public IUserInputHandler handleUserInput(Screen screen, UserInput input) {
            if (GuiTextFieldFilter.this.m_93696_() && (input.isEscapeKey() || input.isEnterKey())) {
                GuiTextFieldFilter.this.m_93692_(false);
                return this;
            }
            if (input.is(KeyBindings.focusSearch)) {
                if (!input.isSimulate()) {
                    GuiTextFieldFilter.this.m_93692_(true);
                }
                return this;
            }
            if (GuiTextFieldFilter.this.m_5953_(input.getMouseX(), input.getMouseY()) && input.is(KeyBindings.hoveredClearSearchBar)) {
                if (!input.isSimulate()) {
                    GuiTextFieldFilter.this.m_94144_("");
                    GuiTextFieldFilter.this.m_93692_(true);
                }
                return this;
            }
            if (input.callVanilla(GuiTextFieldFilter.this::m_5953_, (arg_0, arg_1, arg_2) -> ((GuiTextFieldFilter)GuiTextFieldFilter.this).m_6375_(arg_0, arg_1, arg_2), (arg_0, arg_1, arg_2) -> ((GuiTextFieldFilter)GuiTextFieldFilter.this).m_7933_(arg_0, arg_1, arg_2))) {
                return this;
            }
            if (GuiTextFieldFilter.this.navigateHistory(input)) {
                return this;
            }
            if (GuiTextFieldFilter.this.m_94204_() && input.isAllowedChatCharacter()) {
                return this;
            }
            return null;
        }

        @Override
        public void handleMouseClickedOut(InputConstants.Key input) {
            GuiTextFieldFilter.this.m_93692_(false);
        }
    }
}

