/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.gui.Focus;
import mezz.jei.gui.ingredients.GuiIngredient;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.render.IngredientListElementRenderer;

public final class IngredientTypeHelper {
    public static <T> Stream<IIngredientListElement<T>> ofType(Stream<IIngredientListElement<?>> stream, IIngredientType<T> ingredientType) {
        Class ingredientClass = ingredientType.getIngredientClass();
        return stream.filter(i -> ingredientClass.isInstance(i.getIngredient()));
    }

    @Nullable
    public static <T> IClickedIngredient<T> checkedCast(IClickedIngredient<?> clicked, IIngredientType<T> ingredientType) {
        Object ingredient = clicked.getValue();
        Class<T> ingredientClass = ingredientType.getIngredientClass();
        if (ingredientClass.isInstance(ingredient)) {
            return clicked;
        }
        return null;
    }

    @Nullable
    public static <V> Focus<V> checkedCast(@Nullable Focus<?> focus, IIngredientType<V> ingredientType) {
        if (focus == null) {
            return null;
        }
        Class<V> ingredientClass = ingredientType.getIngredientClass();
        if (ingredientClass.isInstance(focus.getValue())) {
            return focus;
        }
        return null;
    }

    @Nullable
    public static <T> IngredientListElementRenderer<T> checkedCast(@Nullable IngredientListElementRenderer<?> ingredientListElement, IIngredientType<T> ingredientType) {
        if (ingredientListElement == null) {
            return null;
        }
        Object ingredient = ingredientListElement.getElement().getIngredient();
        Class<T> ingredientClass = ingredientType.getIngredientClass();
        if (ingredientClass.isInstance(ingredient)) {
            return ingredientListElement;
        }
        return null;
    }

    @Nullable
    public static <T> GuiIngredient<T> checkedCast(GuiIngredient<?> guiIngredient, IIngredientType<T> ingredientType) {
        if (guiIngredient.getIngredientType() == ingredientType) {
            return guiIngredient;
        }
        return null;
    }

    @Nullable
    public static <T> IIngredientListElement<T> checkedCast(IIngredientListElement<?> element, IIngredientType<T> ingredientType) {
        Class<T> ingredientClass = ingredientType.getIngredientClass();
        if (ingredientClass.isInstance(element.getIngredient())) {
            return element;
        }
        return null;
    }
}

