/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.util.ExpandNewLineTextAcceptor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;

public final class StringUtil {
    private StringUtil() {
    }

    public static Component stripStyling(Component textComponent) {
        MutableComponent text = textComponent.m_6879_();
        for (Component sibling : textComponent.m_7360_()) {
            text.m_7220_(StringUtil.stripStyling(sibling));
        }
        return text;
    }

    public static Component truncateStringToWidth(Component text, int width, Font fontRenderer) {
        int ellipsisWidth = fontRenderer.m_92895_("...");
        FormattedText truncatedText = fontRenderer.m_92854_((FormattedText)text, width - ellipsisWidth);
        String truncatedTextString = truncatedText.getString();
        return new TextComponent(truncatedTextString + "...");
    }

    public static List<FormattedText> splitLines(FormattedText line, int width) {
        if (width <= 0) {
            return List.of(line);
        }
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        StringSplitter splitter = font.m_92865_();
        return splitter.m_92414_(line, width, Style.f_131099_);
    }

    public static List<FormattedText> splitLines(List<? extends FormattedText> lines, int width) {
        if (width <= 0) {
            return List.copyOf(lines);
        }
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        StringSplitter splitter = font.m_92865_();
        return lines.stream().flatMap(text -> splitter.m_92414_(text, width, Style.f_131099_).stream()).toList();
    }

    public static List<FormattedText> expandNewlines(Component ... descriptionComponents) {
        ArrayList<FormattedText> descriptionLinesExpanded = new ArrayList<FormattedText>();
        for (Component descriptionLine : descriptionComponents) {
            ExpandNewLineTextAcceptor newLineTextAcceptor = new ExpandNewLineTextAcceptor();
            descriptionLine.m_7451_((FormattedText.StyledContentConsumer)newLineTextAcceptor, Style.f_131099_);
            newLineTextAcceptor.addLinesTo(descriptionLinesExpanded);
        }
        return descriptionLinesExpanded;
    }
}

