/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.brewing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.collect.IngredientSet;
import mezz.jei.util.ErrorUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.brewing.VanillaBrewingRecipe;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BrewingRecipeMaker {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Set<Class<?>> unhandledRecipeClasses = new HashSet();
    private final Set<IJeiBrewingRecipe> disabledRecipes = new HashSet<IJeiBrewingRecipe>();
    private final IIngredientManager ingredientManager;
    private final IVanillaRecipeFactory vanillaRecipeFactory;

    public static List<IJeiBrewingRecipe> getBrewingRecipes(IIngredientManager ingredientManager, IVanillaRecipeFactory vanillaRecipeFactory) {
        BrewingRecipeMaker brewingRecipeMaker = new BrewingRecipeMaker(ingredientManager, vanillaRecipeFactory);
        return brewingRecipeMaker.getBrewingRecipes();
    }

    private BrewingRecipeMaker(IIngredientManager ingredientManager, IVanillaRecipeFactory vanillaRecipeFactory) {
        this.ingredientManager = ingredientManager;
        this.vanillaRecipeFactory = vanillaRecipeFactory;
    }

    private List<IJeiBrewingRecipe> getBrewingRecipes() {
        this.unhandledRecipeClasses.clear();
        HashSet<IJeiBrewingRecipe> recipes = new HashSet<IJeiBrewingRecipe>();
        List brewingRecipes = BrewingRecipeRegistry.getRecipes();
        brewingRecipes.stream().filter(r -> r instanceof VanillaBrewingRecipe).map(r -> (VanillaBrewingRecipe)r).findFirst().ifPresent(vanillaBrewingRecipe -> this.addVanillaBrewingRecipes((Collection<IJeiBrewingRecipe>)recipes, (VanillaBrewingRecipe)vanillaBrewingRecipe));
        this.addModdedBrewingRecipes(brewingRecipes, recipes);
        ArrayList<IJeiBrewingRecipe> recipeList = new ArrayList<IJeiBrewingRecipe>(recipes);
        recipeList.sort(Comparator.comparingInt(IJeiBrewingRecipe::getBrewingSteps));
        return recipeList;
    }

    private static boolean isIngredient(ItemStack itemStack) {
        try {
            return PotionBrewing.m_43506_((ItemStack)itemStack);
        }
        catch (LinkageError | RuntimeException e) {
            String itemStackInfo = ErrorUtil.getItemStackInfo(itemStack);
            LOGGER.error("Failed to check if item is a potion reagent {}.", (Object)itemStackInfo, (Object)e);
            return false;
        }
    }

    private void addVanillaBrewingRecipes(Collection<IJeiBrewingRecipe> recipes, VanillaBrewingRecipe vanillaBrewingRecipe) {
        boolean foundNewPotions;
        List<ItemStack> potionIngredients = this.ingredientManager.getAllIngredients(VanillaTypes.ITEM).stream().filter(BrewingRecipeMaker::isIngredient).toList();
        List basePotions = PotionBrewing.f_43496_.stream().flatMap(potionItem -> Arrays.stream(potionItem.m_43908_())).toList();
        IIngredientHelper<ItemStack> itemStackHelper = this.ingredientManager.getIngredientHelper(VanillaTypes.ITEM);
        IngredientSet<ItemStack> knownPotions = IngredientSet.create(itemStackHelper, UidContext.Ingredient);
        for (Potion potion : ForgeRegistries.POTIONS.getValues()) {
            if (potion == Potions.f_43598_) continue;
            for (ItemStack input : basePotions) {
                ItemStack result = PotionUtils.m_43549_((ItemStack)input.m_41777_(), (Potion)potion);
                knownPotions.add(result);
            }
        }
        do {
            List<ItemStack> newPotions;
            foundNewPotions = !(newPotions = this.getNewPotions(knownPotions, potionIngredients, recipes, vanillaBrewingRecipe)).isEmpty();
            knownPotions.addAll(newPotions);
        } while (foundNewPotions);
    }

    private List<ItemStack> getNewPotions(Collection<ItemStack> knownPotions, List<ItemStack> potionReagents, Collection<IJeiBrewingRecipe> recipes, VanillaBrewingRecipe vanillaBrewingRecipe) {
        ArrayList<ItemStack> newPotions = new ArrayList<ItemStack>();
        for (ItemStack potionInput : knownPotions) {
            for (ItemStack potionReagent : potionReagents) {
                IJeiBrewingRecipe recipe;
                ResourceLocation outputId;
                Potion potionInputType;
                ResourceLocation inputId;
                Potion potionOutputType;
                ItemStack potionOutput = vanillaBrewingRecipe.getOutput(potionInput.m_41777_(), potionReagent);
                if (potionOutput.m_41619_() || potionInput.m_41720_() == potionOutput.m_41720_() && ((potionOutputType = PotionUtils.m_43579_((ItemStack)potionOutput)) == Potions.f_43599_ || Objects.equals(inputId = ForgeRegistries.POTIONS.getKey((IForgeRegistryEntry)(potionInputType = PotionUtils.m_43579_((ItemStack)potionInput))), outputId = ForgeRegistries.POTIONS.getKey((IForgeRegistryEntry)potionOutputType))) || recipes.contains(recipe = this.vanillaRecipeFactory.createBrewingRecipe(Collections.singletonList(potionReagent), potionInput.m_41777_(), potionOutput)) || this.disabledRecipes.contains(recipe)) continue;
                if (BrewingRecipeRegistry.hasOutput((ItemStack)potionInput, (ItemStack)potionReagent)) {
                    recipes.add(recipe);
                } else {
                    this.disabledRecipes.add(recipe);
                }
                newPotions.add(potionOutput);
            }
        }
        return newPotions;
    }

    private void addModdedBrewingRecipes(Collection<IBrewingRecipe> brewingRecipes, Collection<IJeiBrewingRecipe> recipes) {
        for (IBrewingRecipe iBrewingRecipe : brewingRecipes) {
            Class<?> recipeClass;
            IBrewingRecipe iBrewingRecipe2 = iBrewingRecipe;
            if (iBrewingRecipe2 instanceof BrewingRecipe) {
                BrewingRecipe brewingRecipe = (BrewingRecipe)iBrewingRecipe2;
                ItemStack[] ingredients = brewingRecipe.getIngredient().m_43908_();
                if (ingredients.length <= 0) continue;
                Ingredient inputIngredient = brewingRecipe.getInput();
                ItemStack output = brewingRecipe.getOutput();
                ItemStack[] inputs = inputIngredient.m_43908_();
                IJeiBrewingRecipe recipe = this.vanillaRecipeFactory.createBrewingRecipe(Arrays.asList(ingredients), Arrays.asList(inputs), output);
                recipes.add(recipe);
                continue;
            }
            if (iBrewingRecipe instanceof VanillaBrewingRecipe || this.unhandledRecipeClasses.contains(recipeClass = iBrewingRecipe.getClass())) continue;
            this.unhandledRecipeClasses.add(recipeClass);
            LOGGER.debug("Can't handle brewing recipe class: {}", recipeClass);
        }
    }
}

