/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input.mouse.handlers;

import javax.annotation.Nullable;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.gui.Focus;
import mezz.jei.gui.GuiScreenHelper;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.input.UserInput;
import mezz.jei.input.mouse.IUserInputHandler;
import mezz.jei.util.MathUtil;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;

public class GuiAreaClickHandler
implements IUserInputHandler {
    private final GuiScreenHelper guiScreenHelper;
    private final RecipesGui recipesGui;

    public GuiAreaClickHandler(GuiScreenHelper guiScreenHelper, RecipesGui recipesGui) {
        this.guiScreenHelper = guiScreenHelper;
        this.recipesGui = recipesGui;
    }

    @Override
    @Nullable
    public IUserInputHandler handleUserInput(Screen screen, UserInput input) {
        if (!input.isLeftClick()) {
            return null;
        }
        Screen screen2 = screen;
        if (screen2 instanceof AbstractContainerScreen) {
            AbstractContainerScreen guiContainer = (AbstractContainerScreen)screen2;
            double mouseX = input.getMouseX();
            double mouseY = input.getMouseY();
            IGuiClickableArea clickableArea = this.guiScreenHelper.getGuiClickableArea(guiContainer, mouseX - (double)guiContainer.getGuiLeft(), mouseY - (double)guiContainer.getGuiTop());
            if (clickableArea != null) {
                InnerHandler clickHandler = new InnerHandler(this.recipesGui, clickableArea, guiContainer);
                return clickHandler.handleUserInput(screen, input);
            }
        }
        return null;
    }

    private static class InnerHandler
    implements IUserInputHandler {
        private final RecipesGui recipesGui;
        private final IGuiClickableArea clickableArea;
        private final AbstractContainerScreen<?> guiContainer;

        public InnerHandler(RecipesGui recipesGui, IGuiClickableArea clickableArea, AbstractContainerScreen<?> guiContainer) {
            this.recipesGui = recipesGui;
            this.clickableArea = clickableArea;
            this.guiContainer = guiContainer;
        }

        @Override
        @Nullable
        public IUserInputHandler handleUserInput(Screen screen, UserInput input) {
            Rect2i area = MathUtil.copyRect(this.clickableArea.getArea());
            area.m_173047_(area.m_110085_() + this.guiContainer.getGuiLeft());
            area.m_173054_(area.m_110086_() + this.guiContainer.getGuiTop());
            if (!MathUtil.contains(area, input.getMouseX(), input.getMouseY())) {
                return null;
            }
            if (!input.isSimulate()) {
                this.clickableArea.onClick(Focus::new, this.recipesGui);
            }
            return this;
        }
    }
}

