/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.config.IClientConfig;
import mezz.jei.config.IFilterTextSource;
import mezz.jei.config.IWorldConfig;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.GuiScreenHelper;
import mezz.jei.gui.PageNavigation;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.gui.overlay.IIngredientGridSource;
import mezz.jei.gui.overlay.IngredientGrid;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IPaged;
import mezz.jei.input.IRecipeFocusSource;
import mezz.jei.input.UserInput;
import mezz.jei.input.mouse.IUserInputHandler;
import mezz.jei.input.mouse.handlers.CombinedUserInputHandler;
import mezz.jei.render.IngredientListElementRenderer;
import mezz.jei.util.CommandUtil;
import mezz.jei.util.MathUtil;
import mezz.jei.util.Rectangle2dBuilder;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.Size2i;

public class IngredientGridWithNavigation
implements IRecipeFocusSource {
    private static final int NAVIGATION_HEIGHT = 20;
    private int firstItemIndex = 0;
    private final IngredientGridPaged pageDelegate;
    private final PageNavigation navigation;
    private final GuiScreenHelper guiScreenHelper;
    private final IFilterTextSource filterTextSource;
    private final IWorldConfig worldConfig;
    private final IClientConfig clientConfig;
    private final IngredientGrid ingredientGrid;
    private final IIngredientGridSource ingredientSource;
    private Rect2i area = new Rect2i(0, 0, 0, 0);

    public IngredientGridWithNavigation(IIngredientGridSource ingredientSource, IFilterTextSource filterTextSource, GuiScreenHelper guiScreenHelper, IngredientGrid ingredientGrid, IWorldConfig worldConfig, IClientConfig clientConfig) {
        this.filterTextSource = filterTextSource;
        this.worldConfig = worldConfig;
        this.clientConfig = clientConfig;
        this.ingredientGrid = ingredientGrid;
        this.ingredientSource = ingredientSource;
        this.guiScreenHelper = guiScreenHelper;
        this.pageDelegate = new IngredientGridPaged();
        this.navigation = new PageNavigation(this.pageDelegate, false);
    }

    public void updateLayout(boolean resetToFirstPage) {
        String filterText;
        List<IIngredientListElement<?>> ingredientList;
        if (resetToFirstPage) {
            this.firstItemIndex = 0;
        }
        if (this.firstItemIndex >= (ingredientList = this.ingredientSource.getIngredientList(filterText = this.filterTextSource.getFilterText())).size()) {
            this.firstItemIndex = 0;
        }
        this.ingredientGrid.guiIngredientSlots.set(this.firstItemIndex, ingredientList);
        this.navigation.updatePageState();
    }

    public boolean updateBounds(Rect2i availableArea, Set<Rect2i> guiExclusionAreas) {
        Tuple<Rect2i, Rect2i> result = MathUtil.splitY(availableArea, 20);
        Rect2i estimatedNavigationArea = (Rect2i)result.m_14418_();
        List<Rect2i> intersectsNavigationArea = guiExclusionAreas.stream().filter(rectangle2d -> MathUtil.intersects(rectangle2d, estimatedNavigationArea)).toList();
        int maxWidth = this.ingredientGrid.maxWidth();
        int maxHeight = availableArea.m_110091_();
        if (maxWidth <= 0 || maxHeight <= 0) {
            return false;
        }
        Size2i maxContentSize = new Size2i(maxWidth, maxHeight);
        if (MathUtil.contentArea(availableArea = MathUtil.cropToAvoidIntersection(intersectsNavigationArea, availableArea, maxContentSize), maxContentSize) == 0) {
            return false;
        }
        result = MathUtil.splitY(availableArea, 20);
        Rect2i navigationArea = (Rect2i)result.m_14418_();
        Rect2i boundsWithoutNavigation = (Rect2i)result.m_14419_();
        boolean gridHasRoom = this.ingredientGrid.updateBounds(boundsWithoutNavigation, guiExclusionAreas);
        if (!gridHasRoom) {
            return false;
        }
        Rect2i displayArea = this.ingredientGrid.getArea();
        navigationArea = new Rectangle2dBuilder(navigationArea).setX(displayArea).setWidth(displayArea).build();
        this.navigation.updateBounds(navigationArea);
        this.area = MathUtil.union(displayArea, navigationArea);
        return true;
    }

    public Rect2i getArea() {
        return this.area;
    }

    public void draw(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.ingredientGrid.draw(minecraft, poseStack, mouseX, mouseY);
        this.navigation.draw(minecraft, poseStack, mouseX, mouseY, partialTicks);
    }

    public void drawTooltips(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY) {
        this.ingredientGrid.drawTooltips(minecraft, poseStack, mouseX, mouseY);
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return MathUtil.contains(this.area, mouseX, mouseY) && !this.guiScreenHelper.isInGuiExclusionArea(mouseX, mouseY);
    }

    public IUserInputHandler createInputHandler() {
        return new CombinedUserInputHandler(new UserInputHandler(this.pageDelegate, this.ingredientGrid, this.worldConfig, this.clientConfig, this::isMouseOver), this.ingredientGrid.createInputHandler(), this.navigation.createInputHandler());
    }

    @Override
    @Nullable
    public IClickedIngredient<?> getIngredientUnderMouse(double mouseX, double mouseY) {
        return this.ingredientGrid.getIngredientUnderMouse(mouseX, mouseY);
    }

    public <T> Optional<IIngredientListElement<T>> getElementUnderMouse(IIngredientType<T> ingredientType) {
        return this.ingredientGrid.getElementUnderMouse(ingredientType);
    }

    public <T> List<IIngredientListElement<T>> getVisibleElements(IIngredientType<T> ingredientType) {
        return this.ingredientGrid.guiIngredientSlots.getAllGuiIngredientSlots().stream().map(slot -> slot.getIngredientRenderer(ingredientType)).filter(Objects::nonNull).map(IngredientListElementRenderer::getElement).toList();
    }

    private class IngredientGridPaged
    implements IPaged {
        private IngredientGridPaged() {
        }

        @Override
        public boolean nextPage() {
            String filterText = IngredientGridWithNavigation.this.filterTextSource.getFilterText();
            int itemsCount = IngredientGridWithNavigation.this.ingredientSource.getIngredientList(filterText).size();
            if (itemsCount > 0) {
                IngredientGridWithNavigation.this.firstItemIndex += IngredientGridWithNavigation.this.ingredientGrid.size();
                if (IngredientGridWithNavigation.this.firstItemIndex >= itemsCount) {
                    IngredientGridWithNavigation.this.firstItemIndex = 0;
                }
                IngredientGridWithNavigation.this.updateLayout(false);
                return true;
            }
            IngredientGridWithNavigation.this.firstItemIndex = 0;
            IngredientGridWithNavigation.this.updateLayout(false);
            return false;
        }

        @Override
        public boolean previousPage() {
            int itemsPerPage = IngredientGridWithNavigation.this.ingredientGrid.size();
            if (itemsPerPage == 0) {
                IngredientGridWithNavigation.this.firstItemIndex = 0;
                IngredientGridWithNavigation.this.updateLayout(false);
                return false;
            }
            String filterText = IngredientGridWithNavigation.this.filterTextSource.getFilterText();
            int itemsCount = IngredientGridWithNavigation.this.ingredientSource.getIngredientList(filterText).size();
            int pageNum = IngredientGridWithNavigation.this.firstItemIndex / itemsPerPage;
            pageNum = pageNum == 0 ? itemsCount / itemsPerPage : --pageNum;
            IngredientGridWithNavigation.this.firstItemIndex = itemsPerPage * pageNum;
            if (IngredientGridWithNavigation.this.firstItemIndex > 0 && IngredientGridWithNavigation.this.firstItemIndex == itemsCount) {
                IngredientGridWithNavigation.this.firstItemIndex = itemsPerPage * --pageNum;
            }
            IngredientGridWithNavigation.this.updateLayout(false);
            return true;
        }

        @Override
        public boolean hasNext() {
            String filterText = IngredientGridWithNavigation.this.filterTextSource.getFilterText();
            int itemsPerPage = IngredientGridWithNavigation.this.ingredientGrid.size();
            return itemsPerPage > 0 && IngredientGridWithNavigation.this.ingredientSource.getIngredientList(filterText).size() > itemsPerPage;
        }

        @Override
        public boolean hasPrevious() {
            String filterText = IngredientGridWithNavigation.this.filterTextSource.getFilterText();
            int itemsPerPage = IngredientGridWithNavigation.this.ingredientGrid.size();
            return itemsPerPage > 0 && IngredientGridWithNavigation.this.ingredientSource.getIngredientList(filterText).size() > itemsPerPage;
        }

        @Override
        public int getPageCount() {
            String filterText = IngredientGridWithNavigation.this.filterTextSource.getFilterText();
            int itemCount = IngredientGridWithNavigation.this.ingredientSource.getIngredientList(filterText).size();
            int stacksPerPage = IngredientGridWithNavigation.this.ingredientGrid.size();
            if (stacksPerPage == 0) {
                return 1;
            }
            int pageCount = MathUtil.divideCeil(itemCount, stacksPerPage);
            pageCount = Math.max(1, pageCount);
            return pageCount;
        }

        @Override
        public int getPageNumber() {
            int stacksPerPage = IngredientGridWithNavigation.this.ingredientGrid.size();
            if (stacksPerPage == 0) {
                return 0;
            }
            return IngredientGridWithNavigation.this.firstItemIndex / stacksPerPage;
        }
    }

    private static class UserInputHandler
    implements IUserInputHandler {
        private final IngredientGridPaged paged;
        private final IRecipeFocusSource focusSource;
        private final IWorldConfig worldConfig;
        private final IClientConfig clientConfig;
        private final UserInput.MouseOverable mouseOverable;

        private UserInputHandler(IngredientGridPaged paged, IRecipeFocusSource focusSource, IWorldConfig worldConfig, IClientConfig clientConfig, UserInput.MouseOverable mouseOverable) {
            this.paged = paged;
            this.focusSource = focusSource;
            this.worldConfig = worldConfig;
            this.clientConfig = clientConfig;
            this.mouseOverable = mouseOverable;
        }

        @Override
        public boolean handleMouseScrolled(double mouseX, double mouseY, double scrollDelta) {
            if (!this.mouseOverable.isMouseOver(mouseX, mouseY)) {
                return false;
            }
            if (scrollDelta < 0.0) {
                this.paged.nextPage();
                return true;
            }
            if (scrollDelta > 0.0) {
                this.paged.previousPage();
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public IUserInputHandler handleUserInput(Screen screen, UserInput input) {
            if (input.is(KeyBindings.nextPage)) {
                this.paged.nextPage();
                return this;
            }
            if (input.is(KeyBindings.previousPage)) {
                this.paged.previousPage();
                return this;
            }
            if (this.clientConfig.isCheatToHotbarUsingHotkeysEnabled() && this.checkHotbarKeys(screen, input)) {
                return this;
            }
            return null;
        }

        protected boolean checkHotbarKeys(Screen screen, UserInput input) {
            double mouseY;
            Minecraft minecraft = screen.getMinecraft();
            if (!this.worldConfig.isCheatItemsEnabled() || screen instanceof RecipesGui) {
                return false;
            }
            double mouseX = input.getMouseX();
            if (!this.mouseOverable.isMouseOver(mouseX, mouseY = input.getMouseY())) {
                return false;
            }
            Options gameSettings = minecraft.f_91066_;
            int hotbarSlot = UserInputHandler.getHotbarSlotForInput(input, gameSettings);
            if (hotbarSlot < 0) {
                return false;
            }
            IClickedIngredient<?> ingredientUnderMouse = this.focusSource.getIngredientUnderMouse(mouseX, mouseY);
            if (ingredientUnderMouse == null) {
                return false;
            }
            ItemStack itemStack = ingredientUnderMouse.getCheatItemStack();
            if (itemStack.m_41619_()) {
                return false;
            }
            CommandUtil.setHotbarStack(itemStack, hotbarSlot);
            return true;
        }

        private static int getHotbarSlotForInput(UserInput input, Options gameSettings) {
            for (int hotbarSlot = 0; hotbarSlot < gameSettings.f_92056_.length; ++hotbarSlot) {
                KeyMapping keyHotbarSlot = gameSettings.f_92056_[hotbarSlot];
                if (!input.is(keyHotbarSlot)) continue;
                return hotbarSlot;
            }
            return -1;
        }
    }
}

